/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class Java8DateUtils {
    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static LocalDate currentLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime currentLocalTime() {
        return LocalTime.now();
    }

    public static LocalDateTime currentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static String getCurrentDateStr() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(Java8DateUtils.currentLocalDateTime());
    }

    public static String getCurrentTimeStr() {
        return DateTimeFormatter.ofPattern("HH:mm:ss").format(Java8DateUtils.currentLocalDateTime());
    }

    public static String getCurrentDateTimeStr() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(Java8DateUtils.currentLocalDateTime());
    }

    public static String getCurrentDateDTimeStr() {
        return DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss").format(Java8DateUtils.currentLocalDateTime());
    }

    public static LocalDateTime convertStringToLocalDateTime(String time, String format) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(format));
        }
        return null;
    }

    public static LocalDateTime convertStringToLocalDateTime(String time) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return null;
    }

    public static LocalDate convertStringToLocalDate(String time, String format) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalDate.parse(time, DateTimeFormatter.ofPattern(format));
        }
        return null;
    }

    public static LocalDate convertStringToLocalDate(String time) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return null;
    }

    public static LocalTime convertStringToLocalTime(String time, String format) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalTime.parse(time, DateTimeFormatter.ofPattern(format));
        }
        return null;
    }

    public static LocalTime convertStringToLocalTime(String time) {
        if (HussarUtils.isNotBlank((CharSequence)time)) {
            return LocalTime.parse(time, DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        return null;
    }

    public static String convertLocalDateTimeToString(LocalDateTime localDateTime, String format) {
        if (HussarUtils.isNotEmpty((Object)localDateTime)) {
            return localDateTime.format(DateTimeFormatter.ofPattern(format));
        }
        return null;
    }

    public static String convertLocalDateTimeToString(LocalDateTime localDateTime) {
        if (HussarUtils.isNotEmpty((Object)localDateTime)) {
            return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return null;
    }

    public static String convertLocalDateToString(LocalDate localDate) {
        if (HussarUtils.isNotEmpty((Object)localDate)) {
            return localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return null;
    }

    public static String convertLocalTimeToString(LocalTime localTime) {
        if (HussarUtils.isNotEmpty((Object)localTime)) {
            return localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        return null;
    }

    public static LocalDateTime convertTimestampToLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static long convertLocalDateTimeToTimestamp(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static String getMaxDateTime(LocalDateTime localDateTime) {
        return Java8DateUtils.convertLocalDateTimeToString(localDateTime.with(LocalTime.MAX), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getMinDateTime(LocalDateTime localDateTime) {
        return Java8DateUtils.convertLocalDateTimeToString(localDateTime.with(LocalTime.MIN), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getMaxDateTime(LocalDate localDate) {
        return Java8DateUtils.convertLocalDateTimeToString(localDate.atTime(LocalTime.MAX), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getMinDateTime(LocalDate localDate) {
        return Java8DateUtils.convertLocalDateTimeToString(localDate.atTime(LocalTime.MIN), "yyyy-MM-dd HH:mm:ss");
    }
}

