/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.lang.reflect.Method;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class HussarReflectionUtils
implements ApplicationContextAware,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarReflectionUtils.class);
    private static ApplicationContext applicationContext = null;

    public static <T> T getBean(Class<T> requiredType) {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728SpringBoot\u542f\u52a8\u7c7b\u4e2d\u6ce8\u518cBeanUtil.");
        }
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T getBean(String beanName) {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728SpringBoot\u542f\u52a8\u7c7b\u4e2d\u6ce8\u518cBeanUtil.");
        }
        return (T)applicationContext.getBean(beanName);
    }

    public void destroy() {
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (HussarReflectionUtils.applicationContext != null) {
            LOGGER.warn("HussarReflectionUtilsUtil\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + HussarReflectionUtils.applicationContext);
        }
        HussarReflectionUtils.applicationContext = applicationContext;
    }

    public static Object springInvokeMethod(String beanName, String methodName, Class<? extends Object>[] paramClass, Object[] params) {
        Object service = HussarReflectionUtils.getBean(beanName);
        Method method = ReflectionUtils.findMethod(service.getClass(), (String)methodName, (Class[])paramClass);
        if (method != null) {
            Object[] newParams = new Object[params.length];
            for (int i = 0; i < paramClass.length; ++i) {
                Class<? extends Object> clazz = paramClass[i];
                Object param = params[i];
                newParams[i] = ToolUtil.isNotEmpty((Object)param) && !param.getClass().getName().equals(clazz.getName()) ? JSONObject.parseObject((String)JSONObject.toJSONString((Object)params[i]), clazz) : param;
            }
            return ReflectionUtils.invokeMethod((Method)method, service, (Object[])newParams);
        }
        return null;
    }

    public static String getBeanName(Class clazz) {
        String[] s = clazz.getName().split("\\.");
        String word = WordUtils.uncapitalize((String)clazz.getSimpleName());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < s.length - 1; ++i) {
            stringBuilder.append(s[i]).append(".");
        }
        if (word.indexOf("$") != -1) {
            word = word.substring(0, word.indexOf("$"));
        }
        stringBuilder.append(word);
        return stringBuilder.toString();
    }
}

