/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.security;

import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BaseSecurityUtil {
    public static SecurityUser getUser() {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            return BaseSecurityUtil.getSecurityUser(userDetails);
        }
        Environment environment = SpringContextHolder.environment;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (HussarUtils.isEmpty((Object)requestAttributes) || HussarUtils.isEmpty((Object)environment)) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String tokenHeader = environment.getProperty("hussar.security.oauth2.header-token-key");
        if (HussarUtils.isBlank((CharSequence)tokenHeader)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)request)) {
            return null;
        }
        return BaseSecurityUtil.getUser(request.getHeader(tokenHeader));
    }

    public static SecurityUser getUser(String token) {
        if (HussarUtils.isBlank((CharSequence)token)) {
            return null;
        }
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails((String)token);
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            return BaseSecurityUtil.getSecurityUser(userDetails);
        }
        return null;
    }

    private static SecurityUser getSecurityUser(UserDetails userDetails) {
        SecurityUser securityUser = SecurityUser.convert(userDetails);
        Map extendUserMap = userDetails.getExtendUserMap();
        securityUser.setId(userDetails.getUserId());
        securityUser.setAccount((String)extendUserMap.get("account"));
        securityUser.setConnName((String)extendUserMap.get("connName"));
        securityUser.setTenantCode(userDetails.getTenantCode());
        securityUser.setTenantId(userDetails.getTenantId());
        securityUser.setTenantName((String)extendUserMap.get("tenantName"));
        securityUser.setTenantCipher((String)extendUserMap.get("tenantCipher"));
        securityUser.addExtendUserMap("bpmTenantId", extendUserMap.get("bpmTenantId"));
        securityUser.addExtendUserMap("bpmTenantCipher", extendUserMap.get("bpmTenantId"));
        securityUser.setDeptId(BaseSecurityUtil.formatToLong(extendUserMap.get("deptId")));
        securityUser.setEmployeeId(BaseSecurityUtil.formatToLong(extendUserMap.get("employeeId")));
        securityUser.setDeptName((String)extendUserMap.get("deptName"));
        securityUser.setDeptCode((String)extendUserMap.get("deptCode"));
        securityUser.setDeptIcon((String)extendUserMap.get("deptIcon"));
        Object securityLevel = extendUserMap.get("securityLevel");
        if (securityLevel != null) {
            securityUser.setSecurityLevel(BaseSecurityUtil.formatToInteger(securityLevel));
        }
        securityUser.setAccountStatus((String)extendUserMap.get("accountStatus"));
        securityUser.addExtendUserMap("showTenant", extendUserMap.get("showTenant"));
        securityUser.addExtendUserMap("gradeAdmin", extendUserMap.get("gradeAdmin"));
        securityUser.setRolesList(BaseSecurityUtil.formatToLongList(extendUserMap.get("rolesList")));
        securityUser.addExtendUserMap("theme", extendUserMap.get("theme"));
        securityUser.addExtendUserMap("welcomeUrl", extendUserMap.get("welcomeUrl"));
        securityUser.addExtendUserMap("permissions", extendUserMap.get("permissions"));
        securityUser.addExtendUserMap("tenantName", extendUserMap.get("tenantName"));
        securityUser.addExtendUserMap("tcode", extendUserMap.get("tcode"));
        securityUser.addExtendUserMap("connName", extendUserMap.get("connName"));
        securityUser.addExtendUserMap("baseConnName", extendUserMap.get("connName"));
        return securityUser;
    }

    public static Long formatToLong(Object obj) {
        if (ToolUtil.isNotEmpty((Object)obj)) {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            return Long.valueOf(obj.toString());
        }
        return null;
    }

    public static Integer formatToInteger(Object obj) {
        if (ToolUtil.isNotEmpty((Object)obj)) {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            return Integer.parseInt(obj.toString());
        }
        return null;
    }

    private static BigDecimal formatToBigDecimal(Object obj) {
        if (ToolUtil.isNotEmpty((Object)obj)) {
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            return BigDecimal.valueOf(Long.valueOf(obj.toString()));
        }
        return null;
    }

    public static List<Long> formatToLongList(Object obj) {
        ArrayList<Long> longList = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)obj)) {
            if (obj instanceof List) {
                List list = (List)obj;
                for (Object object : list) {
                    if (object instanceof Long) {
                        longList.add((Long)object);
                        continue;
                    }
                    longList.add(Long.valueOf(object.toString()));
                }
            }
            return longList;
        }
        return null;
    }

    public static String getSessionId() {
        return HussarSecurityUtils.getSecuritySessionId();
    }

    public static boolean hasRole(String roleName) {
        return true;
    }

    public static boolean hasPermission(String permission) {
        return true;
    }

    public static boolean isAuthenticated() {
        return true;
    }

    public static boolean isUser() {
        return true;
    }

    public static boolean isGuest() {
        return !BaseSecurityUtil.isUser();
    }

    public static boolean isAdmin() {
        List<Long> roleList;
        boolean flag = false;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (null != shiroUser && HussarUtils.isNotEmpty(roleList = shiroUser.getRolesList())) {
            for (Long roleId : roleList) {
                if (!SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(roleId)) continue;
                flag = true;
            }
        }
        return flag;
    }

    public static boolean isGradeadmin() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        return shiroUser == null ? false : shiroUser.isGradeadmin();
    }

    public static Integer getSecurityLevel() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (shiroUser != null) {
            return shiroUser.getSecurityLevel();
        }
        return null;
    }

    public static void setAttribute(String key, Object value) {
        if (ToolUtil.isNotEmpty((Object)key) && ToolUtil.isNotEmpty((Object)value)) {
            HussarSecurityUtils.putSessionExtend((String)key, (Object)value);
        }
    }

    public static Object getAttribute(String key) {
        return HussarSecurityUtils.getSessionExtend((String)key);
    }

    public static String getTokenName() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)((Object)user))) {
            return null;
        }
        return user.getTokenName();
    }

    public static String getTokenValue() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)((Object)user))) {
            return null;
        }
        return user.getTokenValue();
    }
}

