/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.exception;

import com.jxdinfo.hussar.common.exception.BadFileException;
import com.jxdinfo.hussar.common.exception.BaseCaptchaCodeErrorException;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseDynamicPasswordErrorException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseLockedAccountException;
import com.jxdinfo.hussar.common.exception.BaseLoginIpRefuseException;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseMailboxNotConfigureException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.exception.BaseWithdrawException;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.common.exception.HussarCredentialsException;
import com.jxdinfo.hussar.common.exception.HussarDisabledAccountException;
import com.jxdinfo.hussar.common.exception.ResourceWithAdminException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.exception.TenantDisableException;
import com.jxdinfo.hussar.common.exception.TenantOverdueException;
import com.jxdinfo.hussar.core.support.exception.NoLicenseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLSyntaxErrorException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
public class BaseGlobalExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(BaseGlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public ApiResponse<?> handlerBaseExceotion(BaseException e, HttpServletResponse response) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        this.toJsonContentType(response);
        return ApiResponse.fail((int)BaseExceptionEnum.BUSSINESS_EXCEPTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BadFileException.class})
    public ApiResponse<?> handlerBadFileException(BadFileException e, HttpServletResponse response) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        this.toJsonContentType(response);
        return ApiResponse.fail((int)BaseExceptionEnum.FILE_READING_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ResourceWithAdminException.class})
    public ApiResponse<?> handlerResourceWithAdminException(ResourceWithAdminException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.DELETE_FAIL_WITH_ADMIN.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ResourceWithFunctionException.class})
    public ApiResponse<?> handlerResourceWithFunctionException(ResourceWithFunctionException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.DELETE_FAIL_WITH_FUNCTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class})
    public ApiResponse<?> handlerException(Exception e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)901, (String)"\u5b58\u5728\u91cd\u590d\u6570\u636e");
    }

    @ExceptionHandler(value={HussarCredentialsException.class})
    public ApiResponse<?> handlerException(HussarCredentialsException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)11000, (String)e.getMessage());
    }

    @ExceptionHandler(value={HussarDisabledAccountException.class})
    public ApiResponse<?> handlerException(HussarDisabledAccountException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)12000, (String)e.getMessage());
    }

    @ExceptionHandler(value={NoLicenseException.class})
    public ApiResponse<?> handlerException(NoLicenseException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)BaseExceptionEnum.NO_LICENSE.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseCaptchaCodeErrorException.class})
    public ApiResponse<?> handlerException(BaseCaptchaCodeErrorException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.CAPTCHA_CODE_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseDisabledAccountException.class})
    public ApiResponse<?> handlerException(BaseDisabledAccountException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.ACCOUNT_DISABLE.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseDormancyException.class})
    public ApiResponse<?> handlerException(BaseDormancyException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.ACCOUNT_DORMANCY.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseDynamicPasswordErrorException.class})
    public ApiResponse<?> handlerException(BaseDynamicPasswordErrorException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.DYNAMIC_PASSWORD_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseLockedAccountException.class})
    public ApiResponse<?> handlerException(BaseLockedAccountException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.ACCOUNT_LOCKED.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseLoginIpRefuseException.class})
    public ApiResponse<?> handlerException(BaseLoginIpRefuseException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.LOGIN_IP_REFUSED.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseLoginTimeRefuseException.class})
    public ApiResponse<?> handlerException(BaseLoginTimeRefuseException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.LOGINTIME_REFUSED.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseMailboxNotConfigureException.class})
    public ApiResponse<?> handlerException(BaseMailboxNotConfigureException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.Mailbox_Not_Configure.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseTemporaryAccountInvalidException.class})
    public ApiResponse<?> handlerException(BaseTemporaryAccountInvalidException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.TEMPORARYACCOUNT_INVALID.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseUsernameOrPasswordErrorException.class})
    public ApiResponse<?> handlerException(BaseUsernameOrPasswordErrorException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseWithdrawException.class})
    public ApiResponse<?> handlerException(BaseWithdrawException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.ACCOUNT_WITHDRAW.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ExtendLoginException.class})
    public ApiResponse<?> handlerException(ExtendLoginException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.EXTEND_LOGIN_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={SQLSyntaxErrorException.class})
    public ApiResponse<?> handlerException(SQLSyntaxErrorException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)BaseExceptionEnum.SQL_SYNTAX_ERROR.getCode(), (String)BaseExceptionEnum.SQL_SYNTAX_ERROR.getMessage());
    }

    @ExceptionHandler(value={TenantOverdueException.class})
    public ApiResponse<?> handlerTenantOverdueException(TenantOverdueException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.TENANT_OVERDUE.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={TenantDisableException.class})
    public ApiResponse<?> handlerTenantDisableException(TenantDisableException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)((Object)e));
        return ApiResponse.fail((int)BaseExceptionEnum.TENANT_DISABLE.getCode(), (String)e.getMessage());
    }

    private void toJsonContentType(HttpServletResponse response) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }
}

