/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.core.utils;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA256 {
    private static Logger log = LoggerFactory.getLogger(RSA256.class);
    private static RSA256 instance;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private static final char[] HEX_CHAR;

    public static RSA256 getInstance() {
        if (instance == null) {
            instance = new RSA256();
        }
        return instance;
    }

    public RSA256() {
        String public_key = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHRHbvkUxeFH5i7Ozn5X5G04B1\r\nI+RraZUW9S0c2FQ29YEgP9alu3yl9MSCoFrLCbfZnw+cIDNxvBQJxXQuh6wR1dN6\r\ngtOPOfgQ0d6Fz5isl99KgNhCLgw37VB85l4VJdHIR/4kxgLi5KTMFeB1EhKFWyu9\r\nygWBL4bLcxr6/04PCQIDAQAB";
        String private_key = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMdEdu+RTF4UfmLs\r\n7OflfkbTgHUj5GtplRb1LRzYVDb1gSA/1qW7fKX0xIKgWssJt9mfD5wgM3G8FAnF\r\ndC6HrBHV03qC0485+BDR3oXPmKyX30qA2EIuDDftUHzmXhUl0chH/iTGAuLkpMwV\r\n4HUSEoVbK73KBYEvhstzGvr/Tg8JAgMBAAECgYBqA6fPTxs1FmwjT2++9F7ZaZ73\r\nM3BMITEbtLcamJE9aCIZuT0GkZgAZxfBc3S6fuIcWr6gTpVwFiMHC9EDDFVjesbr\r\nCiYwgsGAAafmeXDENOOUVQHE+cBGBgqqLUvWU6eU/ivwRsOvXFum0Anwb3B8Sl6K\r\nVVBLNL599FH3R1jIMQJBAPMrDGcOzWzFQ/BVrXxvQMuEYc/WJPZ6YBtOSMKmKNEn\r\nD+P0AtVsMbGrg3GO6ajfx3nY7pVWRbkcVy/PstzGtU0CQQDRyFzU8bVZgAyYaDVC\r\nfkb+keSY+B08Ouup+VUsHEdoLPzo7SKPCIZGwObgJt5JaDlkOKEc1R04RhcsNBc7\r\nzrKtAkEAhioHQslBADVqwayT9qbvahqVWPW/GRr18brknDjPJm7V7qCP+68hT/Tg\r\npgQC2YD2bz0Ije62s2Z2mFORTQx5tQJABk8jU5gtXxK1zkOcDnLjybYzjNIxduVC\r\nvyrrf9cd4qkvtgWju2+DMk+M4gLpPoXu6++0ELzsEwwwmDi81iSiRQJAbMe749+6\r\nrZxyeuw3yBmzllDM20ryImWUW9yqs7WrVzbCHoi41mnzp2mgfkAe9tyqwB1fsgeT\r\no5YD7N/ilV3d/A==";
        this.loadPublicKey(public_key);
        this.loadPrivateKey(private_key);
    }

    public String decryptWithBase64(String base64String) {
        byte[] binaryData = this.decrypt(this.getPrivateKey(), Base64.decodeBase64((byte[])base64String.getBytes()));
        String string = new String(binaryData);
        return string;
    }

    public String encryptWithBase64(String string) {
        byte[] binaryData = this.encrypt(this.getPublicKey(), string.getBytes());
        String base64String = new Base64().encodeToString(binaryData);
        return base64String;
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void genKeyPair() {
        try {
            KeyPairGenerator keyPairGen = null;
            keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            this.privateKey = (RSAPrivateKey)keyPair.getPrivate();
            this.publicKey = (RSAPublicKey)keyPair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void loadPublicKey(InputStream in) throws Exception {
        try {
            StringBuilder sb;
            if (in != null) {
                String readLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                sb = new StringBuilder();
                while ((readLine = br.readLine()) != null) {
                    if (readLine.charAt(0) == '-') continue;
                    sb.append(readLine);
                    sb.append('\r');
                }
            } else {
                throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
            }
            this.loadPublicKey(sb.toString());
        }
        catch (IOException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
    }

    public void loadPublicKey(String publicKeyStr) {
        try {
            if (ToolUtil.isNotEmpty((Object)publicKeyStr)) {
                byte[] buffer = new Base64().decode(publicKeyStr);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
                this.publicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
            } else {
                log.error("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            log.error("\u516c\u94a5\u975e\u6cd5");
        }
    }

    public void loadPrivateKey(InputStream in) throws Exception {
        try {
            if (in != null) {
                String readLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                StringBuilder sb = new StringBuilder();
                while ((readLine = br.readLine()) != null) {
                    if (readLine.charAt(0) == '-') continue;
                    sb.append(readLine);
                    sb.append('\r');
                }
                this.loadPrivateKey(sb.toString());
            } else {
                log.error("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
            }
        }
        catch (IOException e) {
            log.error("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
    }

    public void loadPrivateKey(String privateKeyStr) {
        try {
            if (ToolUtil.isNotEmpty((Object)privateKeyStr)) {
                byte[] buffer = new Base64().decode(privateKeyStr);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
            } else {
                log.error("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u79c1\u94a5\u975e\u6cd5");
        }
    }

    public byte[] encrypt(RSAPublicKey publicKey, byte[] plainTextData) {
        if (publicKey == null) {
            log.error("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error("\u52a0\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            log.error("\u660e\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            log.error("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        return null;
    }

    public byte[] decrypt(RSAPrivateKey privateKey, byte[] cipherData) {
        if (privateKey == null) {
            log.error("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InvalidKeyException e) {
            log.error("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            log.error("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            log.error("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        return null;
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            stringBuilder.append(HEX_CHAR[(data[i] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_CHAR[data[i] & 0xF]);
            if (i >= data.length - 1) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    static {
        HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

