/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.converter;

import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class ConverterInitCommand
implements CommandLineRunner {
    protected static final Logger logger = LoggerFactory.getLogger(ConverterInitCommand.class);

    public void run(String ... args) throws Exception {
        String publicKey_backend = (String)HussarCacheUtil.get((String)"SM2BackEndPubKey", (Object)"SM2BackEndPubKey");
        String privateKey_backend = (String)HussarCacheUtil.get((String)"SM2BackEndPriKey", (Object)"SM2BackEndPriKey");
        String publicKey_fronend = (String)HussarCacheUtil.get((String)"SM2FronEndPubKey", (Object)"SM2FronEndPubKey");
        String privateKey_fronend = (String)HussarCacheUtil.get((String)"SM2FronEndPriKey", (Object)"SM2FronEndPriKey");
        if (publicKey_backend == null || privateKey_backend == null || publicKey_fronend == null || privateKey_fronend == null) {
            Map keyMapBackEnd = SM2Util.generateKeyPair();
            Map keyMapFronEnd = SM2Util.generateKeyPair();
            publicKey_backend = (String)keyMapFronEnd.get("pubKey");
            privateKey_backend = (String)keyMapBackEnd.get("priKey");
            publicKey_fronend = (String)keyMapBackEnd.get("pubKey");
            privateKey_fronend = (String)keyMapFronEnd.get("priKey");
            HussarCacheUtil.put((String)"SM2BackEndPubKey", (Object)"SM2BackEndPubKey", (Object)publicKey_backend);
            HussarCacheUtil.put((String)"SM2BackEndPriKey", (Object)"SM2BackEndPriKey", (Object)privateKey_backend);
            HussarCacheUtil.put((String)"SM2FronEndPubKey", (Object)"SM2FronEndPubKey", (Object)publicKey_fronend);
            HussarCacheUtil.put((String)"SM2FronEndPriKey", (Object)"SM2FronEndPriKey", (Object)privateKey_fronend);
        } else {
            logger.debug("SM2\u5bc6\u94a5\u5df2\u521d\u59cb\u5316\u5b8c\u6210^-^");
        }
    }
}

