/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.config;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class LocalMessageConfig {
    private static final Logger logger = LoggerFactory.getLogger(LocalMessageConfig.class);

    @Bean(name={"messageSource"})
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        String[] strings = this.scanModelsForI18nFolders();
        messageSource.setBasenames(strings);
        messageSource.setDefaultEncoding("UTF-8");
        logger.info("\u52a0\u8f7dmessageSource\uff1a{}", (Object)StringUtils.join((Iterable)Arrays.stream(strings).map(String::toString).collect(Collectors.toList()), (String)","));
        return messageSource;
    }

    public String[] scanModelsForI18nFolders() {
        try {
            String resourcePattern = "classpath*:i18n/*_message.properties";
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resourcePatternResolver.getResources(resourcePattern);
            String[] paths = new String[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                String[] urlStrArr = resource.getURL().toString().split("/");
                int index = urlStrArr.length - 1;
                String moduleName = urlStrArr[index];
                paths[i] = "classpath:i18n/" + moduleName.substring(0, moduleName.length() - 11);
            }
            return paths;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

