/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.scan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.mobile.util.TokenUtil;
import com.jxdinfo.hussar.code.scan.client.WxClient;
import com.jxdinfo.hussar.code.scan.constant.WxConstant;
import com.jxdinfo.hussar.code.scan.enums.CodeTipsEnum;
import com.jxdinfo.hussar.code.scan.service.IHussarCodeScanService;
import com.jxdinfo.hussar.code.scan.vo.WxConfigParam;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.Instant;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarCodeScanServiceImpl
implements IHussarCodeScanService {
    @Autowired
    SeqBuilder snowflakeSeqBuilder;
    @Autowired
    private WxClient wxClient;

    public WxConfigParam getWxConfigParam(String url) {
        WxConfigParam wxConfigParam = new WxConfigParam();
        Sequence sequence = this.snowflakeSeqBuilder.build();
        String nonceStr = String.valueOf(sequence.nextValue());
        long timeStamp = Instant.now().toEpochMilli() / 1000L;
        String accessToken = TokenUtil.getWeChatWorkToken((String)"1");
        if (HussarUtils.isEmpty((Object)accessToken)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)CodeTipsEnum.WECHAT_ACCESS_TOKEN_CACHE_NOT_FOUND.getMessage()));
            }
            throw new HussarException("\u4f01\u4e1a\u5fae\u4fe1accessToken\u7f13\u5b58\u4e0d\u5b58\u5728");
        }
        String jsapiTicket = (String)HussarCacheUtil.get((String)"mobile:jsapiTicket", (Object)"mobile:jsapiTicket");
        if (HussarUtils.isEmpty((Object)jsapiTicket)) {
            jsapiTicket = this.getJsapiTicket(accessToken);
        }
        String signature = this.getSignatures(nonceStr, timeStamp, jsapiTicket, url);
        wxConfigParam.setNonceStr(nonceStr);
        wxConfigParam.setTimeStamp(Long.valueOf(timeStamp));
        wxConfigParam.setSignature(signature);
        return wxConfigParam;
    }

    private String getSignatures(String nonceStr, long timeStamp, String jsapiTicket, String url) {
        Object[] params = new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + nonceStr, "timestamp=" + timeStamp, "url=" + url};
        Arrays.sort(params);
        StringBuffer sb = new StringBuffer();
        for (Object param : params) {
            sb.append((String)param).append("&");
        }
        String stringToSign = sb.substring(0, sb.length() - 1);
        return DigestUtils.sha1Hex((String)stringToSign);
    }

    private String getJsapiTicket(String accessToken) {
        String result = this.wxClient.getJsapiTicket(accessToken);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        String jsapiTicket = jsonObject.get((Object)"ticket").toString();
        HussarCacheUtil.put((String)"mobile:jsapiTicket", (Object)"mobile:jsapiTicket", (Object)jsapiTicket, (long)WxConstant.EFFECT_SECOND.intValue());
        return jsapiTicket;
    }
}

