/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.migration;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.CodeRulesMigrationLoadVo;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CodeRulesMigrationPlugin
implements MigrationPlugin {
    public static final String TYPE = "codeRules";
    public static final Long VERSION = null;
    public static final int DUMP_PRECEDENCE = 0;
    @Resource
    private ISysCodeRuleService codeRuleService;
    @Resource
    private ISysCodeRuleInfoService codeRuleInfoService;
    @Resource
    private ISysCodeRuleRefService sysCodeRuleRefService;

    public MigrationPluginMetadata metadata() {
        return Metadata.INSTANCE;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        List sysCodeRuleVos = new ArrayList();
        SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
        if (parameters.get(TYPE) == null) {
            return MigrationDumpItemVo.success((Long)0L, sysCodeRuleVos);
        }
        sysCodeRuleDto = (SysCodeRuleDto)JsonUtil.convertValue((Object)parameters.get(TYPE), (TypeReference)new TypeReference<SysCodeRuleDto>(){});
        sysCodeRuleVos = this.codeRuleService.getCodeRulesList(sysCodeRuleDto);
        context.setAttribute("codeRuleDumpFileMsg", sysCodeRuleVos);
        return MigrationDumpItemVo.success((Long)Long.valueOf(sysCodeRuleDto.getCodeRuleIds().size()), sysCodeRuleVos);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        ArrayList<SysCodeRuleVo> sysCodeRuleVos = new ArrayList();
        if (context.getAttribute("codeRuleDumpFileMsg") != null) {
            sysCodeRuleVos = (List)JsonUtil.convertValue((Object)context.getAttribute("codeRuleDumpFileMsg"), (TypeReference)new TypeReference<List<SysCodeRuleVo>>(){});
            return MigrationPreloadItemVo.success(this.getCodeRulesLoadVoList(sysCodeRuleVos));
        }
        return MigrationPreloadItemVo.success((Object)new CodeRulesMigrationLoadVo());
    }

    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        if (HussarUtils.isEmpty((Object)context.getAttribute("codeRuleDumpFileMsg"))) {
            return MigrationLoadItemVo.success((Long)0L, (Object)new SysCodeRuleVo());
        }
        List codeRulesMigrationLoadVos = new ArrayList();
        ArrayList<CodeRulesMigrationLoadVo> newCodeRulesMigrationLoadVos = new ArrayList<CodeRulesMigrationLoadVo>();
        if (parameters != null && parameters.get(TYPE) != null) {
            codeRulesMigrationLoadVos = JSON.parseArray((String)JSON.toJSONString((Object)parameters.get(TYPE)), CodeRulesMigrationLoadVo.class);
            for (CodeRulesMigrationLoadVo c : codeRulesMigrationLoadVos) {
                if (!HussarUtils.isNotEmpty((Object)c.getCodeRuleId())) continue;
                newCodeRulesMigrationLoadVos.add(c);
            }
        }
        this.doLoad(newCodeRulesMigrationLoadVos);
        long successCount = 0L;
        for (CodeRulesMigrationLoadVo codeRulesMigrationLoadVo : newCodeRulesMigrationLoadVos) {
            codeRulesMigrationLoadVo.setSysCodeRuleVo(null);
            ++successCount;
        }
        return MigrationLoadItemVo.success((Long)successCount, newCodeRulesMigrationLoadVos);
    }

    private List<CodeRulesMigrationLoadVo> getCodeRulesLoadVoList(List<SysCodeRuleVo> sysCodeRuleVos) {
        HashMap existingCodeRuleMap = new HashMap();
        if (HussarUtils.isNotEmpty(sysCodeRuleVos)) {
            List codeRuleCodes = sysCodeRuleVos.stream().map(SysCodeRuleVo::getCodeRuleCode).collect(Collectors.toList());
            SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
            sysCodeRuleDto.setCodeRuleCodes(codeRuleCodes);
            List existingCodeRules = this.codeRuleService.getCodeRulesList(sysCodeRuleDto);
            if (HussarUtils.isNotEmpty((Object)existingCodeRules)) {
                existingCodeRules.forEach(rule -> existingCodeRuleMap.put(rule.getCodeRuleCode(), rule));
            }
        }
        ArrayList<CodeRulesMigrationLoadVo> codeRulesMigrationLoadVos = new ArrayList<CodeRulesMigrationLoadVo>();
        for (SysCodeRuleVo importRule : sysCodeRuleVos) {
            CodeRulesMigrationLoadVo loadVo = new CodeRulesMigrationLoadVo();
            HussarUtils.copy((Object)importRule, (Object)loadVo);
            loadVo.setSysCodeRuleVo(importRule);
            if (existingCodeRuleMap.containsKey(importRule.getCodeRuleCode())) {
                SysCodeRuleVo existingRule = (SysCodeRuleVo)existingCodeRuleMap.get(importRule.getCodeRuleCode());
                if (HussarUtils.isNotEmpty((Object)importRule.getCodeRuleId()) && HussarUtils.isNotEmpty((Object)existingRule.getCodeRuleId()) && !importRule.getCodeRuleId().equals(existingRule.getCodeRuleId())) {
                    throw new BaseException("\u5b58\u5728\u51b2\u7a81\u7f16\u7801\u89c4\u5219\uff1a" + importRule.getCodeRuleCode() + "\u3002\u5bfc\u5165\u6570\u636eID\uff1a" + importRule.getCodeRuleId() + "\uff0c\u7cfb\u7edf\u5df2\u5b58\u5728ID\uff1a" + existingRule.getCodeRuleId());
                }
            }
            codeRulesMigrationLoadVos.add(loadVo);
        }
        return codeRulesMigrationLoadVos;
    }

    @HussarTransactional
    private List<CodeRulesMigrationLoadVo> doLoad(List<CodeRulesMigrationLoadVo> codeRulesMigrationLoadVos) {
        ArrayList<SysCodeRule> sysCodeRulesList = new ArrayList<SysCodeRule>();
        ArrayList<SysCodeRuleInfo> sysCodeRuleInfoList = new ArrayList<SysCodeRuleInfo>();
        for (CodeRulesMigrationLoadVo codeRulesMigrationLoadVo : codeRulesMigrationLoadVos) {
            SysCodeRuleVo sysCodeRuleVo = codeRulesMigrationLoadVo.getSysCodeRuleVo();
            if (!HussarUtils.isNotEmpty((Object)sysCodeRuleVo)) continue;
            SysCodeRule sysCodeRule = new SysCodeRule();
            HussarUtils.copy((Object)sysCodeRuleVo, (Object)sysCodeRule);
            sysCodeRule.setId(sysCodeRuleVo.getCodeRuleId());
            sysCodeRule.setCodeRuleLevel(sysCodeRuleVo.getLevel());
            sysCodeRulesList.add(sysCodeRule);
            if (!HussarUtils.isNotEmpty((Object)sysCodeRuleVo.getSysCodeRuleInfoList())) continue;
            List<SysCodeRuleInfo> processedChildList = this.processChildData(sysCodeRuleVo);
            sysCodeRuleInfoList.addAll(processedChildList);
        }
        String connName = HussarContextHolder.getConnName();
        this.sysCodeRuleRefService.updateScheduled(connName);
        HashMap<Long, Long> serialNumberCodeMap = new HashMap<Long, Long>();
        if (HussarUtils.isNotEmpty(sysCodeRulesList)) {
            for (SysCodeRule codeRule : sysCodeRulesList) {
                String ruleCode = codeRule.getCodeRuleCode();
                ruleCode = ruleCode.replace("codePlusCacheName::", "").replace("ruleCodeSet", "");
                String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
                CodeRulesMigrationPlugin.getSerialNumberCodeMap(ruleCodeCacheKey, serialNumberCodeMap);
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
            }
        }
        if (HussarUtils.isNotEmpty(sysCodeRulesList)) {
            this.codeRuleService.saveOrUpdateBatch(sysCodeRulesList);
        }
        if (HussarUtils.isNotEmpty(sysCodeRuleInfoList)) {
            if (HussarUtils.isNotEmpty(serialNumberCodeMap)) {
                sysCodeRuleInfoList.forEach(info -> info.setSerialNumberCode((Long)serialNumberCodeMap.get(info.getId())));
            }
            this.codeRuleInfoService.saveOrUpdateBatch(sysCodeRuleInfoList);
        }
        return codeRulesMigrationLoadVos;
    }

    private static void getSerialNumberCodeMap(Object ruleCodeCacheKey, Map<Long, Long> serialNumberCodeMap) {
        SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        if (HussarUtils.isEmpty((Object)sysCodeRuleVo)) {
            return;
        }
        List ruleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        if (HussarUtils.isEmpty((Object)ruleInfoList)) {
            return;
        }
        for (SysCodeRuleInfo sysCodeRuleInfo : ruleInfoList) {
            String elementType = sysCodeRuleInfo.getElementType();
            if (!"serialNumber".equals(elementType)) continue;
            serialNumberCodeMap.put(sysCodeRuleInfo.getId(), sysCodeRuleInfo.getSerialNumberCode());
        }
    }

    private List<SysCodeRuleInfo> processChildData(SysCodeRuleVo importRuleVo) {
        ArrayList<SysCodeRuleInfo> resultList = new ArrayList<SysCodeRuleInfo>();
        List importChildList = importRuleVo.getSysCodeRuleInfoList();
        Long codeRuleId = importRuleVo.getCodeRuleId();
        if (codeRuleId == null || !this.isCodeRuleExists(codeRuleId)) {
            for (SysCodeRuleInfo importChild : importChildList) {
                SysCodeRuleInfo newChild = this.createNewChildInfo(importChild);
                resultList.add(newChild);
            }
            return resultList;
        }
        List existingChildList = ((LambdaQueryChainWrapper)this.codeRuleInfoService.lambdaQuery().eq(SysCodeRuleInfo::getCodeRuleId, (Object)codeRuleId)).list();
        boolean isChildDataIdentical = this.isChildDataIdentical(importChildList, existingChildList);
        if (isChildDataIdentical) {
            for (SysCodeRuleInfo importChild : importChildList) {
                SysCodeRuleInfo existingChild = this.findMatchingChild(importChild, existingChildList);
                if (existingChild == null) continue;
                SysCodeRuleInfo updatedChild = this.createUpdatedChildInfo(importChild, existingChild);
                resultList.add(updatedChild);
            }
        } else {
            ((LambdaUpdateChainWrapper)this.codeRuleInfoService.lambdaUpdate().eq(SysCodeRuleInfo::getCodeRuleId, (Object)codeRuleId)).remove();
            for (SysCodeRuleInfo importChild : importChildList) {
                SysCodeRuleInfo newChild = this.createNewChildInfo(importChild);
                resultList.add(newChild);
            }
        }
        return resultList;
    }

    private boolean isCodeRuleExists(Long codeRuleId) {
        return ((LambdaQueryChainWrapper)this.codeRuleService.lambdaQuery().eq(SysCodeRule::getId, (Object)codeRuleId)).exists();
    }

    private boolean isChildDataIdentical(List<SysCodeRuleInfo> importList, List<SysCodeRuleInfo> existingList) {
        if (importList.size() != existingList.size()) {
            return false;
        }
        for (SysCodeRuleInfo importChild : importList) {
            boolean foundMatch = existingList.stream().anyMatch(existing -> this.isChildMatch(importChild, (SysCodeRuleInfo)existing));
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    private boolean isChildMatch(SysCodeRuleInfo child1, SysCodeRuleInfo child2) {
        return HussarUtils.equals((Object)child1.getCodeRuleSort(), (Object)child2.getCodeRuleSort()) && HussarUtils.equals((Object)child1.getElementType(), (Object)child2.getElementType()) && HussarUtils.equals((Object)child1.getElementPattern(), (Object)child2.getElementPattern());
    }

    private SysCodeRuleInfo findMatchingChild(SysCodeRuleInfo importChild, List<SysCodeRuleInfo> existingList) {
        return existingList.stream().filter(existing -> this.isChildMatch(importChild, (SysCodeRuleInfo)existing)).findFirst().orElse(null);
    }

    private SysCodeRuleInfo createNewChildInfo(SysCodeRuleInfo importChild) {
        SysCodeRuleInfo newChild = new SysCodeRuleInfo();
        HussarUtils.copy((Object)importChild, (Object)newChild);
        if ("serialNumber".equals(importChild.getElementType())) {
            newChild.setSerialNumberCode(Long.valueOf(0L));
        }
        return newChild;
    }

    private SysCodeRuleInfo createUpdatedChildInfo(SysCodeRuleInfo importChild, SysCodeRuleInfo existingChild) {
        SysCodeRuleInfo updatedChild = new SysCodeRuleInfo();
        HussarUtils.copy((Object)importChild, (Object)updatedChild);
        updatedChild.setId(existingChild.getId());
        if ("serialNumber".equals(importChild.getElementType())) {
            updatedChild.setSerialNumberCode(existingChild.getSerialNumberCode());
        }
        return updatedChild;
    }

    private static final class Metadata
    implements MigrationPluginMetadata {
        public static final Metadata INSTANCE = new Metadata();

        private Metadata() {
        }

        public String getServiceType() {
            return CodeRulesMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return VERSION;
        }

        public int getDumpPrecedence() {
            return 0;
        }
    }
}

