/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.job;

import com.jxdinfo.hussar.code.plus.enums.TipConstantsEnum;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.code.plus.job.codeRuleUpdateScheduled")
public class CodeRuleUpdateScheduled
implements BasicProcessor {
    @Autowired
    private ISysCodeRuleRefService sysCodeRuleRefService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            if (TenantCacheUtil.openTenant()) {
                HashSet connNameList = new HashSet();
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                Map normalTenants = this.sysTenantService.getNormalTenants();
                for (String connName : connNameList) {
                    HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                    if (hussarTenantDefinition == null) {
                        throw new BaseException(String.format(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_TENANT_NOT_FOUND.getMessage()), connName));
                    }
                    HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                    this.sysCodeRuleRefService.updateScheduled(connName);
                    HussarContextHolder.remove();
                }
            } else {
                this.sysCodeRuleRefService.updateScheduled();
            }
        }
        return new ProcessResult(true, "success");
    }
}

