/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.enums.TipConstantsEnum;
import com.jxdinfo.hussar.code.plus.feign.RemoteCodeRuleService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.code.plus.controller.remoteHussarBaseCodeRuleController")
@Api(tags={"Feign\u7f16\u7801\u89c4\u5219\u7ba1\u7406"})
public class RemoteHussarBaseCodeRuleController
implements RemoteCodeRuleService {
    @Autowired
    private ISysCodeRuleService sysCodeRuleService;

    public ApiResponse<SysCodeRuleVo> getCodeRule(Long codeRuleId) {
        return this.sysCodeRuleService.getCodeRule(codeRuleId);
    }

    public ApiResponse<Page<SysCodeRuleVo>> listCodeRules(SysCodeRuleDto sysCodeRuleDto) {
        return this.sysCodeRuleService.listCodeRules(sysCodeRuleDto);
    }

    public Page<SysCodeRuleVo> getPageListCodeRules(SysCodeRuleDto sysCodeRuleDto) {
        return this.sysCodeRuleService.getPageListCodeRules(sysCodeRuleDto);
    }

    public ApiResponse<String> saveCodeRule(SysCodeSaveDto sysCodeDto) {
        return this.sysCodeRuleService.saveCodeRule(sysCodeDto);
    }

    public ApiResponse<String> updateCodeRule(SysCodeUpdateDto sysCodeUpdateDto) {
        return this.sysCodeRuleService.updateCodeRule(sysCodeUpdateDto);
    }

    public ApiResponse<String> getCurrentCode(CodePlusDto codePlusDto) {
        String result = this.sysCodeRuleService.getCurrentCode(codePlusDto);
        return ApiResponse.success((Object)result, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_CURRENT_SUCCESS.getMessage()));
    }

    public ApiResponse<List<String>> getBatchCurrentCodes(List<CodePlusDto> codePlusDtoList) {
        List result = this.sysCodeRuleService.getBatchCurrentCodes(codePlusDtoList);
        return ApiResponse.success((Object)result, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_BATCH_CURRENT_SUCCESS.getMessage()));
    }

    public ApiResponse<String> resetSerialNumber(String ruleCode, Long appId) {
        return this.sysCodeRuleService.resetSerialNumber(ruleCode, appId);
    }

    public ApiResponse<String> resetSerialNumber(String ruleCode) {
        return this.sysCodeRuleService.resetSerialNumber(ruleCode);
    }

    public ApiResponse<Long> getSerialNumberCode(String ruleCode) {
        return this.sysCodeRuleService.getSerialNumberCode(ruleCode);
    }

    public String getCurrentCodeByCache(CodePlusDto codePlusDto) {
        return this.sysCodeRuleService.getCurrentCodeByCache(codePlusDto);
    }

    public void updateCacheToDb(CodePlusDto codePlusDto) {
        this.sysCodeRuleService.updateCacheToDb(codePlusDto);
    }

    public ApiResponse<SysCodeRuleVo> getCodeRuleByCode(SysCodeRuleDto sysCodeRuleDto) {
        return this.sysCodeRuleService.getCodeRuleByCode(sysCodeRuleDto);
    }

    public Long getSerialNumberCodeValue(String ruleCode) {
        return (Long)this.sysCodeRuleService.getSerialNumberCode(ruleCode).getData();
    }

    public ApiResponse<SysCodeRuleVo> getCodeRuleByCode(String ruleCode) {
        return this.sysCodeRuleService.getCodeRuleByCode(ruleCode);
    }
}

