/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.runner;

import com.jxdinfo.hussar.code.plus.model.SysCodeRuleIsLevel;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.code.plus.runner.codeRuleRunner")
@Order(value=1000004)
public class CodeRuleRunner
implements ApplicationRunner {
    @Autowired
    private ISysCodeRuleRefService sysCodeRuleRefService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public void run(ApplicationArguments args) throws Exception {
        this.migrateCache();
        this.asyncCacheToDb();
    }

    private void migrateCache() {
        boolean migrate;
        String prefix = "tenant:0:";
        String newRuleCodeSetCacheName = prefix + "codePlusCacheName";
        List ruleCodeSetList = (List)HussarFixedCacheUtil.get((String)"codePlusCacheName", (Object)"ruleCodeSet");
        List ruleCodeSetListTenant = (List)HussarFixedCacheUtil.get((String)newRuleCodeSetCacheName, (Object)"ruleCodeSet");
        boolean bl = migrate = HussarUtils.isNotEmpty((Object)ruleCodeSetList) && HussarUtils.isEmpty((Object)ruleCodeSetListTenant);
        if (!migrate) {
            return;
        }
        HussarFixedCacheUtil.put((String)newRuleCodeSetCacheName, (Object)"ruleCodeSet", (Object)ruleCodeSetList);
        HussarFixedCacheUtil.evict((String)"codePlusCacheName", (Object)"ruleCodeSet");
        for (String ruleCode : ruleCodeSetList) {
            boolean levelFlag;
            String ruleCodeCacheKey = (ruleCode = ruleCode.replace("codePlusCacheName::", "").replace("ruleCodeSet", "")) + "ruleCodeSet";
            SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarFixedCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
            boolean sysCodeRuleVoFlag = HussarUtils.isNotEmpty((Object)sysCodeRuleVo);
            if (!sysCodeRuleVoFlag) continue;
            HussarFixedCacheUtil.put((String)newRuleCodeSetCacheName, (Object)ruleCodeCacheKey, (Object)sysCodeRuleVo);
            HussarFixedCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
            String isLevel = sysCodeRuleVo.getLevel();
            boolean bl2 = levelFlag = StringUtils.isNotBlank((CharSequence)isLevel) && "1".equals(isLevel);
            if (!levelFlag) {
                return;
            }
            String ruleCodeIsLevelCacheKey = ruleCode + "isLevelRuleCodeSet";
            ArrayList ruleCodeSetIsLevelList = (ArrayList)HussarFixedCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey);
            boolean ruleCodeSetIsLevelFlag = HussarUtils.isNotEmpty((Object)ruleCodeSetIsLevelList);
            if (!ruleCodeSetIsLevelFlag) continue;
            ruleCodeSetIsLevelList = new ArrayList(new HashSet(ruleCodeSetIsLevelList));
            for (String ruleCodeIsLevel : ruleCodeSetIsLevelList) {
                SysCodeRuleIsLevel sysCodeRuleIsLevel = (SysCodeRuleIsLevel)HussarFixedCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevel);
                if (!HussarUtils.isNotEmpty((Object)sysCodeRuleIsLevel)) continue;
                HussarFixedCacheUtil.put((String)newRuleCodeSetCacheName, (Object)ruleCodeIsLevel, (Object)sysCodeRuleIsLevel);
                HussarFixedCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeIsLevel);
            }
        }
    }

    private void asyncCacheToDb() {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseTenantExecutor.execute(() -> {
            if (TenantCacheUtil.openTenant()) {
                HashSet connNameList = new HashSet();
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                Map normalTenants = this.sysTenantService.getNormalTenants();
                for (String connName : connNameList) {
                    HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                    if (hussarTenantDefinition == null) {
                        throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                    }
                    HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                    this.sysCodeRuleRefService.updateScheduled(connName);
                    HussarContextHolder.remove();
                }
            } else {
                this.sysCodeRuleRefService.updateScheduled();
            }
        });
    }
}

