/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.choose.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.choose.dao.SysChooseGroupMapper;
import com.jxdinfo.hussar.choose.dao.SysChooseStaffStruMapper;
import com.jxdinfo.hussar.choose.model.ChooseGroup;
import com.jxdinfo.hussar.choose.model.ChooseStaffStru;
import com.jxdinfo.hussar.choose.service.ISysChooseGroupService;
import com.jxdinfo.hussar.choose.service.ISysChooseStaffStruService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysChooseGroupServiceImpl
extends HussarServiceImpl<SysChooseGroupMapper, ChooseGroup>
implements ISysChooseGroupService {
    @Resource
    private SysChooseStaffStruMapper sysChooseStaffStruMapper;
    @Resource
    private ISysChooseStaffStruService chooseRoleStruService;

    @HussarTransactional
    public ChooseGroup insertChooseGroup(String groupName, String type, List<Long> struIdsList, List<Long> staffIdsList, String dbName, String groupSeq) {
        if (ToolUtil.isEmpty((Object)groupName)) {
            throw new HussarException("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        ChooseGroup chooseGroup = new ChooseGroup();
        chooseGroup.setGroupName(groupName);
        chooseGroup.setCreateUserId(securityUser.getId());
        chooseGroup.setType(type);
        chooseGroup.setGroupSeq(groupSeq);
        boolean flag1 = this.save((BaseEntity)chooseGroup);
        if (!flag1) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty(struIdsList)) {
            List<ChooseStaffStru> chooseStaffStruList = this.sysChooseStaffStruMapper.selectStruList(chooseGroup.getGroupId(), struIdsList);
            boolean flag2 = true;
            if (ToolUtil.isNotEmpty(chooseStaffStruList)) {
                flag2 = this.chooseRoleStruService.saveBatch(chooseStaffStruList);
            }
            if (!flag2) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
            List<ChooseStaffStru> choosePostList = this.sysChooseStaffStruMapper.selectPostList(chooseGroup.getGroupId(), struIdsList);
            boolean flag3 = true;
            if (ToolUtil.isNotEmpty(choosePostList)) {
                flag3 = this.chooseRoleStruService.saveBatch(choosePostList);
            }
            if (!flag3) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if (HussarUtils.isNotEmpty(staffIdsList)) {
            List<ChooseStaffStru> chooseRoleList = this.sysChooseStaffStruMapper.selectRoleList(chooseGroup.getGroupId(), staffIdsList);
            boolean flag4 = true;
            if (ToolUtil.isNotEmpty(chooseRoleList)) {
                flag4 = this.chooseRoleStruService.saveBatch(chooseRoleList);
            }
            if (!flag4) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return chooseGroup;
    }

    @HussarTransactional
    public ChooseGroup updateChooseGroup(Long groupId, String groupName, String type, List<Long> struIdsList, List<Long> staffIdsList, String groupSeq) {
        this.chooseRoleStruService.remove((Wrapper)new QueryWrapper().lambda().eq(ChooseStaffStru::getGroupId, (Object)groupId));
        if (ToolUtil.isEmpty((Object)groupName)) {
            throw new HussarException("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ChooseGroup chooseGroup = new ChooseGroup();
        chooseGroup.setGroupId(groupId);
        chooseGroup.setGroupName(groupName);
        chooseGroup.setGroupSeq(groupSeq);
        boolean flag1 = this.updateById((BaseEntity)chooseGroup);
        if (!flag1) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty(struIdsList)) {
            List<ChooseStaffStru> chooseStruList = this.sysChooseStaffStruMapper.selectStruList(groupId, struIdsList);
            boolean flag2 = true;
            if (ToolUtil.isNotEmpty(chooseStruList)) {
                flag2 = this.chooseRoleStruService.saveBatch(chooseStruList);
            }
            if (!flag2) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
            List<ChooseStaffStru> choosePostList = this.sysChooseStaffStruMapper.selectPostList(groupId, struIdsList);
            boolean flag3 = true;
            if (ToolUtil.isNotEmpty(choosePostList)) {
                flag3 = this.chooseRoleStruService.saveBatch(choosePostList);
            }
            if (!flag3) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if (HussarUtils.isNotEmpty(staffIdsList)) {
            List<ChooseStaffStru> chooseStaffStruList = this.sysChooseStaffStruMapper.selectRoleList(chooseGroup.getGroupId(), staffIdsList);
            boolean flag4 = true;
            if (ToolUtil.isNotEmpty(chooseStaffStruList)) {
                flag4 = this.chooseRoleStruService.saveBatch(chooseStaffStruList);
            }
            if (!flag4) {
                throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return chooseGroup;
    }

    @HussarTransactional
    public ApiResponse<Tip> saveGroup(List<ChooseGroup> delList, List<ChooseGroup> updateList, String dbName) {
        List ids = delList.stream().map(ChooseGroup::getGroupId).distinct().collect(Collectors.toList());
        boolean delResult = true;
        if (ToolUtil.isNotEmpty(ids)) {
            delResult = this.removeByIds(ids);
            this.chooseRoleStruService.remove((Wrapper)new QueryWrapper().lambda().in(ChooseStaffStru::getGroupId, ids));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        for (ChooseGroup chooseGroup : updateList) {
            chooseGroup.setCreateUserId(user.getId());
        }
        boolean addResult = true;
        if (ToolUtil.isNotEmpty(updateList)) {
            addResult = this.saveOrUpdateBatch(updateList);
        }
        if (!delResult || !addResult) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

