/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageFailMapper;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationMapper;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.model.CasApplicationGroup;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationGroupService;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.system.vo.CasApplicationVo;
import com.jxdinfo.hussar.cas.util.SplitStrUtil;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.HussarHttpRequest;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.stereotype.Service;

@Service
public class CasApplicationServiceImpl
extends ServiceImpl<CasApplicationMapper, CasApplication>
implements ICasApplicationService {
    @Resource
    private CasApplicationMapper casApplicationMapper;
    @Resource
    private CasApplicationGroupMapper casApplicationGroupMapper;
    @Resource
    private ICasApplicationGroupService casApplicationGroupService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private RabbitAdmin rabbitAdmin;
    @Resource
    private CasSyncMessageMapper casSyncMessageMapper;
    @Resource
    private CasSyncMessageFailMapper casSyncMessageFailMapper;

    public List<JSTreeModel> getLazyCasTree(String nodeId) {
        List<JSTreeModel> jsTreeModels;
        if (ToolUtil.isEmpty((Object)nodeId)) {
            throw new HussarException("\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (nodeId.equals(String.valueOf(Constants.ROOT_NODE_PARENT))) {
            jsTreeModels = this.casApplicationGroupMapper.getFirstCasTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u4e1a\u52a1\u7cfb\u7edf");
            jsTreeModel.setId(Constants.RES_NODE_ID);
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.casApplicationGroupMapper.getLazyCasTree(nodeId);
        }
        return jsTreeModels;
    }

    public ApiResponse<CasApplication> saveCasApplication(CasApplication casApplication) {
        String applicationName = casApplication.getApplicationName();
        String applicationUrl = casApplication.getApplicationUrl();
        Long groupId = casApplication.getGroupId();
        String isHussar = casApplication.getIsHussar();
        List casList = this.list((Wrapper)new QueryWrapper().lambda().eq(CasApplication::getGroupId, (Object)groupId));
        int order = 1;
        if (casList.size() != 0) {
            order = this.casApplicationMapper.getMaxOrder(groupId);
        }
        casApplication.setId(null);
        String token = this.abstractOTPCredentialsMatcher.getRandomSecretBase32();
        casApplication.setApplicationToken(token);
        casApplication.setApplicationOrder(Integer.valueOf(order));
        casApplication.setApplicationStatus(null);
        if (this.casApplicationMapper.insert(casApplication) == 0) {
            throw new HussarException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        SplitStrUtil splitStrUtil = new SplitStrUtil();
        Object striArray = splitStrUtil.getStriArray(token);
        if (!ToolUtil.isEmpty((Object)striArray)) {
            Map strMap = (Map)striArray;
            String routingkey = "routingKey" + strMap.get("routingkey").toString();
            String exchange = "exchange" + strMap.get("exchange").toString();
            String queue = "queue" + strMap.get("queue").toString();
            DirectExchange exchange1 = this.createExchange(exchange);
            this.addExchange((AbstractExchange)exchange1);
            Queue delayQueue = this.createQueue(queue);
            this.addQueue(delayQueue);
            this.addBinding(delayQueue, exchange1, routingkey);
        }
        return ApiResponse.success((Object)casApplication);
    }

    public ApiResponse<CasApplication> updateCasApplication(CasApplication casApplication) {
        Long applicationId = casApplication.getId();
        String applicationName = casApplication.getApplicationName();
        String applicationUrl = casApplication.getApplicationUrl();
        if (ToolUtil.isEmpty((Object)applicationId)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.casApplicationMapper.updateById(casApplication) == 0) {
            throw new HussarException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)casApplication);
    }

    @DSTransactional
    public ApiResponse<Tip> deleteCasApplication(String applicationId) {
        if (this.casApplicationMapper.deleteById((Serializable)((Object)applicationId)) == 0) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.casSyncMessageFailMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casSyncMessageMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<JSTreeModel> getCasOrderTree(String parent) {
        List<JSTreeModel> result = this.casApplicationGroupMapper.getCasOrderTree(parent);
        JSTreeModel root = new JSTreeModel();
        CasApplicationGroup group = (CasApplicationGroup)this.casApplicationGroupMapper.selectById((Serializable)((Object)parent));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setCode("GROUP");
        root.setText(group.getGroupName());
        root.setId(group.getId());
        root.setType("GROUP");
        result.add(root);
        return result;
    }

    public ApiResponse<Tip> updateCasOrder(JSONArray treeArr) {
        ArrayList<CasApplication> list = new ArrayList<CasApplication>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasApplication casApplication = new CasApplication();
            casApplication.setId(Long.valueOf(id));
            if (ToolUtil.isNotEmpty((Object)order)) {
                casApplication.setApplicationOrder(Integer.valueOf(Integer.parseInt(order)));
            } else {
                casApplication.setApplicationOrder(Integer.valueOf(1));
            }
            list.add(casApplication);
        }
        if (ToolUtil.isEmpty(list) || !super.updateBatchById(list, list.size())) {
            throw new HussarException("\u6392\u5e8f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    public ApiResponse<CasApplicationGroup> saveGroup(String groupName) {
        CasApplicationGroup casApplicationGroup = new CasApplicationGroup();
        Long groupCount = this.casApplicationGroupService.count((Wrapper)new QueryWrapper());
        int order = 1;
        if (groupCount != 0L) {
            order = this.casApplicationGroupMapper.getMaxOrder();
        }
        casApplicationGroup.setId(null);
        casApplicationGroup.setGroupName(groupName);
        casApplicationGroup.setGroupOrder(Integer.valueOf(order));
        if (this.casApplicationGroupMapper.insert(casApplicationGroup) == 0) {
            throw new HussarException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)casApplicationGroup);
    }

    public ApiResponse<CasApplicationGroup> updateGroup(String groupName, Long groupId) {
        if (ToolUtil.isEmpty((Object)groupId)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CasApplicationGroup casApplicationGroup = new CasApplicationGroup();
        casApplicationGroup.setId(groupId);
        casApplicationGroup.setGroupName(groupName);
        if (this.casApplicationGroupMapper.updateById(casApplicationGroup) == 0) {
            throw new HussarException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public List<JSTreeModel> getGroupOrderTree() {
        List<JSTreeModel> result = this.casApplicationGroupMapper.getGroupOrderTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u4e1a\u52a1\u7cfb\u7edf");
        jsTreeModel.setId(Constants.RES_NODE_ID);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return result;
    }

    public ApiResponse<Tip> updateGroupOrder(JSONArray treeArr) {
        ArrayList<CasApplicationGroup> list = new ArrayList<CasApplicationGroup>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasApplicationGroup group = new CasApplicationGroup();
            group.setId(Long.valueOf(id));
            if (ToolUtil.isNotEmpty((Object)order)) {
                group.setGroupOrder(Integer.valueOf(Integer.parseInt(order)));
            } else {
                group.setGroupOrder(Integer.valueOf(1));
            }
            list.add(group);
        }
        if (ToolUtil.isEmpty(list) || !this.casApplicationGroupService.updateBatchById(list, list.size())) {
            throw new HussarException("\u6392\u5e8f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    public Page<CasApplicationVo> getCasList(Page<CasApplicationVo> page, String groupId) {
        page.setRecords(this.casApplicationMapper.getCasList(page, groupId));
        return page;
    }

    public IPage<CasApplicationVo> queryCasList(Page<CasApplicationVo> page, CasApplicationGroup casApplicationGroup) {
        Long groupId = casApplicationGroup.getId();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{page})) {
            throw new HussarException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CasApplicationVo> list = this.casApplicationMapper.getCasListVue(page, groupId);
        page.setRecords(list);
        return page;
    }

    public boolean testOnline(CasApplication casApplication) {
        boolean ifOnline = false;
        String token = casApplication.getApplicationToken();
        String url = casApplication.getApplicationUrl();
        JSONObject json = new JSONObject();
        long nonce = RandomUtils.nextLong();
        json.put("nonce", (Object)nonce);
        Long timestamp = System.currentTimeMillis();
        json.put("timestamp", (Object)timestamp);
        json.put("signature", (Object)SM3Util.digest((String)String.valueOf(timestamp)));
        try {
            JSONObject result = HussarHttpRequest.sendPost((String)(url + "/casonline/check"), (JSONObject)json, (String)token);
            String code = result.getString("code");
            String message = result.getString("message");
            if ("200".equals(code) && String.valueOf(nonce).equals(message)) {
                casApplication.setApplicationStatus("1");
                ifOnline = true;
            } else {
                casApplication.setApplicationStatus("0");
            }
            this.casApplicationMapper.updateById(casApplication);
        }
        catch (Exception e) {
            casApplication.setApplicationStatus("0");
            this.casApplicationMapper.updateById(casApplication);
            e.printStackTrace();
        }
        return ifOnline;
    }

    public ApiResponse<List<CasApplication>> queryCasGroup(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.list((Wrapper)new QueryWrapper().lambda().eq(CasApplication::getGroupId, (Object)id)));
    }

    public ApiResponse<Tip> deleteCasGroup(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.casApplicationGroupMapper.deleteById((Serializable)((Object)id)) == 0) {
            throw new HussarException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }

    private Queue createQueue(String queue) {
        return new Queue(queue, true);
    }

    private void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    private void addQueue(Queue queue) {
        this.rabbitAdmin.declareQueue(queue);
    }

    private void addBinding(Queue queue, DirectExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }
}

