/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authc.dto.AuthcDto;
import com.jxdinfo.hussar.authc.service.AuthcService;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authentication.vo.LoginUserInfoVo;
import com.jxdinfo.hussar.cas.dto.RedirectUtlDto;
import com.jxdinfo.hussar.cas.service.CasAuthcService;
import com.jxdinfo.hussar.cas.vo.RedirectUtlVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.config.ShiroCasConfiguration;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.enums.UserStatus;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.springframework.stereotype.Service;

@Service
public class CasAuthcServiceImpl
implements CasAuthcService {
    @Resource
    private ShiroCasConfiguration casConf;
    @Resource
    private AuthcService authcService;
    @Resource
    private HussarLoginService hussarLoginService;
    @Resource
    private ISysUsersService iSysUsersService;
    private static String REDIRECT = "redirect:";

    public ApiResponse<LoginUserInfoVo> queryLoginUser() {
        return this.authcService.queryLoginUserInfo(new AuthcDto());
    }

    public String loginCallback(HttpServletRequest request) {
        String frontUrl;
        AttributePrincipal principal = (AttributePrincipal)request.getUserPrincipal();
        if (principal != null) {
            SysUsers sysUsers;
            AuthcDto authcDto = new AuthcDto();
            Map casMap = principal.getAttributes();
            String userAccount = String.valueOf(casMap.get("userAccount"));
            if (ToolUtil.isNotEmpty((Object)userAccount) && ToolUtil.isNotEmpty((Object)(sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()), false)))) {
                authcDto.setUsername(sysUsers.getUserAccount());
                SecurityUser userInfo = (SecurityUser)this.hussarLoginService.queryLoginUser(authcDto);
                SecurityUtil.login((Object)sysUsers.getId());
                BaseSecurityUtil.setAttribute((String)"baseUserInfo", (Object)userInfo);
                BaseSecurityUtil.setAttribute((String)"baseConnName", (Object)userInfo.getConnName());
            }
        }
        if ((frontUrl = this.casConf.getFrontUrl(request.getSession().getId())).endsWith("console.html") || frontUrl.endsWith("/")) {
            return REDIRECT + this.casConf.getFrontUrl(request.getSession().getId()) + "#/casLogin";
        }
        return REDIRECT + this.casConf.getFrontUrl(request.getSession().getId()) + "/#/casLogin";
    }

    public String logOut(HttpServletRequest request) {
        SecurityUtil.logout();
        return REDIRECT + this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getFrontUrl(request.getSession().getId());
    }

    public String addShiroCookie(HttpServletRequest request) {
        String loginUrl = request.getParameter("loginUrl");
        loginUrl = loginUrl + "?service=" + this.casConf.getLocalUrl() + "/casFrontLogin/loginCallback";
        String frontUrl = this.casConf.getFrontUrl(request.getSession().getId());
        if (frontUrl.endsWith("console.html") || frontUrl.endsWith("/")) {
            return REDIRECT + frontUrl + "#/toLogin?loginUrl=" + loginUrl;
        }
        return REDIRECT + frontUrl + "/#/toLogin?loginUrl=" + loginUrl;
    }

    public RedirectUtlVo getRedirectUrl(RedirectUtlDto redirectUtlDto, HttpServletRequest request) {
        String redirectUrl = redirectUtlDto.getRedirectUrl();
        String shiroCookie = redirectUtlDto.getShiroCookie();
        RedirectUtlVo redirectUtlVo = new RedirectUtlVo();
        redirectUtlVo.setRedirectUrl(redirectUrl + "&shiroCookie=" + shiroCookie);
        this.casConf.addFrontUrlWithCookie(request, request.getSession().getId());
        return redirectUtlVo;
    }
}

