/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.config;

import com.jxdinfo.hussar.cas.condition.CasCondition;
import com.jxdinfo.hussar.cas.filter.LoginFilter;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.config.ShiroCasConfiguration;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={CasCondition.class})
public class CasConfig {
    @Autowired
    private ShiroCasConfiguration shiroCasConfiguration;
    @Resource
    private HussarBaseProperties hussarBaseProperties;

    @Bean
    public ServletListenerRegistrationBean<EventListener> singleSignOutListenerRegistration() {
        ServletListenerRegistrationBean registrationBean = new ServletListenerRegistrationBean();
        registrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<SingleSignOutFilter> filterSingleRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SingleSignOutFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", this.shiroCasConfiguration.getServerUrlPrefix());
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Cas30ProxyReceivingTicketValidationFilter> filterValidationRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new Cas30ProxyReceivingTicketValidationFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", this.shiroCasConfiguration.getServerUrlPrefix());
        initParameters.put("serverName", this.shiroCasConfiguration.getLocalUrl());
        initParameters.put("redirectAfterValidation", "true");
        initParameters.put("useSession", "true");
        initParameters.put("authn_method", "mfa-duo");
        registration.setInitParameters(initParameters);
        registration.setOrder(2);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<LoginFilter> filterAuthenticationRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new LoginFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerLoginUrl", this.shiroCasConfiguration.getServerUrlPrefix());
        initParameters.put("serverName", this.shiroCasConfiguration.getLocalUrl());
        initParameters.put("ignorePattern", this.getIgnorePattern());
        initParameters.put("ignoreUrlPatternType", "org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy");
        registration.setInitParameters(initParameters);
        registration.setOrder(2);
        return registration;
    }

    private String getIgnorePattern() {
        ArrayList whiteList = new ArrayList();
        whiteList.addAll(this.hussarBaseProperties.getCasSecurityWhitelist());
        whiteList.addAll(this.hussarBaseProperties.getSecurityWhitelist());
        String[] whiteListArr = new String[whiteList.size()];
        whiteList.toArray(whiteListArr);
        StringBuilder ignorePatternBuilder = new StringBuilder();
        String ignorePattern = "";
        if (ToolUtil.isNotEmpty(whiteList)) {
            for (String url : whiteList) {
                url = url.replace("/**", "/*");
                ignorePatternBuilder.append(url);
                ignorePatternBuilder.append("|");
            }
            ignorePattern = ignorePatternBuilder.substring(0, ignorePatternBuilder.length() - 1);
        }
        return ignorePattern;
    }

    @Bean
    public FilterRegistrationBean<HttpServletRequestWrapperFilter> filterWrapperRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HttpServletRequestWrapperFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(2);
        return registration;
    }
}

