/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.cassync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageFailMapper;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageMapper;
import com.jxdinfo.hussar.cas.cassync.dto.CasSyncDto;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.cassync.vo.PushCountVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CasSyncMessageServiceImpl
extends ServiceImpl<CasSyncMessageMapper, CasSyncMessage>
implements ICasSyncMessageService {
    @Resource
    private CasSyncMessageMapper casSyncMessageMapper;
    @Resource
    private CasSyncMessageFailMapper casSyncMessageFailMapper;
    @Autowired
    private DruidProperties druidProperties;

    public CasSyncMessage insertOperation(String type, String processingMode, Object object, Long applicationId) {
        CasSyncMessage casSyncMessage = new CasSyncMessage();
        casSyncMessage.setMessageStatus("0");
        JSONObject content = new JSONObject();
        content.put("type", (Object)type);
        content.put("ProcessingMode", (Object)processingMode);
        content.put("content", object);
        casSyncMessage.setMessageContent(content.toString().getBytes());
        int order = this.casSyncMessageMapper.getMaxOrder();
        casSyncMessage.setMessageOrder(order + 1);
        casSyncMessage.setApplicationId(applicationId);
        this.casSyncMessageMapper.insert(casSyncMessage);
        return casSyncMessage;
    }

    public void updatePushStatus(String messageId) {
        CasSyncMessage casSyncMessage = (CasSyncMessage)this.casSyncMessageMapper.selectById((Serializable)((Object)messageId));
        casSyncMessage.setMessageStatus("1");
        this.casSyncMessageMapper.updateById(casSyncMessage);
    }

    public List<PushCountVo> getPushCountGroupClient(String userId) {
        List<PushCountVo> list = this.casSyncMessageMapper.getPushCountClient(userId);
        List<PushCountVo> listAll = this.casSyncMessageMapper.getPushCountAll(userId);
        ArrayList<PushCountVo> resultList = new ArrayList<PushCountVo>();
        int all = Integer.parseInt(listAll.get(0).getNum());
        for (PushCountVo pushCountVo : list) {
            int clientNum = Integer.parseInt(pushCountVo.getNum());
            pushCountVo.setNum(clientNum + all + "");
            resultList.add(pushCountVo);
        }
        return resultList;
    }

    public List<Map<String, Object>> qeuryPushCount(Long userId) {
        int fail;
        List<Map<String, Object>> list;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            List<Map<String, Object>> newList = this.casSyncMessageMapper.getPushCount(userId);
            list = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> stringObjectMap : newList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Set<String> se = stringObjectMap.keySet();
                for (String string : se) {
                    map.put(string.toUpperCase(), stringObjectMap.get(string));
                }
                list.add(map);
            }
        } else {
            list = this.casSyncMessageMapper.getPushCount(userId);
        }
        if (ToolUtil.isNotEmpty(list)) {
            int organ = 0;
            int person = 0;
            int user = 0;
            int role = 0;
            int resource = 0;
            int menu = 0;
            for (Map<String, Object> map1 : list) {
                try {
                    JSONObject json;
                    String type;
                    Blob blob;
                    String blobString = "";
                    if (map1.containsKey("CONTENT") && map1.get("CONTENT") != null) {
                        if ("class [B".equals(map1.get("CONTENT").getClass().toString())) {
                            blobString = new String((byte[])map1.get("CONTENT"));
                        } else {
                            blob = (Blob)map1.get("CONTENT");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), StandardCharsets.UTF_8);
                        }
                    }
                    if (map1.containsKey("content") && map1.get("content") != null) {
                        if ("class [B".equals(map1.get("content").getClass().toString())) {
                            blobString = new String((byte[])map1.get("content"));
                        } else {
                            blob = (Blob)map1.get("content");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), StandardCharsets.UTF_8);
                        }
                    }
                    if ("organ".equals(type = (json = JSONObject.parseObject((String)blobString)).getString("type")) || "sysOrganType".equals(type) || "sysStruRule".equals(type)) {
                        ++organ;
                        continue;
                    }
                    if ("person".equals(type)) {
                        ++person;
                        continue;
                    }
                    if ("user".equals(type)) {
                        ++user;
                        continue;
                    }
                    if ("role".equals(type) || "roleGroup".equals(type) || "userRole".equals(type)) {
                        ++role;
                        continue;
                    }
                    if ("resource".equals(type) || "functions".equals(type) || "modules".equals(type) || "roleResource".equals(type)) {
                        ++resource;
                        continue;
                    }
                    if ("menu".equals(type)) {
                        ++menu;
                        continue;
                    }
                    type = null;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (organ != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "organ");
                hashMap.put("count", organ);
                result.add(hashMap);
            }
            if (person != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "person");
                hashMap.put("count", person);
                result.add(hashMap);
            }
            if (user != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "user");
                hashMap.put("count", user);
                result.add(hashMap);
            }
            if (resource != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "resource");
                hashMap.put("count", resource);
                result.add(hashMap);
            }
            if (role != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "role");
                hashMap.put("count", role);
                result.add(hashMap);
            }
            if (menu != 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", "menu");
                hashMap.put("count", menu);
                result.add(hashMap);
            }
        }
        if ((fail = this.casSyncMessageFailMapper.getPushCount(userId)) != 0) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("type", "fail");
            resultMap.put("count", fail);
            result.add(resultMap);
        }
        return result;
    }

    public Map<String, Object> queryCasSyncList(Page<CasSyncMessage> page, CasSyncDto casSyncDto) {
        Set<String> se;
        ArrayList list;
        String applicationName = casSyncDto.getApplicationName();
        if (ToolUtil.isEmpty(page)) {
            throw new HussarException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((CharSequence)applicationName)) {
            applicationName = applicationName.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Long creator = BaseSecurityUtil.getUser().getId();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        ArrayList<Map> resultlist = new ArrayList<Map>();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            List<Map<String, Object>> newList = this.casSyncMessageMapper.getCasSyncList(page, creator, applicationName);
            list = new ArrayList();
            for (Map<String, Object> stringObjectMap : newList) {
                HashMap<String, Object> ma = new HashMap<String, Object>();
                se = stringObjectMap.keySet();
                for (String set : se) {
                    ma.put(set.toLowerCase(), stringObjectMap.get(set));
                }
                list.add(ma);
            }
        } else if (dbUrl.startsWith("jdbc:oracle")) {
            List<Map<String, Object>> oracleList = this.casSyncMessageMapper.getCasSyncList(page, creator, applicationName);
            list = new ArrayList();
            for (Map<String, Object> stringObjectMap : oracleList) {
                HashMap<String, Object> oracleMap = new HashMap<String, Object>();
                se = stringObjectMap.keySet();
                for (String set : se) {
                    oracleMap.put(set.toLowerCase(), stringObjectMap.get(set));
                }
                list.add(oracleMap);
            }
        } else {
            list = new ArrayList();
            List<Map<String, Object>> mySqlList = this.casSyncMessageMapper.getCasSyncList(page, creator, applicationName);
            for (Map<String, Object> stringObjectMap : mySqlList) {
                HashMap<String, Object> mysqlMap = new HashMap<String, Object>();
                se = stringObjectMap.keySet();
                for (String set : se) {
                    mysqlMap.put(set.toLowerCase(), stringObjectMap.get(set));
                }
                list.add(mysqlMap);
            }
        }
        if (ToolUtil.isNotEmpty(list)) {
            for (Map map2 : list) {
                try {
                    String blobString = "";
                    if ("class [B".equals(map2.get("contents").getClass().toString())) {
                        blobString = new String((byte[])map2.get("contents"));
                    } else {
                        Blob blob = (Blob)map2.get("contents");
                        blobString = new String(blob.getBytes(1L, (int)blob.length()), StandardCharsets.UTF_8);
                    }
                    JSONObject json = JSONObject.parseObject((String)blobString);
                    String contents = "type:" + json.getString("type") + "@ProcessingMode:" + json.getString("ProcessingMode");
                    map2.put("contents", contents);
                    resultlist.add(map2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            list = resultlist;
        }
        map.put("count", page.getTotal());
        map.put("data", list);
        return map;
    }
}

