/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.cassync.frontcontroller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.cas.cassync.dto.CasSyncDto;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.cassync.vo.WebSocketDataVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.config.ShiroCasConfiguration;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.log.api.annotation.BussinessLog;
import com.jxdinfo.hussar.menu.model.MenuInfo;
import com.jxdinfo.hussar.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/casSyncMessageFront"})
@Api(tags={"cas\u6d88\u606f\u63a8\u9001\u7ba1\u7406"})
public class CasSyncMessageFrontController
extends BaseController {
    @Autowired
    private ICasSyncMessageService casSyncMessageService;
    @Autowired
    private ShiroCasConfiguration casConf;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    private static final String SYNC_PREFIX_PATH = "views/cassync/index";

    @GetMapping(value={"/list"})
    @ApiOperation(value="CAS\u4e1a\u52a1\u7cfb\u7edf\u6d88\u606f\u5217\u8868", notes="CAS\u4e1a\u52a1\u7cfb\u7edf\u6d88\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="casSyncDto", value="\u4e1a\u52a1\u7cfb\u7edf\u6d88\u606f\u63a8\u9001Dto", required=true, paramType="query")})
    @BussinessLog(key="/casSyncMessageFront/list", type="04", value="\u67e5\u8be2\u5217\u8868")
    public ApiResponse<Map<String, Object>> list(Page<CasSyncMessage> page, CasSyncDto casSyncDto) {
        return ApiResponse.success((Object)this.casSyncMessageService.queryCasSyncList(page, casSyncDto));
    }

    @GetMapping(value={"/getPushCount"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u63a8\u9001\u6761\u6570", notes="\u83b7\u53d6\u5f85\u63a8\u9001\u6761\u6570")
    @BussinessLog(key="/casSyncMessageFront/getPushCount", type="04", value="\u83b7\u53d6\u5f85\u63a8\u9001\u6761\u6570")
    public ApiResponse<List<Map<String, Object>>> getPushCount() {
        Long userId = BaseSecurityUtil.getUser().getId();
        List count = this.casSyncMessageService.qeuryPushCount(userId);
        return ApiResponse.success((Object)count);
    }

    @GetMapping(value={"/websocketData"})
    @ApiOperation(value="\u83b7\u53d6websocket\u8fde\u63a5\u6240\u9700\u4fe1\u606f", notes="\u83b7\u53d6websocket\u8fde\u63a5\u6240\u9700\u4fe1\u606f")
    @BussinessLog(key="/casSyncMessageFront/websocketData", type="04", value="\u83b7\u53d6websocket\u8fde\u63a5\u6240\u9700\u4fe1\u606f")
    public ApiResponse<WebSocketDataVo> websocketData() {
        Long userId = 0L;
        String syncRoute = "";
        String address = HttpKit.getLocalHost();
        String socketPort = address + ":" + this.port;
        String openType = this.casConf.getActiveType();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (securityUser != null) {
            userId = BaseSecurityUtil.getUser().getId();
            if ("CASServer".equals(openType) && securityUser.getRolesList() != null && securityUser.getRolesList().size() > 0) {
                List menus = this.iSysMenuManageService.getMenuByRoles(securityUser.getId(), securityUser.getRolesList(), this.profiles, null);
                syncRoute = this.getSyncRoute(menus);
            }
        }
        WebSocketDataVo webSocketDataVo = new WebSocketDataVo();
        webSocketDataVo.setUserId(String.valueOf(userId));
        webSocketDataVo.setOpenType(openType);
        webSocketDataVo.setPort(socketPort);
        webSocketDataVo.setSyncRoute(syncRoute);
        return ApiResponse.success((Object)webSocketDataVo);
    }

    private String getSyncRoute(List<MenuInfo> menus) {
        String syncRoute = "";
        for (MenuInfo menuInfo : menus) {
            String component = menuInfo.getComponent();
            if (ToolUtil.isNotEmpty((Object)component) && component.contains(SYNC_PREFIX_PATH)) {
                syncRoute = menuInfo.getPath();
                break;
            }
            List children = menuInfo.getChildMenus();
            if (!ToolUtil.isNotEmpty((Object)children) || !ToolUtil.isNotEmpty((Object)(syncRoute = this.getSyncRoute(children)))) continue;
            break;
        }
        return syncRoute;
    }
}

