/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.cloud.validate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.cloud.validate.service.ValidateUserService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class ValidateUserServiceImpl
implements ValidateUserService {
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @Override
    public Boolean validateUserPassword(String username, String password) {
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        SysUsers userInfo = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)username));
        if (Objects.isNull(userInfo)) {
            return false;
        }
        String encryptPwd = this.credentialsMatcher.passwordEncode(password.getBytes(StandardCharsets.UTF_8));
        return StringUtils.isNotBlank((CharSequence)encryptPwd) && StringUtils.equalsIgnoreCase((CharSequence)encryptPwd, (CharSequence)userInfo.getPassword());
    }
}

