/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.cloud.route.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.base.cloud.model.route.SysCloudRouteConf;
import com.jxdinfo.hussar.base.cloud.route.dao.SysCloudRouteConfMapper;
import com.jxdinfo.hussar.base.cloud.route.service.SysCloudRouteConfService;
import com.jxdinfo.hussar.platform.cloud.support.gateway.support.DynamicRouteInitEvent;
import com.jxdinfo.hussar.platform.cloud.support.gateway.vo.RouteDefinitionVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service(value="sysCloudRouteConfService")
public class SysCloudRouteConfServiceImpl
extends ServiceImpl<SysCloudRouteConfMapper, SysCloudRouteConf>
implements SysCloudRouteConfService {
    private Logger log = LoggerFactory.getLogger(SysCloudRouteConfServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    @HussarTransactional
    public Mono<Void> updateRoutes(JSONArray routes) {
        Boolean result = this.redisTemplate.delete((Object)"global:gateway_route_key");
        this.log.info("\u6e05\u7a7a\u7f51\u5173\u8def\u7531 {} ", (Object)result);
        ArrayList routeDefinitionVoList = new ArrayList();
        try {
            routes.forEach(value -> {
                Object order;
                Object uri;
                Object filters;
                Object predicates;
                Object routeName;
                this.log.info("\u66f4\u65b0\u8def\u7531 ->{}", value);
                RouteDefinitionVo vo = new RouteDefinitionVo();
                Map map = (Map)value;
                Object id = map.get("routeId");
                if (id != null) {
                    vo.setId(String.valueOf(id));
                }
                if ((routeName = map.get("routeName")) != null) {
                    vo.setRouteName(String.valueOf(routeName));
                }
                if ((predicates = map.get("predicates")) != null) {
                    JSONArray predicatesArray = JSONArray.parseArray((String)predicates.toString());
                    List predicateDefinitionList = predicatesArray.toJavaList(PredicateDefinition.class);
                    vo.setPredicates(predicateDefinitionList);
                }
                if ((filters = map.get("filters")) != null) {
                    JSONArray filtersArray = JSONArray.parseArray((String)filters.toString());
                    List filterDefinitionList = filtersArray.toJavaList(FilterDefinition.class);
                    vo.setFilters(filterDefinitionList);
                }
                if ((uri = map.get("uri")) != null) {
                    vo.setUri(URI.create(String.valueOf(uri)));
                }
                if ((order = map.get("order")) != null) {
                    vo.setOrder(Integer.parseInt(String.valueOf(order)));
                }
                this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)vo.getId(), (Object)vo);
                routeDefinitionVoList.add(vo);
            });
            SysCloudRouteConf condition = new SysCloudRouteConf();
            condition.setDelFlag("0");
            this.remove((Wrapper)new UpdateWrapper((Object)condition));
            List routeConfList = routeDefinitionVoList.stream().map(vo -> {
                SysCloudRouteConf routeConf = new SysCloudRouteConf();
                routeConf.setRouteId(vo.getId());
                routeConf.setRouteName(vo.getRouteName());
                routeConf.setFilters(JSONUtil.toJsonStr((Object)vo.getFilters()));
                routeConf.setPredicates(JSONUtil.toJsonStr((Object)vo.getPredicates()));
                routeConf.setRouteOrder(Integer.valueOf(vo.getOrder()));
                routeConf.setUri(vo.getUri().toString());
                return routeConf;
            }).collect(Collectors.toList());
            this.saveBatch(routeConfList);
            this.log.debug("\u66f4\u65b0\u7f51\u5173\u8def\u7531\u7ed3\u675f ");
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        }
        catch (Exception e) {
            this.log.error("\u8def\u7531\u914d\u7f6e\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DynamicRouteInitEvent((Object)this));
            throw new RuntimeException(e);
        }
        return Mono.empty();
    }

    @Override
    public List<SysCloudRouteConf> queryList() {
        return this.list();
    }

    @Override
    public SysCloudRouteConf getRouteDetail(String routeId) {
        return (SysCloudRouteConf)this.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysCloudRouteConf::getRouteId, (Object)routeId));
    }

    @Override
    public Boolean queryRouteIdIsExist(String routeId) {
        SysCloudRouteConf sysRouteConf = this.getRouteDetail(routeId);
        return sysRouteConf == null;
    }

    @Override
    @HussarTransactional
    public Boolean saveRoute(SysCloudRouteConf sysRouteConf) {
        try {
            RouteDefinitionVo routeDefinitionVo = this.getRouteDefinitionVo(sysRouteConf);
            this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)routeDefinitionVo.getId(), (Object)routeDefinitionVo);
            this.save(sysRouteConf);
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        }
        catch (Exception e) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DynamicRouteInitEvent((Object)this));
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    @Override
    @HussarTransactional
    public Boolean updateRoute(SysCloudRouteConf sysRouteConf) {
        try {
            RouteDefinitionVo routeDefinitionVo = this.getRouteDefinitionVo(sysRouteConf);
            this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)routeDefinitionVo.getId(), (Object)routeDefinitionVo);
            this.update(sysRouteConf, (Wrapper)new LambdaUpdateWrapper().eq(SysCloudRouteConf::getRouteId, (Object)sysRouteConf.getRouteId()));
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        }
        catch (Exception e) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DynamicRouteInitEvent((Object)this));
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteRoute(String routeId) {
        Boolean result = this.redisTemplate.delete((Object)"global:gateway_route_key");
        this.log.info("\u6e05\u7a7a\u7f51\u5173\u8def\u7531 {} ", (Object)result);
        try {
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCloudRouteConf::getRouteId, (Object)routeId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List sysRouteConfList = this.list();
            for (SysCloudRouteConf sysRouteConf : sysRouteConfList) {
                this.log.info("\u66f4\u65b0\u8def\u7531 ->{}", (Object)sysRouteConf.getRouteId());
                RouteDefinitionVo routeDefinitionVo = this.getRouteDefinitionVo(sysRouteConf);
                this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)routeDefinitionVo.getId(), (Object)routeDefinitionVo);
            }
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        }
        catch (Exception e) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DynamicRouteInitEvent((Object)this));
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    private RouteDefinitionVo getRouteDefinitionVo(SysCloudRouteConf sysRouteConf) throws Exception {
        RouteDefinitionVo routeDefinitionVo = new RouteDefinitionVo();
        if (sysRouteConf.getRouteId() != null) {
            routeDefinitionVo.setId(sysRouteConf.getRouteId());
        }
        if (sysRouteConf.getRouteName() != null) {
            routeDefinitionVo.setRouteName(sysRouteConf.getRouteName());
        }
        if (sysRouteConf.getFilters() != null) {
            JSONArray filtersArray = JSONArray.parseArray((String)sysRouteConf.getFilters());
            List filterDefinitionList = filtersArray.toJavaList(FilterDefinition.class);
            routeDefinitionVo.setFilters(filterDefinitionList);
        }
        if (sysRouteConf.getPredicates() != null) {
            JSONArray predicatesArray = JSONArray.parseArray((String)sysRouteConf.getPredicates());
            List predicateDefinitionList = predicatesArray.toJavaList(PredicateDefinition.class);
            routeDefinitionVo.setPredicates(predicateDefinitionList);
        }
        if (sysRouteConf.getUri() != null) {
            routeDefinitionVo.setUri(URI.create(sysRouteConf.getUri()));
        }
        if (sysRouteConf.getRouteOrder() != null) {
            routeDefinitionVo.setOrder(Integer.parseInt(String.valueOf(sysRouteConf.getRouteOrder())));
        }
        return routeDefinitionVo;
    }
}

