/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.cloud.server.route.config;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.jxdinfo.hussar.base.cloud.server.route.service.SysCloudRouteConfService;
import com.jxdinfo.hussar.platform.cloud.support.gateway.support.DynamicRouteInitEvent;
import com.jxdinfo.hussar.platform.cloud.support.gateway.vo.RouteDefinitionVo;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.annotation.Async;

@Configuration
public class CloudDynamicRouteInitRunner {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private SysCloudRouteConfService routeConfService;
    private Logger log = LoggerFactory.getLogger(CloudDynamicRouteInitRunner.class);

    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class, DynamicRouteInitEvent.class})
    public void initRoute() {
        this.redisTemplate.delete((Object)"global:gateway_route_key");
        this.log.info("base\u5f00\u59cb\u521d\u59cb\u5316\u7f51\u5173\u8def\u7531");
        this.routeConfService.list().forEach(route -> {
            RouteDefinitionVo vo = new RouteDefinitionVo();
            vo.setRouteName(route.getRouteName());
            vo.setId(route.getRouteId());
            vo.setUri(URI.create(route.getUri()));
            vo.setOrder(route.getOrder().intValue());
            JSONArray filterObj = JSONUtil.parseArray((String)route.getFilters());
            vo.setFilters(filterObj.toList(FilterDefinition.class));
            JSONArray predicateObj = JSONUtil.parseArray((String)route.getPredicates());
            vo.setPredicates(predicateObj.toList(PredicateDefinition.class));
            this.log.info("base\u52a0\u8f7d\u8def\u7531ID\uff1a{},{}", (Object)route.getRouteId(), (Object)vo);
            this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)route.getRouteId(), (Object)vo);
        });
        this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        this.log.debug("base\u521d\u59cb\u5316\u7f51\u5173\u8def\u7531\u7ed3\u675f ");
    }

    @Bean
    public RedisMessageListenerContainer redisContainer(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((message, bytes) -> {
            this.log.warn("\u63a5\u6536\u5230\u91cd\u65b0Redis \u91cd\u65b0\u52a0\u8f7d\u8def\u7531\u4e8b\u4ef6");
            this.initRoute();
        }, (Topic)new ChannelTopic("gateway_redis_route_reload_topic"));
        return container;
    }
}

