/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostAuditMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.manager.AuditStruPostManager;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.postmanager.PostChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.auditStruPostManagerImpl")
public class AuditStruPostManagerImpl
implements AuditStruPostManager {
    @Resource
    private SysStruPostAuditMapper sysStruPostAuditMapper;
    @Resource
    private SysStruPostMapper sysStruPostMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysPostMapper sysPostMapper;
    @Autowired
    private PostChangeNotify postChangeNotify;

    @Override
    @Transactional
    public Boolean pass(Long auditId) {
        boolean result;
        SysStruPostAudit struPostAudit = (SysStruPostAudit)this.sysStruPostAuditMapper.selectById(auditId);
        String operateType = struPostAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAdd(struPostAudit);
        } else if ("3".equals(operateType)) {
            result = this.doAuditDelete(struPostAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        return result;
    }

    private boolean doAuditDelete(SysStruPostAudit struPostAudit) {
        this.sysStruPostMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)struPostAudit.getPostId())).eq(SysStruPost::getStruId, (Object)struPostAudit.getStruId()));
        struPostAudit.setAuditStatus("1");
        boolean updateFlag = this.sysStruPostAuditMapper.updateById(struPostAudit) > 0;
        SysPost post = (SysPost)this.sysPostMapper.selectById(struPostAudit.getPostId());
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        return updateFlag;
    }

    private boolean doAuditAdd(SysStruPostAudit struPostAudit) {
        List struList = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)struPostAudit.getStruId())).ne(HussarDelflagEntity::getDelFlag, (Object)"1"));
        if (HussarUtils.isEmpty((Object)struList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_ORGAN_NOT_EXIST.getMessage()));
        }
        List postList = this.sysPostMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPost::getId, (Object)struPostAudit.getPostId())).ne(HussarDelflagEntity::getDelFlag, (Object)"1"));
        if (HussarUtils.isEmpty((Object)postList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_NO_EXIST_POST.getMessage()));
        }
        List struPosts = this.sysStruPostMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)struPostAudit.getPostId())).eq(SysStruPost::getStruId, (Object)struPostAudit.getStruId())).ne(HussarDelflagEntity::getDelFlag, (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)struPosts)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STRU_POST_RELATION.getMessage()));
        }
        SysStruPost struPost = new SysStruPost();
        struPost.setPostId(struPostAudit.getPostId());
        struPost.setStruId(struPostAudit.getStruId());
        boolean saveFlag = this.sysStruPostMapper.insert(struPost) > 0;
        struPostAudit.setAuditStatus("1");
        boolean updateFlag = this.sysStruPostAuditMapper.updateById(struPostAudit) > 0;
        SysPost post = (SysPost)this.sysPostMapper.selectById(struPostAudit.getPostId());
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        return saveFlag && updateFlag;
    }

    @Override
    @Transactional
    public Boolean reject(Long auditId) {
        SysStruPostAudit struPostAudit = (SysStruPostAudit)this.sysStruPostAuditMapper.selectById(auditId);
        struPostAudit.setAuditStatus("2");
        return this.sysStruPostAuditMapper.updateById(struPostAudit) > 0;
    }
}

