/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.dto.PostDto;
import com.jxdinfo.hussar.authorization.post.dto.QueryPostDto;
import com.jxdinfo.hussar.authorization.post.dto.SearchPostDto;
import com.jxdinfo.hussar.authorization.post.manager.QueryPostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.authorization.post.vo.PostDetailVo;
import com.jxdinfo.hussar.authorization.post.vo.PostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.queryPostManagerImpl")
public class QueryPostManagerImpl
implements QueryPostManager {
    private static final String STRU_ID = "struId";
    private static final String POST_NAME = "postName";
    private static final String ORGAN_TYPE_CODES = "organTypeCodes";
    private static final String POST_ID = "postId";
    @Resource
    private SysPostMapper sysPostMapper;
    @Resource
    private SysStruPostMapper sysStruPostMapper;
    @Resource
    private SysPostRoleMapper sysPostRoleMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysUserPostMapper sysUserPostMapper;

    @Override
    public Page<PostVo> pageList(PageInfo pageInfo, QueryPostDto queryPostDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Long struId = queryPostDto.getOrganId();
        Long postId = queryPostDto.getPostId();
        String postName = queryPostDto.getPostName();
        String organTypeCode = queryPostDto.getOrganTypeCode();
        queryParams.put(STRU_ID, struId);
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        List<Object> organTypeCodes = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organTypeCode)) {
            organTypeCodes = Arrays.asList(organTypeCode.split(","));
        }
        queryParams.put(ORGAN_TYPE_CODES, organTypeCodes);
        queryParams.put(POST_ID, postId);
        List<PostVo> postInfoList = this.sysPostMapper.pageList((Page<PostVo>)page, queryParams);
        page.setRecords(postInfoList);
        return page;
    }

    @Override
    public Page<PostVo> unRelateOrganPost(PageInfo pageInfo, QueryPostDto queryPostDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Long postId = queryPostDto.getPostId();
        String postName = queryPostDto.getPostName();
        String organTypeCode = queryPostDto.getOrganTypeCode();
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        List<Object> organTypeCodes = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organTypeCode)) {
            organTypeCodes = Arrays.asList(organTypeCode.split(","));
        }
        queryParams.put(ORGAN_TYPE_CODES, organTypeCodes);
        queryParams.put(POST_ID, postId);
        List<PostVo> postInfoList = this.sysPostMapper.unRelateOrganPost((Page<PostVo>)page, queryParams);
        page.setRecords(postInfoList);
        return page;
    }

    @Override
    public List<PostVo> commonPostList(String postName) {
        return this.sysPostMapper.commonPostList(postName);
    }

    @Override
    public Page<PostVo> commonPostPageList(PageInfo pageInfo, String postName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<PostVo> list = this.sysPostMapper.commonPostPageList((Page<PostVo>)page, postName);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<PostVo> unRelateOrganPostNoPage(QueryPostDto queryPostDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Long struId = queryPostDto.getOrganId();
        Long postId = queryPostDto.getPostId();
        String postName = queryPostDto.getPostName();
        String organTypeCode = queryPostDto.getOrganTypeCode();
        queryParams.put(STRU_ID, struId);
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        List<Object> organTypeCodes = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organTypeCode)) {
            organTypeCodes = Arrays.asList(organTypeCode.split(","));
        }
        queryParams.put(ORGAN_TYPE_CODES, organTypeCodes);
        queryParams.put(POST_ID, postId);
        return this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
    }

    @Override
    public Page<PostVo> unRelateOrganPostPage(PageInfo pageInfo, QueryPostDto queryPostDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Long struId = queryPostDto.getOrganId();
        Long postId = queryPostDto.getPostId();
        String postName = queryPostDto.getPostName();
        String organTypeCode = queryPostDto.getOrganTypeCode();
        queryParams.put(STRU_ID, struId);
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        List<Object> organTypeCodes = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organTypeCode)) {
            organTypeCodes = Arrays.asList(organTypeCode.split(","));
        }
        queryParams.put(ORGAN_TYPE_CODES, organTypeCodes);
        queryParams.put(POST_ID, postId);
        List<PostVo> list = this.sysPostMapper.unRelateOrganPostPage((Page<PostVo>)page, queryParams);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<PostVo> getCommonAndSameTypePostList(PageInfo pageInfo, QueryPostDto queryPostDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        String postName = queryPostDto.getPostName();
        String organTypeCode = queryPostDto.getOrganTypeCode();
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        queryParams.put("organTypeCode", organTypeCode);
        List<PostVo> postInfoList = this.sysPostMapper.getCommonAndSameTypePostList((Page<PostVo>)page, queryParams);
        page.setRecords(postInfoList);
        return page;
    }

    @Override
    public Page<PostVo> listPost(PageInfo pageInfo, SearchPostDto searchPostDto) {
        List organPostList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<Object> postInfoList = new ArrayList();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        String postName = searchPostDto.getPostName();
        Long organId = searchPostDto.getOrganId();
        String organTypeCode = searchPostDto.getOrganTypeCode();
        List organIds = searchPostDto.getOrganIds();
        Set<Object> postIds = new HashSet();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            organPostList = this.sysStruPostMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, (Collection)organIds));
            postIds = organPostList.stream().map(SysStruPost::getPostId).collect(Collectors.toSet());
        }
        if (HussarUtils.isNotEmpty((Object)organId)) {
            organPostList = this.sysStruPostMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)organId));
            Set searchPostIds = organPostList.stream().map(SysStruPost::getPostId).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty(searchPostIds)) {
                queryParams.put("searchPostIds", searchPostIds);
            } else {
                return page.setRecords(postInfoList);
            }
        }
        queryParams.put("postIds", postIds);
        queryParams.put(POST_NAME, SqlQueryUtil.transferSpecialChar((String)postName));
        if ("common".equals(organTypeCode)) {
            queryParams.put("commonPost", "common");
            queryParams.put("organTypeCode", null);
        } else {
            queryParams.put("commonPost", null);
            queryParams.put("organTypeCode", organTypeCode);
        }
        postInfoList = this.sysPostMapper.listPost((Page<PostVo>)page, queryParams);
        page.setRecords(postInfoList);
        return page;
    }

    @Override
    public List<PostVo> postSelect(Long typeCode, Long organId, String postName) {
        String postTypeCode = null;
        if (HussarUtils.isNotEmpty((Object)typeCode)) {
            postTypeCode = String.valueOf(typeCode);
        }
        List<PostVo> postVoList = HussarUtils.isNull((Object)organId) || organId == 0L ? this.sysPostMapper.listPostNoOrganId(postTypeCode, postName) : this.sysPostMapper.postSelect(postTypeCode, organId, postName);
        return postVoList;
    }

    @Override
    public Page<PostVo> postPageSelect(PageInfo pageInfo, Long typeCode, Long organId, String postName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        String postTypeCode = null;
        if (HussarUtils.isNotEmpty((Object)typeCode)) {
            postTypeCode = String.valueOf(typeCode);
        }
        List<PostVo> postVoList = HussarUtils.isNull((Object)organId) || organId == 0L ? this.sysPostMapper.listPostPageNoOrganId((Page<PostVo>)page, postTypeCode, postName) : this.sysPostMapper.postPageSelect((Page<PostVo>)page, postTypeCode, organId, postName);
        page.setRecords(postVoList);
        return page;
    }

    @Override
    public PostDetailVo detailPost(Long postId) {
        List postRoles;
        List roleIds;
        PostDetailVo infoVo = new PostDetailVo();
        SysPost post = (SysPost)this.sysPostMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getId, (Object)postId));
        if (HussarUtils.isNull((Object)post)) {
            return infoVo;
        }
        BeanUtils.copyProperties((Object)post, (Object)infoVo);
        infoVo.setPostId(postId);
        List organPosts = this.sysStruPostMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List<Long> struIds = organPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(struIds)) {
            List<OrganVo> organs = this.sysStruMapper.getOrganNameAndId(struIds);
            infoVo.setOrgans(organs);
        }
        if (HussarUtils.isNotEmpty(roleIds = (postRoles = this.sysPostRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')))).stream().map(SysPostRole::getRoleId).collect(Collectors.toList()))) {
            List sysRoles = this.sysRolesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
            ArrayList<RoleVo> roles = new ArrayList<RoleVo>();
            for (SysRoles role : sysRoles) {
                RoleVo roleVo = new RoleVo();
                roleVo.setId(role.getId());
                roleVo.setRoleName(role.getRoleName());
                roles.add(roleVo);
            }
            infoVo.setRoles(roles);
        }
        return infoVo;
    }

    @Override
    public List<PostBasicVo> getRolePost(String roleId) {
        ArrayList<PostBasicVo> result = new ArrayList<PostBasicVo>();
        String[] idStr = roleId == null ? "".split(",") : roleId.split(",");
        Long[] idStrl = new Long[idStr.length];
        for (int i = 0; i < idStr.length; ++i) {
            idStrl[i] = Long.parseLong(idStr[i]);
        }
        List postRoles = this.sysPostRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPostRole::getRoleId, Arrays.asList(idStrl))).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List postIds = postRoles.stream().map(SysPostRole::getPostId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(postIds)) {
            List sysPosts = this.sysPostMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysPost::getId, postIds));
            for (SysPost post : sysPosts) {
                PostBasicVo basicVo = new PostBasicVo();
                basicVo.setPostId(post.getId());
                basicVo.setPostName(post.getPostName());
                result.add(basicVo);
            }
        }
        return result;
    }

    @Override
    public PostDto findPostById(Long postId) {
        PostDto postDto = new PostDto();
        SysPost post = (SysPost)this.sysPostMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getId, (Object)postId));
        if (HussarUtils.isNull((Object)post)) {
            return postDto;
        }
        BeanUtils.copyProperties((Object)post, (Object)postDto);
        postDto.setPostId(postId);
        List organPosts = this.sysStruPostMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List struIds = organPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
        postDto.setOrganIds(struIds);
        List postRoles = this.sysPostRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List roleIds = postRoles.stream().map(SysPostRole::getRoleId).collect(Collectors.toList());
        postDto.setRoleIds(roleIds);
        List userPosts = this.sysUserPostMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)post)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List userIds = userPosts.stream().map(SysUserPost::getUserId).collect(Collectors.toList());
        postDto.setUserIds(userIds);
        return postDto;
    }
}

