/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideStruPostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideUserPostDto;
import com.jxdinfo.hussar.authorization.post.manager.AddOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.addOutsidePostManagerImpl")
public class AddOutsidePostManagerImpl
implements AddOutsidePostManager {
    @Autowired
    private SysPostMapper sysPostMapper;
    @Autowired
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysUserPostService sysUserPostService;

    @Override
    public R<AddOutsidePostDto> addPost(AddOutsidePostDto addOutsidePostDto) {
        boolean existCode;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)addOutsidePostDto);
        String postCode = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostCode());
        String organType = StringUtils.trimToEmpty((String)addOutsidePostDto.getOrganType());
        Long postId = addOutsidePostDto.getPostId();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysPost::getPostCode, (Object)postCode);
        boolean bl = existCode = this.sysPostMapper.selectCount((Wrapper)lambdaQueryWrapper) > 0L;
        if (existCode) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOutsidePostDto, (String)"postCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_CODE_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)organType)) {
            boolean existType;
            LambdaQueryWrapper typeLambdaQueryWrapper = new LambdaQueryWrapper();
            typeLambdaQueryWrapper.eq(SysOrganType::getOrganType, (Object)organType);
            boolean bl2 = existType = this.sysOrganTypeMapper.selectCount((Wrapper)typeLambdaQueryWrapper) > 0L;
            if (!existType) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOutsidePostDto, (String)"organType", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NON_EXIST_ORG_TYPE.getMessage())});
            }
        }
        if (HussarUtils.isNotEmpty((Object)postId)) {
            boolean existId;
            LambdaQueryWrapper postIdQueryWrapper = new LambdaQueryWrapper();
            postIdQueryWrapper.eq(SysPost::getId, (Object)postId);
            boolean bl3 = existId = this.sysPostMapper.selectCount((Wrapper)postIdQueryWrapper) > 0L;
            if (existId) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOutsidePostDto, (String)"postId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_ID_EXIST.getMessage())});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysPost sysPost = new SysPost();
            this.initializationAdd(addOutsidePostDto, sysPost);
            this.sysPostMapper.insert(sysPost);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysPost.getId(), sysPost.getPostCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(AddOutsidePostDto addOutsidePostDto, SysPost sysPost) {
        Long postId = addOutsidePostDto.getPostId();
        String postName = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostName());
        String postDesc = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostDesc());
        String postCode = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostCode());
        String organType = StringUtils.trimToEmpty((String)addOutsidePostDto.getOrganType());
        Integer postOrder = addOutsidePostDto.getPostOrder();
        if (HussarUtils.isEmpty((Object)postId)) {
            postId = IdWorker.getId((Object)sysPost);
        }
        if (HussarUtils.isEmpty((Object)postOrder)) {
            postOrder = 1;
            Integer maxOrder = this.sysPostMapper.getMaxOrder();
            postOrder = HussarUtils.isEmpty((Object)maxOrder) ? postOrder : maxOrder + 1;
        }
        sysPost.setId(postId);
        sysPost.setPostCode(postCode);
        sysPost.setPostName(postName);
        sysPost.setPostDesc(postDesc);
        sysPost.setOrganTypeCode(organType);
        sysPost.setPostOrder(postOrder);
    }

    @Override
    public Boolean saveStruPost(AddOutsideStruPostDto struPostDto) {
        List ids = struPostDto.getIds();
        String type = struPostDto.getType();
        List struPostList = struPostDto.getStruPostList();
        if ("organ".equals(type)) {
            this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, (Collection)ids));
        } else if ("post".equals(type)) {
            this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getPostId, (Collection)ids));
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_NOT_SUPPORTED.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)struPostList)) {
            this.sysStruPostService.saveBatch((Collection)struPostList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveUserPost(AddOutsideUserPostDto userPostDto) {
        List ids = userPostDto.getIds();
        String type = userPostDto.getType();
        List userPostList = userPostDto.getUserPostList();
        if ("post".equals(type)) {
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getPostId, (Collection)ids));
        } else if ("user".equals(type)) {
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, (Collection)ids));
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_NOT_SUPPORTED.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)userPostList)) {
            this.sysUserPostService.saveBatch((Collection)userPostList);
        }
        return Boolean.TRUE;
    }
}

