/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryStruRightFeignDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleStruRightBoServiceImpl
implements ISysRoleStruRightBoService {
    @Resource
    private ISysRoleStruRightService sysRoleStruRightService;
    @Resource
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;

    public boolean remove(List<Long> roleRightIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(roleRightIds), SysRoleStruRights::getRoleDataRightsId, roleRightIds);
        return this.sysRoleStruRightService.remove((Wrapper)wrapper);
    }

    public boolean saveBatch(List<SysRoleStruRights> roleStruRightsList) {
        return this.sysRoleStruRightService.saveBatch(roleStruRightsList);
    }

    public List<SysRoleStruRights> listByRoleRightId(Long roleRightId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleStruRights::getRoleDataRightsId, (Object)roleRightId);
        return this.sysRoleStruRightService.list((Wrapper)queryWrapper);
    }

    public Boolean deleteRoleStruRightByRoleIds(List<Long> roleIds) {
        return this.sysRoleStruRightService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleId, roleIds));
    }

    public List<SysRoleStruRights> listByRoleId(List<Long> roleIds) {
        return this.sysRoleStruRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleId, roleIds));
    }

    public List<SysRoleStruRights> listStruRights(QueryStruRightFeignDto struRightFeignDto) {
        List roleRightIds = struRightFeignDto.getRoleRightIds();
        List roleIds = struRightFeignDto.getRoleIds();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(HussarUtils.isNotEmpty((Object)roleRightIds), SysRoleStruRights::getRoleDataRightsId, (Collection)roleRightIds)).in(HussarUtils.isNotEmpty((Object)roleIds), SysRoleStruRights::getRoleId, (Collection)roleIds);
        return this.sysRoleStruRightsMapper.selectList((Wrapper)queryWrapper);
    }
}

