/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleStruRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleFunctionChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleFunctionsServiceImpl
extends HussarBaseServiceImpl<SysRoleFunctionsMapper, SysRoleFunctions>
implements ISysRoleFunctionsService {
    private static Logger logger = LoggerFactory.getLogger(SysRoleFunctionsServiceImpl.class);
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Lazy
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Lazy
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private IHussarBaseFunctionAdapter hussarBaseFunctionAdapter;
    @Resource
    private RoleFunctionChangeNotify roleFunctionChangeNotify;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private DeleteRoleStruRightManager deleteRoleStruRightManager;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysFunctionsService functionsService;
    @Resource
    private ISysResourcesService resourcesService;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfigService;
    @Resource
    private ISysRoleFunctionsAuditService sysRoleFunctionsAuditService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public void saveFunctions(String functionsIds, Long roleId) {
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isFunctionAudit()) {
            SysRoleFunctionsAudit sysRoleFunctionsAudit;
            Object functionIds;
            List list;
            List sysRoleFunctionsAudits = this.sysRoleFunctionsAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleFunctionsAudit::getRoleId, (Object)roleId)).eq(SysRoleFunctionsAudit::getAuditStatus, (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)sysRoleFunctionsAudits)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_AUDIT_SAVE_FAIL.getMessage()));
            }
            List<Object> newFunctionIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)functionsIds)) {
                String[] ids = functionsIds.split(",");
                Long[] idl = (Long[])ConvertUtils.convert((String[])ids, Long.class);
                newFunctionIds = Arrays.asList(idl);
            }
            List<Object> oldFunctionIds = new ArrayList();
            ArrayList<Long> addRoleFunctionIds = new ArrayList<Long>();
            ArrayList<Long> deleteRoleFunctionIds = new ArrayList<Long>();
            ArrayList<Object> allFunctionIds = new ArrayList<Object>();
            List oldRoleFunctions = this.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)oldRoleFunctions) && HussarUtils.isNotEmpty((Object)(list = this.functionsService.listByIds(functionIds = oldRoleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList()))))) {
                SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
                oldFunctionIds = null != protectStatus && "3".equals(protectStatus.getConfigValue()) ? list.stream().filter(s -> !"1".equals(s.getIsSys())).map(SysFunctions::getId).collect(Collectors.toList()) : list.stream().map(SysFunctions::getId).collect(Collectors.toList());
            }
            allFunctionIds.addAll(newFunctionIds);
            allFunctionIds.addAll(oldFunctionIds);
            for (Long l : allFunctionIds) {
                if (!newFunctionIds.contains(l)) {
                    deleteRoleFunctionIds.add(l);
                }
                if (oldFunctionIds.contains(l)) continue;
                addRoleFunctionIds.add(l);
            }
            ArrayList<SysRoleFunctionsAudit> addRoleFunctionsAudits = new ArrayList<SysRoleFunctionsAudit>();
            ArrayList<SysRoleFunctionsAudit> arrayList = new ArrayList<SysRoleFunctionsAudit>();
            for (Long functionId : addRoleFunctionIds) {
                sysRoleFunctionsAudit = new SysRoleFunctionsAudit();
                sysRoleFunctionsAudit.setRoleId(roleId);
                sysRoleFunctionsAudit.setFunctionId(functionId);
                sysRoleFunctionsAudit.setAuditStatus("0");
                sysRoleFunctionsAudit.setOperateType("1");
                addRoleFunctionsAudits.add(sysRoleFunctionsAudit);
            }
            for (Long functionId : deleteRoleFunctionIds) {
                sysRoleFunctionsAudit = new SysRoleFunctionsAudit();
                sysRoleFunctionsAudit.setRoleId(roleId);
                sysRoleFunctionsAudit.setFunctionId(functionId);
                sysRoleFunctionsAudit.setAuditStatus("0");
                sysRoleFunctionsAudit.setOperateType("3");
                arrayList.add(sysRoleFunctionsAudit);
            }
            if (HussarUtils.isNotEmpty(addRoleFunctionsAudits)) {
                this.sysRoleFunctionsAuditService.saveBatch(addRoleFunctionsAudits);
            }
            if (HussarUtils.isNotEmpty(arrayList)) {
                this.sysRoleFunctionsAuditService.saveBatch(arrayList);
            }
        } else {
            SysRoles role;
            Object[] ids = functionsIds.split(",");
            logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5f53\u524d\u89d2\u8272ID: {}", (Object)roleId);
            logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u524d\u53f0\u4f20\u5165\u529f\u80fdID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)ids.length, (Object)Arrays.toString(ids));
            Long[] idl = (Long[])ConvertUtils.convert((String[])ids, Long.class);
            List roleFunctions = this.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)roleFunctions)) {
                List roleDataRights;
                List dataList = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
                List<Long> idList = Arrays.asList(idl);
                if (HussarUtils.isNotEmpty(dataList = dataList.stream().filter(id -> !idList.contains(id)).collect(Collectors.toList())) && HussarUtils.isNotEmpty((Object)(roleDataRights = this.sysRoleDataRightService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleDataRight::getRoleId, (Object)roleId)).in(SysRoleDataRight::getFunctionId, dataList))))) {
                    List<Long> rightIds = roleDataRights.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
                    logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5220\u9664\u6570\u636e\u6743\u9650ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)rightIds.size(), rightIds);
                    this.sysRoleDataRightService.removeByIds(rightIds);
                    this.deleteRoleStruRightManager.deleteCustomStruBatch(rightIds);
                }
            }
            LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId);
            LambdaQueryWrapper resDeleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId)).eq(SysRoleResource::getRelationSource, (Object)"1");
            SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
            logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5f53\u524d\u72b6\u6001\uff08configValue=3\u4e3a\u5206\u4fdd\uff09: {}", (Object)protectStatus);
            if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
                List list;
                List sysRoleResourceList;
                List sysFunctions;
                List funIds = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(funIds) && HussarUtils.isNotEmpty((Object)(sysFunctions = this.functionsService.listByIds(funIds)))) {
                    List list2 = sysFunctions.stream().filter(f -> "1".equals(f.getIsSys())).map(SysFunctions::getId).collect(Collectors.toList());
                    logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5206\u4fdd\u72b6\u6001\u4e0b\uff0c\u4fdd\u7559\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u7cfb\u7edf\u529f\u80fdID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)list2.size(), list2);
                    deleteWrapper.notIn(CollectionUtils.isNotEmpty(list2), SysRoleFunctions::getFunctionId, list2);
                }
                if (CollectionUtils.isNotEmpty((Collection)(sysRoleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysRoleResource::getRoleId, (Object)roleId)))) && CollectionUtils.isNotEmpty((Collection)(list = this.resourcesService.listByIds((Collection)sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList()))))) {
                    List sysResIds = list.stream().filter(s -> "1".equals(s.getIsSys())).map(SysResources::getId).collect(Collectors.toList());
                    logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5206\u4fdd\u72b6\u6001\u4e0b\uff0c\u4fdd\u7559\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u7cfb\u7edf\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)sysResIds.size(), (Object)sysResIds);
                    resDeleteWrapper.notIn(CollectionUtils.isNotEmpty((Collection)sysResIds), SysRoleResource::getResourceId, (Collection)sysResIds);
                }
            }
            this.sysRoleFunctionsMapper.delete((Wrapper)deleteWrapper);
            this.sysRoleResourceMapper.delete((Wrapper)resDeleteWrapper);
            ArrayList<SysRoleFunctions> sysRoleFunctionsList = new ArrayList<SysRoleFunctions>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime localDateTime = LocalDateTime.now();
            for (Object object : ids) {
                if (ToolUtil.isEmpty((Object)object)) continue;
                SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
                sysRoleFunctions.setRoleId(roleId);
                sysRoleFunctions.setFunctionId(Long.valueOf((String)object));
                sysRoleFunctions.setCreator(securityUser.getId());
                sysRoleFunctions.setLastEditor(securityUser.getId());
                sysRoleFunctions.setLastTime(localDateTime);
                sysRoleFunctions.setCreateTime(localDateTime);
                sysRoleFunctionsList.add(sysRoleFunctions);
            }
            if (ToolUtil.isNotEmpty(sysRoleFunctionsList)) {
                List funIds = sysRoleFunctionsList.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
                logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u65b0\u589e\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u529f\u80fdID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)funIds.size(), funIds);
                super.saveBatch(sysRoleFunctionsList, sysRoleFunctionsList.size());
                List sysFunctionResources = this.iSysFunctionResourcesService.selectFunctionResByFuncIds(Arrays.asList(idl));
                ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
                for (SysFunctionResources functionResources : sysFunctionResources) {
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setRoleId(roleId);
                    sysRoleResource.setResourceId(functionResources.getResourceId());
                    sysRoleResource.setRelationSource("1");
                    sysRoleResource.setCreator(securityUser.getId());
                    sysRoleResource.setLastEditor(securityUser.getId());
                    sysRoleResource.setLastTime(localDateTime);
                    sysRoleResource.setCreateTime(localDateTime);
                    sysRoleResourceList.add(sysRoleResource);
                }
                if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
                    List list = sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList());
                    logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u65b0\u589e\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)list.size(), list);
                    this.iSysRoleResourceService.saveBatch(sysRoleResourceList);
                }
            }
            if (HussarUtils.isNotEmpty((Object)(role = (SysRoles)this.sysRolesService.getById((Serializable)roleId)).getAppId()) && role.getAppId() != 1L) {
                this.roleFunctionChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
                this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            }
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                this.userAuthorizationChangeReporter.report(new Object[]{"function", roleId});
            }
        }
    }

    public List<SysRoleFunctions> getRoleFunctions(Long roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROLE_ID", (Object)roleId);
        List roleFunctions = super.list((Wrapper)queryWrapper);
        List funIds = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
        logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--/getRoleFunctions\u63a5\u53e3\uff0c\u83b7\u53d6\u5f53\u524d\u6240\u6709\u5173\u8054\u7684\u529f\u80fdID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a\uff1a{}", (Object)funIds.size(), funIds);
        return roleFunctions;
    }

    public List<SysRoleFunctions> getRoleFunctions(String roleId) {
        return this.getRoleFunctions(Long.parseLong(roleId));
    }

    public List<JSTreeModel> selfFunctionTree(String functionIds) {
        String[] functionIdArr = ToolUtil.isEmpty((Object)functionIds) ? new String[]{} : functionIds.trim().split(",");
        Long[] functionIdLarr = (Long[])ConvertUtils.convert((String[])functionIdArr, Long.class);
        List splitIdList = LambdaQueryUtil.getSplitList(Arrays.asList(functionIdLarr));
        List<JSTreeModel> functionTreeData = new ArrayList<JSTreeModel>();
        if (ToolUtil.isNotEmpty((Object)functionIdLarr)) {
            functionTreeData = this.protectionStatusConfigBoService.isFenBaoEnable() != false ? this.sysRoleFunctionsMapper.selfFunctionTreeFb(splitIdList) : this.sysRoleFunctionsMapper.selfFunctionTree(splitIdList);
            TranslateUtil.translate(functionTreeData, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        }
        return TreeModelUtils.merge(this.doRecursive(functionTreeData));
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList childList = new ArrayList();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        list.forEach(m -> {
            if ("1".equals(m.getIsRes())) {
                childList.add(m);
                parentIdList.add(m.getParent());
            } else {
                otherList.add((JSTreeModel)m);
            }
        });
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>(childList);
        if (ToolUtil.isNotEmpty(otherList)) {
            this.recursive(otherList, result, parentIdList);
        }
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> idList) {
        ArrayList currentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        list.forEach(model -> {
            if (idList.contains(model.getId())) {
                currentList.add(model);
                parentIdList.add(model.getParent());
            } else {
                otherList.add((JSTreeModel)model);
            }
        });
        if (ToolUtil.isNotEmpty(currentList)) {
            result.addAll(currentList);
            this.recursive(otherList, result, parentIdList);
        }
    }

    public void insertOrUpdateRoleFunction(List<SysRoleFunctions> roleFunctionsList) {
        if (ToolUtil.isEmpty(roleFunctionsList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_ADD_DATA.getMessage()), (Object)roleFunctionsList.size());
            return;
        }
        List<SysRoleFunctions> excistData = this.selectExistList(roleFunctionsList);
        List<SysRoleFunctions> addList = roleFunctionsList;
        if (ToolUtil.isNotEmpty(excistData)) {
            addList = this.getAddList(roleFunctionsList, excistData);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_ADD_DATA.getMessage()), (Object)addList.size());
    }

    public void dataSyncByRoleFunc(List<SysRoleFunctions> roleFunctionsList) {
        List functionIdList = roleFunctionsList.stream().map(SysRoleFunctions::getFunctionId).distinct().collect(Collectors.toList());
        List functionResourcesList = this.iSysFunctionResourcesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, functionIdList));
        List syncRoleFunc = this.sysRoleFunctionsMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, functionIdList));
        List roleIdList = syncRoleFunc.stream().map(SysRoleFunctions::getRoleId).distinct().collect(Collectors.toList());
        if (ToolUtil.isNotEmpty((Object)functionResourcesList)) {
            List roleResourceExistList = new ArrayList();
            List resourceIds = functionResourcesList.stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(roleIdList)) {
                LambdaQueryWrapper roleResWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, roleIdList);
                LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)roleResWrapper, SysRoleResource::getResourceId, resourceIds);
                roleResWrapper.eq(SysRoleResource::getRelationSource, (Object)"1");
                roleResourceExistList = this.iSysRoleResourceService.list((Wrapper)roleResWrapper);
            }
            HashMap existMap = new HashMap();
            roleResourceExistList.forEach(rr -> existMap.put(rr.getRoleId() + "-" + rr.getResourceId(), "1"));
            ArrayList<SysRoleResource> addList = new ArrayList<SysRoleResource>();
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long resId : resourceIds) {
                for (Long roleId : roleIdList) {
                    if (!ToolUtil.isEmpty(existMap.get(roleId + "-" + resId))) continue;
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setRoleId(roleId);
                    sysRoleResource.setResourceId(resId);
                    sysRoleResource.setRelationSource("1");
                    sysRoleResource.setCreator(user.getId());
                    sysRoleResource.setLastEditor(user.getId());
                    sysRoleResource.setCreateTime(now);
                    sysRoleResource.setLastTime(now);
                    addList.add(sysRoleResource);
                }
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.iSysRoleResourceService.saveBatch(addList);
            }
            logger.info("\u4ece\u529f\u80fd\u5173\u8054\u89d2\u8272\u8d44\u6e90\u65b0\u589e{}\u6761", (Object)addList.size());
        }
    }

    public List<SysRoleFunctions> selectRoleFuncByDoubleId(List<SysRoleFunctions> sysRoleFunctions) {
        ArrayList<SysRoleFunctions> retunList = new ArrayList<SysRoleFunctions>();
        LambdaQueryWrapper roleFunctionsLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysRoleFunctions.size(); i += 999) {
            List<SysRoleFunctions> temp;
            if (i + 999 >= sysRoleFunctions.size()) {
                temp = sysRoleFunctions.subList(i, sysRoleFunctions.size());
                roleFunctionsLambdaQueryWrapper.clear();
                for (SysRoleFunctions roleFunc : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
                }
                retunList.addAll(this.sysRoleFunctionsMapper.selectList((Wrapper)roleFunctionsLambdaQueryWrapper));
                continue;
            }
            temp = sysRoleFunctions.subList(i, i + 999);
            roleFunctionsLambdaQueryWrapper.clear();
            for (SysRoleFunctions roleFunc : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
            }
            retunList.addAll(this.sysRoleFunctionsMapper.selectList((Wrapper)roleFunctionsLambdaQueryWrapper));
        }
        return retunList;
    }

    public void delRoleFuncByDoubleId(List<SysRoleFunctions> sysRoleFunctionsList) {
        LambdaQueryWrapper roleFunctionsLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysRoleFunctionsList.size(); i += 999) {
            List<SysRoleFunctions> temp;
            if (i + 999 >= sysRoleFunctionsList.size()) {
                temp = sysRoleFunctionsList.subList(i, sysRoleFunctionsList.size());
                roleFunctionsLambdaQueryWrapper.clear();
                for (SysRoleFunctions roleFunc : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
                }
                this.sysRoleFunctionsMapper.delete((Wrapper)roleFunctionsLambdaQueryWrapper);
                continue;
            }
            temp = sysRoleFunctionsList.subList(i, i + 999);
            roleFunctionsLambdaQueryWrapper.clear();
            for (SysRoleFunctions roleFunc : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
            }
            this.sysRoleFunctionsMapper.delete((Wrapper)roleFunctionsLambdaQueryWrapper);
        }
    }

    public List<SysRoleFunctions> selectRoleFunsByFunctionIds(List<Long> functionIds) {
        if (HussarUtils.isEmpty(functionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long funcId : functionIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoleFunctions::getFunctionId, (Object)funcId);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    private List<SysRoleFunctions> selectExistList(List<SysRoleFunctions> sysRoleFunctions) {
        List<Object> returnList = new ArrayList<SysRoleFunctions>();
        ArrayList roleIds = new ArrayList();
        ArrayList functionIds = new ArrayList();
        sysRoleFunctions.forEach(fr -> {
            roleIds.add(fr.getRoleId());
            functionIds.add(fr.getFunctionId());
        });
        if (ToolUtil.isNotEmpty(functionIds) && ToolUtil.isNotEmpty(roleIds)) {
            List distRoleIds = roleIds.stream().distinct().collect(Collectors.toList());
            List distFuncIds = functionIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper roleFuncQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getRoleId, distRoleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)roleFuncQueryWrapper, SysRoleFunctions::getFunctionId, distFuncIds);
            returnList = this.sysRoleFunctionsMapper.selectList((Wrapper)roleFuncQueryWrapper);
        }
        return returnList;
    }

    private List<SysRoleFunctions> getAddList(List<SysRoleFunctions> roleFunctionsList, List<SysRoleFunctions> existList) {
        ArrayList<SysRoleFunctions> addList = new ArrayList<SysRoleFunctions>();
        HashMap existMap = new HashMap();
        existList.forEach(fr -> existMap.put(fr.getRoleId() + "-" + fr.getFunctionId(), "1"));
        for (SysRoleFunctions roleFunctions : roleFunctionsList) {
            String idStr = roleFunctions.getRoleId() + "-" + roleFunctions.getFunctionId();
            if (!ToolUtil.isEmpty(existMap.get(idStr))) continue;
            addList.add(roleFunctions);
        }
        return addList;
    }

    public boolean saveBatch(Collection<SysRoleFunctions> entityList) {
        return this.hussarBaseFunctionAdapter.saveBatchRoleFunc((List)entityList);
    }

    public List<SysRoleFunctions> listByRoleIds(List<Long> roleIds) {
        return this.hussarBaseFunctionAdapter.listByRoleIds(roleIds);
    }

    public List<SysRoleFunctions> listByFunctionId(Long functionId) {
        return this.hussarBaseFunctionAdapter.listByFuncId(functionId);
    }
}

