/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResTypeExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResTypeExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandViewVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourceViewVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourcesPartVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourcesVo;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysResourcesServiceImpl
extends HussarBaseServiceImpl<SysResourcesMapper, SysResources>
implements ISysResourcesService {
    private static final String UPDATE = "update";
    private static final String INSERT = "insert";
    @Resource
    SysResourcesMapper resourceMapper;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private IHussarBaseResourceTypeService hussarBaseResourceTypeService;
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Resource
    private IHussarBaseResTypeExpandService hussarBaseResTypeExpandService;

    public Map<String, Integer> insertOrUpdateList(List<SysResources> resourcesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(resourcesList)) {
            result.put(UPDATE, 0);
            result.put(INSERT, 0);
            return result;
        }
        for (SysResources sysResources : resourcesList) {
            if (sysResources.getPermissions() != null) continue;
            sysResources.setPermissions("");
        }
        List<Long> resIds = resourcesList.stream().map(SysResources::getId).collect(Collectors.toList());
        List<SysResources> existedResources = this.selectResourcesByResIds(resIds);
        if (HussarUtils.isEmpty(existedResources)) {
            this.saveBatch(resourcesList);
            result.put(UPDATE, 0);
            result.put(INSERT, resourcesList.size());
            return result;
        }
        ArrayList<SysResources> updateData = new ArrayList<SysResources>();
        ArrayList<SysResources> insertData = new ArrayList<SysResources>();
        List existedIds = existedResources.stream().map(SysResources::getId).collect(Collectors.toList());
        for (SysResources sysResources : resourcesList) {
            if (existedIds.contains(sysResources.getId())) {
                updateData.add(sysResources);
                continue;
            }
            insertData.add(sysResources);
        }
        if (HussarUtils.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        this.updateBatchById(updateData);
        result.put(UPDATE, updateData.size());
        result.put(INSERT, insertData.size());
        return result;
    }

    public boolean checkResource(String resourceUrl) {
        boolean flag = false;
        List resources = this.resourceMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resourceUrl)).eq(SysResources::getIsRepeatAuthenticate, (Object)"1")).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (resources != null && resources.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public SysResourcesVo getResourceInfoByUrl(String key) {
        return new SysResourcesVo();
    }

    public SysResources getResourceInfoBySourceId(String sourceId) {
        return this.resourceMapper.getResourceInfoBySourceId(sourceId);
    }

    public List<String> queryResUrlsByRoleId(String roleId) {
        return this.resourceMapper.getResUrlsByRoleId(roleId);
    }

    public List<String> queryPermissionsByRoleIds(List<Long> roleIds) {
        return this.hussarBaseResourceAdapter.queryPermissionsByRoleIds(roleIds);
    }

    public List<SysResources> selectResourcesByResIds(List<Long> resourceIds) {
        if (HussarUtils.isEmpty(resourceIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)lambdaQueryWrapper, SysResources::getId, resourceIds);
        lambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.resourceMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList) {
        List<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(SysResources::getPermissions)).ne(SysResources::getPermissions, (Object)Character.valueOf(' '))).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty(resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    public List<ResourceTreeVo> openResTree(Long appId, String resType) {
        List<ResourceTreeVo> resourceTreeVos = this.resourceMapper.openResTree(appId, resType);
        TranslateUtil.translate(resourceTreeVos, AbstractNoIconHussarLazyTreeDefinition::getLabelLangKey, AbstractNoIconHussarLazyTreeDefinition::setLabel);
        return resourceTreeVos;
    }

    public List<SysResources> getPageAndElementResources(Long moduleId) {
        return this.hussarBaseResourceAdapter.getPageAndElementResources(moduleId);
    }

    public List<ElementResourceVo> elementResources(String pagePath, List<Long> roleIds) {
        return this.hussarBaseResourceAdapter.elementResources(pagePath, roleIds);
    }

    public List<Long> getElementResIds(String pagePath) {
        if (HussarUtils.isBlank((CharSequence)pagePath)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGE_ROUTE_NO_PASSED.getMessage()));
        }
        SysResources resource = (SysResources)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getPath, (Object)pagePath)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (HussarUtils.isEmpty((Object)resource)) {
            return Collections.emptyList();
        }
        Long moduleId = resource.getModuleId();
        List<SysResources> resourcesList = this.getPageAndElementResources(moduleId);
        ArrayList<Long> elementIds = new ArrayList<Long>();
        this.handleChild(resource.getId(), resourcesList, elementIds);
        return elementIds;
    }

    private void handleChild(Long id, List<SysResources> sysResources, List<Long> elementIds) {
        for (SysResources resource : sysResources) {
            if (!HussarUtils.equals((Object)id, (Object)resource.getParentResourceId())) continue;
            Long childId = resource.getId();
            elementIds.add(childId);
            this.handleChild(childId, sysResources, elementIds);
        }
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.hussarBaseResourceAdapter.getMaxOrderByParentId(moduleId);
    }

    public boolean updateBatchById(Collection<SysResources> entityList) {
        return this.hussarBaseResourceAdapter.updateBatchById((List)entityList);
    }

    public boolean save(SysResources entity) {
        return this.hussarBaseResourceAdapter.save(entity);
    }

    public List<SysResources> list() {
        return this.hussarBaseResourceAdapter.list();
    }

    public List<SysResources> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseResourceAdapter.listByIds(idList);
    }

    public List<SysResources> getResourcesByIds(List<Long> roleIdList, String type) {
        return this.hussarBaseResourceAdapter.getResourcesByIds(roleIdList, type);
    }

    public List<SysResources> getResourcesByIdsAndTypeCode(List<Long> roleIdList, String type, String typeCode) {
        return this.hussarBaseResourceAdapter.getResourcesByIdsAndTypeCode(roleIdList, type, typeCode);
    }

    public boolean updateById(SysResources entity) {
        return this.hussarBaseResourceAdapter.updateById(entity);
    }

    public SysResources getById(Serializable id) {
        return this.hussarBaseResourceAdapter.getById(id);
    }

    public List<ResourceDetailVo> selectResourcesByResIdsAddDtl(List<Long> resourceIds) {
        if (HussarUtils.isEmpty(resourceIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysResources::getId, resourceIds);
        lambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        List sysResources = this.resourceMapper.selectList((Wrapper)lambdaQueryWrapper);
        ArrayList<ResourceDetailVo> resourceDetailVos = new ArrayList<ResourceDetailVo>();
        for (SysResources sysResource : sysResources) {
            String resTypeCode;
            boolean flag;
            SysResources resources;
            ResourceDetailVo resourceDetailVo = new ResourceDetailVo();
            BeanUtils.copyProperties((Object)sysResource, (Object)resourceDetailVo);
            SysResourceViewVo sysResourceVo = new SysResourceViewVo();
            BeanUtils.copyProperties((Object)sysResource, (Object)sysResourceVo);
            sysResourceVo.setResourceTypeName(((SysResourceType)this.hussarBaseResourceTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)sysResource.getResTypeId()))).getResourceTypeName());
            sysResourceVo.setModuleName(this.sysResourcesService.getModuleName(sysResource.getModuleId()));
            if (HussarUtils.isNotEmpty((Object)sysResource.getParentResourceId()) && HussarUtils.isNotEmpty((Object)(resources = (SysResources)this.sysResourcesService.getById((Serializable)sysResource.getParentResourceId())))) {
                resourceDetailVo.setParentResourceName(resources.getResourceName());
                sysResourceVo.setParentResourceName(resources.getResourceName());
            }
            if (!(flag = this.hussarBaseResourceTypeService.getIsSysResType(resTypeCode = sysResource.getResTypeId()))) {
                List resTypeExpandVos = this.hussarBaseResTypeExpandService.getResTypeExpandListByCode(resTypeCode);
                ArrayList<ResourceExpandVo> resourceExpandVos = this.hussarBaseResourceExpandService.getResourceExpandListByResId(sysResource.getId());
                List<Object> expandIds = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)resourceExpandVos)) {
                    expandIds = resourceExpandVos.stream().map(ResourceExpandVo::getResourceTypeExpandId).collect(Collectors.toList());
                }
                ArrayList finalExpandIds = expandIds;
                List notRelateExpands = resTypeExpandVos.stream().filter(r -> !finalExpandIds.contains(Long.parseLong(r.getId()))).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(notRelateExpands)) {
                    if (HussarUtils.isEmpty((Object)resourceExpandVos)) {
                        resourceExpandVos = new ArrayList<ResourceExpandVo>();
                    }
                    for (ResTypeExpandVo vo : notRelateExpands) {
                        ResourceExpandVo expandVo = new ResourceExpandVo();
                        expandVo.setResourceId(sysResource.getId());
                        expandVo.setResourceTypeExpandCode(vo.getExpandCode());
                        expandVo.setResourceTypeExpandName(vo.getExpandName());
                        expandVo.setResourceTypeExpandId(Long.valueOf(Long.parseLong(vo.getId())));
                        resourceExpandVos.add(expandVo);
                    }
                }
                ArrayList<ResourceExpandViewVo> resourceExpandViewVos = new ArrayList<ResourceExpandViewVo>();
                for (ResourceExpandVo resExps : resourceExpandVos) {
                    ResourceExpandViewVo resExpViewVo = new ResourceExpandViewVo();
                    resExpViewVo.setResourceTypeExpandName(resExps.getResourceTypeExpandName());
                    resExpViewVo.setResourceTypeExpandValue(resExps.getResourceTypeExpandValue());
                    resourceExpandViewVos.add(resExpViewVo);
                }
                sysResourceVo.setResourceExpands(resourceExpandViewVos);
                resourceDetailVo.setResourceTypeExpands(resTypeExpandVos);
                resourceDetailVo.setResourceExpands(resourceExpandVos);
            }
            resourceDetailVo.setSysResource(sysResourceVo);
            resourceDetailVos.add(resourceDetailVo);
        }
        return resourceDetailVos;
    }

    public String getModuleName(Long moduleId) {
        return this.resourceMapper.getModuleName(moduleId);
    }

    public List<SysResources> getResourcesByType(String resTypeId, Long appId) {
        return this.hussarBaseResourceAdapter.getResourcesByType(resTypeId, appId);
    }

    public void updateResourceStatusByAppId(Long appId, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(HussarDelflagEntity::getDelFlag, (Object)status)).eq(SysResources::getAppId, (Object)appId);
        this.update((Wrapper)wrapper);
    }

    public void deleteResourceByAppId(Long appId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysResources::getAppId, (Object)appId);
        this.remove((Wrapper)wrapper);
    }

    public List<SysResourcesPartVo> getPartResourcesByType(String type) {
        if (HussarUtils.equals((Object)type, (Object)"3")) {
            Integer platformFlag = 1 << Integer.parseInt(type);
            return this.resourceMapper.getPartResourcesByTypeForPlatform(platformFlag);
        }
        return this.resourceMapper.getPartResourcesByType(type);
    }

    public List<SysResourcesPartVo> getPartResourcesByIds(List<Long> roleIdList, String type) {
        return this.hussarBaseResourceAdapter.getPartResourcesByIds(roleIdList, type);
    }
}

