/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleBackDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.vo.ModuleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResCountVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchModuleVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysResourceMosulesServiceImpl
extends HussarBaseServiceImpl<SysResourceModulesMapper, SysResourceModules>
implements ISysResourceMosulesService {
    private static Logger logger = LoggerFactory.getLogger(SysResourceMosulesServiceImpl.class);
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public List<SysResourceModules> getGradeAdminResModuleId(List<Long> resourceIdList) {
        if (ToolUtil.isEmpty(resourceIdList)) {
            return new ArrayList<SysResourceModules>();
        }
        List resourceModulesList = this.sysResourceModulesMapper.selectList((Wrapper)new QueryWrapper());
        List resourcesList = this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResources::getId, resourceIdList)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        ArrayList<Long> parentModuleIds = new ArrayList<Long>();
        resourcesList.forEach(resource -> parentModuleIds.add(resource.getModuleId()));
        ArrayList<SysResourceModules> parentModuleList = new ArrayList<SysResourceModules>();
        this.getParentModuleList(parentModuleList, parentModuleIds, resourceModulesList);
        TranslateUtil.translate(parentModuleList, SysResourceModules::getNameLangKey, SysResourceModules::setModuleName);
        return parentModuleList;
    }

    private void getParentModuleList(List<SysResourceModules> parentModuleList, List<Long> parentModuleIds, List<SysResourceModules> resourceModulesList) {
        ArrayList parentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        for (int i = 0; i < resourceModulesList.size(); ++i) {
            SysResourceModules resourceModules = resourceModulesList.get(i);
            if (!parentModuleIds.contains(Long.parseLong(String.valueOf(resourceModules.getId())))) continue;
            parentModuleList.add(resourceModules);
            parentIdList.add(resourceModules.getParentModuleId());
            resourceModulesList.remove(i);
            --i;
        }
        if (parentIdList.size() > 0) {
            this.getParentModuleList(parentModuleList, parentIdList, resourceModulesList);
        }
    }

    public Map<String, Integer> insertOrUpdateList(List<SysResourceModules> modulesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(modulesList)) {
            result.put("update", modulesList.size());
            result.put("insert", modulesList.size());
            return result;
        }
        List<Long> moduleIds = modulesList.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        List<SysResourceModules> existedResourceModules = this.getResModulesByModuleIds(moduleIds);
        List existedIds = existedResourceModules.stream().map(SysResourceModules::getId).distinct().collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules sysResourceModules : modulesList) {
            if (existedIds.contains(sysResourceModules.getId())) {
                updateData.add(sysResourceModules);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            sysResourceModules.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zerolength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zerolength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENCODING_EXCEEDS_LENGTH.getMessage()));
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zerolength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            sysResourceModules.setModuleCode(currentCode.toString());
            insertData.add(sysResourceModules);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        result.put("update", updateData.size());
        result.put("insert", insertData.size());
        return result;
    }

    public void insertOrUpdateResourcesModuleList(List<SysResourceModules> resourceModulesList) {
        if (CollectionUtils.isEmpty(resourceModulesList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_ADD_DATA.getMessage()), (Object)resourceModulesList.size());
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_EDIT_DATA.getMessage()), (Object)resourceModulesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules item : resourceModulesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENCODING_EXCEEDS_LENGTH.getMessage()));
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            item.setModuleCode(currentCode.toString());
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_ADD_DATA.getMessage()), (Object)insertData.size());
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_EDIT_DATA.getMessage()), (Object)updateData.size());
    }

    public List<SysResourceModules> getResourceModulesByOneRes(List<SysResourceModules> result, SysResourceModules children, List<SysResourceModules> allModules) {
        if (ToolUtil.isEmpty((Object)children)) {
            return result;
        }
        Long parentId = children.getParentModuleId();
        SysResourceModules parentModules = null;
        for (SysResourceModules resourceModule : allModules) {
            if (!parentId.equals(resourceModule.getId())) continue;
            parentModules = resourceModule;
        }
        if (HussarUtils.isNotEmpty(parentModules)) {
            result.add(parentModules);
            return this.getResourceModulesByOneRes(result, parentModules, allModules);
        }
        return result;
    }

    public List<SysResourceModules> getResModulesByModuleIds(List<Long> moduleIds) {
        if (HussarUtils.isEmpty(moduleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long moduleId : moduleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysResourceModules::getId, (Object)moduleId);
        }
        lambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysResourceModulesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public Collection<SysResourceModules> recursiveGetResModule(List<Long> resModuleList, Collection<SysResourceModules> allResModuleList, Collection<SysResourceModules> result) {
        if (HussarUtils.isEmpty(resModuleList) || resModuleList.size() == 1 && PermitConstants.ROOT_ID.equals(resModuleList.get(0))) {
            return result;
        }
        HashSet<Long> parentModuleList = new HashSet<Long>();
        for (SysResourceModules item : allResModuleList) {
            if (!resModuleList.contains(item.getId())) continue;
            result.add(item);
            parentModuleList.add(item.getParentModuleId());
        }
        return this.recursiveGetResModule(new ArrayList<Long>(parentModuleList), allResModuleList, result);
    }

    public boolean save(SysResourceModules entity) {
        return this.hussarBaseResourceAdapter.saveModule(entity);
    }

    public List<SysResourceModules> listByNameAndParentId(String moduleName, Long parentModuleId, Long appId) {
        return this.hussarBaseResourceAdapter.moduleList(moduleName, parentModuleId, appId);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.hussarBaseResourceAdapter.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public String getFullModuleNameById(Long moduleId, Long appId) {
        return this.hussarBaseResourceAdapter.getFullModuleNameById(moduleId, appId);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long appId) {
        return this.hussarBaseResourceAdapter.getFullModuleNameMapByName(moduleName, appId);
    }

    public boolean updateById(SysResourceModules entity) {
        return this.hussarBaseResourceAdapter.updateModule(entity);
    }

    public SysResourceModules getById(Serializable id) {
        return this.hussarBaseResourceAdapter.getModuleByModuleId((Long)id);
    }

    public List<ModuleTreeVo> lazyLoadResModuleTree(ResTreeDto resTreeDto) {
        if (HussarUtils.isEmpty((Object)resTreeDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        Long newNodeId = resTreeDto.getNodeId();
        String nodeType = resTreeDto.getNodeType();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List<Object> result = new ArrayList();
        List<Object> list1 = new ArrayList();
        Long appId = resTreeDto.getApplicationId();
        Long bizAppId = resTreeDto.getBizAppId();
        if (HussarUtils.isEmpty((Object)newNodeId)) {
            ModuleTreeVo root = new ModuleTreeVo();
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
            root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
            root.setIsModule("1");
            root.setType("isRoot");
            root.setConstant("0");
            root.setIsLeaf("0");
            root.setIcon("tree-com");
            boolean bl = this.existUnifyApp();
            if (bl) {
                root.setId((Serializable)Constants.ROOT_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                if (HussarUtils.isEmpty((Object)appId)) {
                    List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
                    List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                    List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
                    root.setChildren(childrenList);
                    if (HussarUtils.isNotEmpty(childrenList)) {
                        root.setHasChildren(Boolean.valueOf(true));
                    } else {
                        root.setIsLeaf("1");
                    }
                    result.add(root);
                    return result;
                }
            } else {
                root.setId((Serializable)Constants.RES_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                root.setId((Serializable)Constants.RES_NODE_ID);
                appId = 1L;
                newNodeId = Constants.RES_NODE_ID;
                if (HussarUtils.isNotEmpty((Object)root.getId())) {
                    result.add(root);
                }
                list1 = this.sysResourceModulesMapper.lazyLoadModulesResTree(newNodeId, appId, null);
                root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(list1)));
                String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.core.tenant.type");
                if ("onsystem".equals(tenantType) && HussarUtils.isNotEmpty((Object)bizAppId)) {
                    list1 = list1.stream().filter(moduleTreeVo -> Constants.RES_FUNC_PORTAL_ID.equals(moduleTreeVo.getId())).collect(Collectors.toList());
                }
                result.addAll(list1);
            }
        } else {
            boolean isModule;
            boolean bl = isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType) || ToolUtil.equals((Object)"app", (Object)nodeType);
            if (isModule) {
                List sysUserRoleIds;
                Long roleId;
                list1 = this.sysResourceModulesMapper.lazyLoadModulesResTree(newNodeId, appId, bizAppId);
                String string = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.core.tenant.type");
                if ("onsystem".equals(string) && HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = shiroUser.getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
                    List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
                    List finalCurrentAppIds = currentAppIds.stream().map(Object::toString).collect(Collectors.toList());
                    list1 = list1.stream().filter(jsTreeModel -> finalCurrentAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
                }
            }
            result.addAll(list1);
        }
        for (ModuleTreeVo moduleTreeVo2 : result) {
            String isModule = moduleTreeVo2.getType();
            if ("isModule".equals(isModule)) {
                moduleTreeVo2.getState().put("notLeafModule", true);
            }
            if ((Long)moduleTreeVo2.getId() != 4L && (moduleTreeVo2.getAppId() == null || !"noCode".equals(moduleTreeVo2.getModSource()))) continue;
            moduleTreeVo2.setCanAddModule(Boolean.valueOf(false));
            moduleTreeVo2.setIsNoCode("1");
        }
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            result = result.stream().filter(r -> "0".equals(r.getIsSys()) || (Long)r.getId() == 1L).collect(Collectors.toList());
        }
        TranslateUtil.translate(result, AbstractNoIconHussarLazyTreeDefinition::getLabelLangKey, AbstractNoIconHussarLazyTreeDefinition::setLabel);
        return HussarTreeParser.getTreeList(result);
    }

    public Page<SearchModuleVo> searchResModule(PageInfo pageInfo, String name) {
        List<SearchModuleVo> result;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            queryParams.put("lang", lang);
            result = this.sysResourceModulesMapper.searchResModuleForTrans((Page<SearchModuleVo>)page, queryParams);
            TranslateUtil.translate(result, SearchModuleVo::getNameLangKey, SearchModuleVo::setName);
            TranslateUtil.translate(result, SearchModuleVo::getParentNameLangKey, SearchModuleVo::setParentName);
        } else {
            result = this.sysResourceModulesMapper.searchResModule(page, queryParams);
        }
        page.setRecords(result);
        return page;
    }

    public List<ModuleTreeVo> backResModuleTree(Long id) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        ModuleTreeVo root = new ModuleTreeVo();
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        root.setIsLeaf("0");
        root.setIcon("tree-com");
        boolean flag = this.existUnifyApp();
        if (flag) {
            root.setId((Serializable)Constants.ROOT_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(false));
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
            List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
            List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
            if (HussarUtils.isNotEmpty(childrenList)) {
                root.setHasChildren(Boolean.valueOf(true));
            } else {
                root.setIsLeaf("1");
            }
            result.add(root);
            result.addAll((Collection<ModuleTreeVo>)childrenList);
        } else {
            root.setId((Serializable)Constants.RES_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(false));
            root.setId((Serializable)Constants.RES_NODE_ID);
            result.add(root);
        }
        List<ModuleTreeVo> list = this.sysResourceModulesMapper.getAllResModule();
        if (HussarUtils.isEmpty(list)) {
            return result;
        }
        HashMap childMap = new HashMap();
        ModuleTreeVo module = null;
        for (ModuleTreeVo moduleTreeVo : list) {
            List<ModuleTreeVo> vos;
            if (flag && (Long)moduleTreeVo.getParentId() == 1L && moduleTreeVo.getApplicationId() != 1L) {
                moduleTreeVo.setParentId((Serializable)moduleTreeVo.getApplicationId());
            }
            if (id.equals(moduleTreeVo.getId())) {
                module = moduleTreeVo;
            }
            if (HussarUtils.isEmpty(childMap.get(moduleTreeVo.getParentId()))) {
                vos = new ArrayList<ModuleTreeVo>();
                vos.add(moduleTreeVo);
                childMap.put(moduleTreeVo.getParentId(), vos);
                continue;
            }
            vos = (List)childMap.get(moduleTreeVo.getParentId());
            vos.add(moduleTreeVo);
        }
        if (HussarUtils.isEmpty(module)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_NO_FOUND.getMessage()));
        }
        ArrayList<ModuleTreeVo> parentModuleList = new ArrayList<ModuleTreeVo>();
        this.getParentModules(parentModuleList, module, list);
        parentModuleList.add(module);
        for (ModuleTreeVo treeVo : parentModuleList) {
            Long parentId = (Long)treeVo.getParentId();
            List child = (List)childMap.get(parentId);
            if (!HussarUtils.isNotEmpty((Object)child)) continue;
            for (ModuleTreeVo vo : child) {
                vo.setHasChildren(Boolean.valueOf(childMap.containsKey(vo.getId())));
            }
            result.addAll(child);
        }
        for (ModuleTreeVo treeVo : result) {
            String isModule = treeVo.getType();
            if (!"isModule".equals(isModule)) continue;
            treeVo.getState().put("notLeafModule", true);
        }
        return HussarTreeParser.getTreeList(result);
    }

    public void updateResModuleStatusByAppId(Long appId, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(HussarDelflagEntity::getDelFlag, (Object)status)).eq(SysResourceModules::getAppId, (Object)appId);
        this.update((Wrapper)wrapper);
    }

    public void deleteResModuleByAppId(Long appId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysResourceModules::getAppId, (Object)appId);
        this.remove((Wrapper)wrapper);
    }

    public Page<SearchModuleVo> searchModuleAndRes(PageInfo pageInfo, ResourceModuleTreeDto resourceModuleTreeDto) {
        String name = resourceModuleTreeDto.getName();
        Long applicationId = resourceModuleTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)applicationId)) {
            applicationId = 1L;
        }
        Long noCodeAppId = resourceModuleTreeDto.getAppId();
        boolean open = this.secureAssesmentProperties.isOpen();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("applicationId", applicationId);
        queryParams.put("appId", noCodeAppId);
        if (open) {
            queryParams.put("isSys", null);
        } else {
            String isSys = null;
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                isSys = "0";
            }
            queryParams.put("isSys", isSys);
        }
        List<SearchModuleVo> result = this.sysResourceModulesMapper.searchModuleAndRes((Page<SearchModuleVo>)page, queryParams);
        page.setRecords(result);
        return page;
    }

    public List<JSTreeModel> backModuleAndResTree(ResModuleBackDto resModuleBackDto) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        Long id = resModuleBackDto.getId();
        String type = resModuleBackDto.getType();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        root.setIsModule("1");
        root.setIsRes("0");
        result.add(root);
        List<JSTreeModel> list = this.sysResourceModulesMapper.getAllResModuleTree();
        if (HussarUtils.isEmpty(list)) {
            return result;
        }
        HashMap<Long, List<JSTreeModel>> childMap = new HashMap<Long, List<JSTreeModel>>();
        JSTreeModel module = new JSTreeModel();
        if ("module".equals(type)) {
            this.initModuleTree(id, list, module, childMap);
        } else {
            this.initResAndModuleTree(id, list, module, childMap);
        }
        ArrayList<JSTreeModel> parentModuleList = new ArrayList<JSTreeModel>();
        this.getParentJsTreeModules(parentModuleList, module, list);
        parentModuleList.add(module);
        for (JSTreeModel treeVo : parentModuleList) {
            Long parentId = treeVo.getParent();
            List child = (List)childMap.get(parentId);
            if (!HussarUtils.isNotEmpty((Object)child)) continue;
            result.addAll(child);
        }
        ResourceModuleTreeDto treeDto = new ResourceModuleTreeDto();
        treeDto.setRoleId(resModuleBackDto.getRoleId());
        treeDto.setFunctionId(resModuleBackDto.getFunctionId());
        treeDto.setDefaultResourceId(resModuleBackDto.getDefaultResourceId());
        this.initModuleHasChild(list, result, module);
        this.initResState(treeDto, result);
        if (HussarUtils.isNotEmpty((Object)module) && HussarUtils.isNotEmpty((Object)module.getApplicationId())) {
            root.setId(module.getApplicationId());
        }
        TranslateUtil.translate(result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return TreeModelUtils.merge(result);
    }

    private void initModuleHasChild(List<JSTreeModel> list, List<JSTreeModel> result, JSTreeModel module) {
        Map<Long, List<Long>> parentToChildrenMap = list.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(JSTreeModel::getParent, Collectors.mapping(JSTreeModel::getId, Collectors.toList())));
        Map<Long, Boolean> hasResMap = this.checkModulesHaveRes(list, parentToChildrenMap);
        for (JSTreeModel model : result) {
            Long moduleId = model.getId();
            boolean flag = parentToChildrenMap.containsKey(moduleId) || hasResMap.containsKey(moduleId) && hasResMap.get(moduleId) != false;
            model.setChildren(flag);
        }
    }

    private Map<Long, Boolean> checkModulesHaveRes(List<JSTreeModel> list, Map<Long, List<Long>> parentToChildrenMap) {
        HashMap<Long, Boolean> hasResMap = new HashMap<Long, Boolean>();
        List<Long> lastModuleIds = list.stream().map(JSTreeModel::getId).filter(id -> !parentToChildrenMap.containsKey(id)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lastModuleIds)) {
            return hasResMap;
        }
        List<ResCountVo> allCounts = this.getResCountsByModuleIds(lastModuleIds, hasResMap);
        allCounts.forEach(countMap -> {
            Long moduleId = countMap.getModuleId();
            Long count = countMap.getCount();
            hasResMap.put(moduleId, count > 0L);
        });
        lastModuleIds.forEach(moduleId -> hasResMap.putIfAbsent((Long)moduleId, false));
        return hasResMap;
    }

    private List<ResCountVo> getResCountsByModuleIds(List<Long> lastModuleIds, Map<Long, Boolean> hasResMap) {
        List<ResCountVo> allCounts = this.sysResourcesMapper.countResourcesByModuleIds(lastModuleIds);
        List partModuleIds = Lists.partition(new ArrayList<Long>(lastModuleIds), (int)PermitConstants.SELECT_BATCH_SIZE);
        CountDownLatch countDownLatch = new CountDownLatch(partModuleIds.size());
        Executor executor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        for (List currentModuleIds : partModuleIds) {
            if (executor == null) continue;
            executor.execute(() -> {
                try {
                    List<ResCountVo> counts = this.sysResourcesMapper.countResourcesByModuleIds(currentModuleIds);
                    counts.forEach(count -> hasResMap.put(count.getModuleId(), count.getCount() > 0L));
                    currentModuleIds.forEach(moduleId -> hasResMap.putIfAbsent((Long)moduleId, false));
                    allCounts.addAll(counts);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return allCounts;
    }

    private void initResAndModuleTree(Long id, List<JSTreeModel> list, JSTreeModel module, Map<Long, List<JSTreeModel>> childMap) {
        JSTreeModel treeModel = this.sysResourcesMapper.getResourceById(id);
        if (HussarUtils.isEmpty((Object)treeModel)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_NO_FOUND.getMessage()));
        }
        BeanUtil.copy((Object)treeModel, (Object)module);
        List<JSTreeModel> resList = this.sysResourcesMapper.getResourceByModuleId(module.getParent());
        list.addAll(resList);
        for (JSTreeModel moduleTreeVo : list) {
            List<Object> vos;
            if (HussarUtils.isEmpty(childMap.get(moduleTreeVo.getParent()))) {
                vos = new ArrayList<JSTreeModel>();
                vos.add(moduleTreeVo);
                childMap.put(moduleTreeVo.getParent(), vos);
                continue;
            }
            vos = childMap.get(moduleTreeVo.getParent());
            vos.add(moduleTreeVo);
        }
    }

    private void initModuleTree(Long id, List<JSTreeModel> list, JSTreeModel module, Map<Long, List<JSTreeModel>> childMap) {
        for (JSTreeModel moduleTreeVo : list) {
            List<Object> vos;
            if (id.equals(moduleTreeVo.getId())) {
                BeanUtil.copy((Object)moduleTreeVo, (Object)module);
            }
            if (HussarUtils.isEmpty(childMap.get(moduleTreeVo.getParent()))) {
                vos = new ArrayList<JSTreeModel>();
                vos.add(moduleTreeVo);
                childMap.put(moduleTreeVo.getParent(), vos);
                continue;
            }
            vos = childMap.get(moduleTreeVo.getParent());
            vos.add(moduleTreeVo);
        }
        if (HussarUtils.isEmpty((Object)module)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_NO_FOUND.getMessage()));
        }
    }

    private void getParentJsTreeModules(List<JSTreeModel> result, JSTreeModel module, List<JSTreeModel> list) {
        if (HussarUtils.isNotEmpty((Object)module)) {
            Long parentId = module.getParent();
            JSTreeModel parentModules = null;
            for (JSTreeModel treeVo : list) {
                if (!parentId.equals(treeVo.getId())) continue;
                parentModules = treeVo;
            }
            if (HussarUtils.isNotEmpty(parentModules)) {
                result.add(parentModules);
                this.getParentJsTreeModules(result, parentModules, list);
            }
        }
    }

    private void getParentModules(List<ModuleTreeVo> result, ModuleTreeVo module, List<ModuleTreeVo> list) {
        if (HussarUtils.isNotEmpty((Object)module)) {
            Long parentId = (Long)module.getParentId();
            ModuleTreeVo parentModules = null;
            for (ModuleTreeVo treeVo : list) {
                if (!parentId.equals(treeVo.getId())) continue;
                parentModules = treeVo;
            }
            if (HussarUtils.isNotEmpty(parentModules)) {
                result.add(parentModules);
                this.getParentModules(result, parentModules, list);
            }
        }
    }

    private boolean existUnifyApp() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return HussarUtils.isNotEmpty((Object)application);
    }

    private List<ModuleTreeVo> getAppTree(List<Long> appIdList) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        if (HussarUtils.isEmpty(appIdList)) {
            return Collections.emptyList();
        }
        List applications = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getId, appIdList));
        List<Object> relationAppIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)applications)) {
            List resourceModules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResourceModules::getApplicationId, appIdList)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            if (HussarUtils.isNotEmpty((Object)resourceModules)) {
                relationAppIds = resourceModules.stream().map(SysResourceModules::getApplicationId).collect(Collectors.toList());
            }
            for (SysApplication application : applications) {
                ModuleTreeVo treeModel = new ModuleTreeVo();
                treeModel.setId((Serializable)application.getId());
                treeModel.setLabel(application.getAppName());
                treeModel.setCode(application.getAppCode());
                treeModel.setApplicationId(application.getId());
                treeModel.setType("app");
                treeModel.setParentId((Serializable)Constants.ROOT_NODE_ID);
                treeModel.setConstant("0");
                treeModel.setHasChildren(Boolean.valueOf(relationAppIds.contains(application.getId())));
                treeModel.setIsLeaf(relationAppIds.contains(application.getId()) ? "0" : "1");
                treeModel.setIcon("caidan_appManagement");
                result.add(treeModel);
            }
        }
        return result;
    }

    public void initResState(ResourceModuleTreeDto resourceModuleTreeDto, List<JSTreeModel> result) {
        if (HussarUtils.isEmpty(result) || HussarUtils.isEmpty((Object)resourceModuleTreeDto.getRoleId()) && HussarUtils.isEmpty((Object)resourceModuleTreeDto.getFunctionId()) && HussarUtils.isEmpty((Object)resourceModuleTreeDto.getDefaultResourceId())) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)resourceModuleTreeDto.getRoleId())) {
            this.initResStateForRole(resourceModuleTreeDto, result);
        }
        if (HussarUtils.isNotEmpty((Object)resourceModuleTreeDto.getFunctionId()) || HussarUtils.isNotEmpty((Object)resourceModuleTreeDto.getDefaultResourceId())) {
            this.initResStateForFunction(resourceModuleTreeDto, result);
        }
    }

    private void initResStateForFunction(ResourceModuleTreeDto resourceModuleTreeDto, List<JSTreeModel> result) {
        Long functionId = resourceModuleTreeDto.getFunctionId();
        Long defaultResourceId = resourceModuleTreeDto.getDefaultResourceId();
        HashSet<Long> resourceIds = new HashSet<Long>();
        if (HussarUtils.isNotEmpty((Object)functionId)) {
            List funcResources = this.sysFunctionResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId));
            resourceIds = funcResources.stream().map(SysFunctionResources::getResourceId).collect(Collectors.toSet());
        }
        if (HussarUtils.isNotEmpty((Object)defaultResourceId)) {
            resourceIds.add(defaultResourceId);
        }
        if (HussarUtils.isEmpty(resourceIds)) {
            return;
        }
        List allModules = this.sysResourceModulesMapper.selectList(null);
        Map<Long, Long> moduleParentMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, SysResourceModules::getParentModuleId));
        HashSet<Long> allRelatedModuleIds = new HashSet<Long>();
        if (HussarUtils.isNotEmpty(resourceIds)) {
            List resList = this.sysResourcesMapper.selectBatchIds(new ArrayList(resourceIds));
            Set<Long> moduleIds = resList.stream().map(SysResources::getModuleId).collect(Collectors.toSet());
            moduleIds.forEach(moduleId -> this.getAllParentModules((Long)moduleId, moduleParentMap, (Set<Long>)allRelatedModuleIds));
        }
        Map<Long, Set<Long>> moduleResourceMap = this.buildModuleResourceMap(result, allModules);
        this.setNodeStatesForFunction(result, resourceIds, defaultResourceId, allRelatedModuleIds, moduleResourceMap);
    }

    private void setNodeStatesForFunction(List<JSTreeModel> nodes, Set<Long> resourceIds, Long defaultResourceId, Set<Long> allRelatedModuleIds, Map<Long, Set<Long>> moduleResourceMap) {
        for (JSTreeModel node : nodes) {
            boolean isChecked;
            Map state = node.getState();
            if ("1".equals(node.getIsRes())) {
                isChecked = resourceIds.contains(node.getId());
                state.put("isChecked", isChecked);
                state.put("isAllChecked", isChecked);
                state.put("disabled", HussarUtils.equals((Object)defaultResourceId, (Object)node.getId()));
                continue;
            }
            if (!"1".equals(node.getIsModule())) continue;
            isChecked = allRelatedModuleIds.contains(node.getId());
            state.put("isChecked", isChecked);
            state.put("disabled", false);
            boolean flag = this.buildModuleState(node, resourceIds, moduleResourceMap);
            state.put("isAllChecked", flag);
        }
    }

    private void initResStateForRole(ResourceModuleTreeDto resourceModuleTreeDto, List<JSTreeModel> result) {
        Long roleId = resourceModuleTreeDto.getRoleId();
        List roleResources = this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId));
        if (HussarUtils.isEmpty((Object)roleResources)) {
            return;
        }
        Map<Long, String> resourceRelationMap = roleResources.stream().collect(Collectors.toMap(SysRoleResource::getResourceId, SysRoleResource::getRelationSource, (existing, current) -> "1".equals(existing) ? existing : current));
        List allModules = this.sysResourceModulesMapper.selectList(null);
        Map<Long, Long> moduleParentMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, SysResourceModules::getParentModuleId));
        HashSet<Long> allRelatedModuleIds = new HashSet<Long>();
        Set<Long> resourceIds = resourceRelationMap.keySet();
        if (HussarUtils.isNotEmpty(resourceIds)) {
            List resList = this.sysResourcesMapper.selectBatchIds(new ArrayList<Long>(resourceIds));
            Set<Long> moduleIds = resList.stream().map(SysResources::getModuleId).collect(Collectors.toSet());
            moduleIds.forEach(moduleId -> this.getAllParentModules((Long)moduleId, moduleParentMap, (Set<Long>)allRelatedModuleIds));
        }
        Map<Long, Set<Long>> moduleResourceMap = this.buildModuleResourceMap(result, allModules);
        this.setNodeStates(result, resourceIds, resourceRelationMap, allRelatedModuleIds, moduleResourceMap);
    }

    private void getAllParentModules(Long moduleId, Map<Long, Long> moduleParentMap, Set<Long> resultSet) {
        resultSet.add(moduleId);
        Long parentId = moduleParentMap.get(moduleId);
        if (HussarUtils.isNotEmpty((Object)parentId) && resultSet.add(parentId)) {
            this.getAllParentModules(parentId, moduleParentMap, resultSet);
        }
    }

    private void setNodeStates(List<JSTreeModel> nodes, Set<Long> resourceIds, Map<Long, String> resourceRelationMap, Set<Long> allRelatedModuleIds, Map<Long, Set<Long>> moduleResourceMap) {
        for (JSTreeModel node : nodes) {
            boolean isChecked;
            Map state = node.getState();
            if ("1".equals(node.getIsRes())) {
                isChecked = resourceIds.contains(node.getId());
                state.put("isChecked", isChecked);
                state.put("isAllChecked", isChecked);
                state.put("disabled", "1".equals(resourceRelationMap.get(node.getId())));
                continue;
            }
            if (!"1".equals(node.getIsModule())) continue;
            isChecked = allRelatedModuleIds.contains(node.getId());
            state.put("isChecked", isChecked);
            state.put("disabled", false);
            boolean flag = this.buildModuleState(node, resourceIds, moduleResourceMap);
            state.put("isAllChecked", flag);
        }
    }

    private Map<Long, Set<Long>> buildModuleResourceMap(List<JSTreeModel> nodes, List<SysResourceModules> allModules) {
        if (HussarUtils.isEmpty(nodes) || HussarUtils.isEmpty(allModules)) {
            return Collections.emptyMap();
        }
        List<JSTreeModel> moduleNodes = nodes.stream().filter(node -> node != null && "1".equals(node.getIsModule())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(moduleNodes)) {
            return Collections.emptyMap();
        }
        Map parentToChildrenMap = allModules.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SysResourceModules::getParentModuleId, Collectors.mapping(SysResourceModules::getId, Collectors.toList())));
        HashMap<Long, Set> moduleToAllChildren = new HashMap<Long, Set>();
        HashSet<Long> allRelatedModuleIds = new HashSet<Long>();
        moduleNodes.forEach(moduleNode -> {
            HashSet<Long> childModules = new HashSet<Long>();
            this.getAllChildModules(moduleNode.getId(), parentToChildrenMap, childModules);
            moduleToAllChildren.put(moduleNode.getId(), childModules);
            allRelatedModuleIds.addAll(childModules);
        });
        List<SysResources> resources = this.getResByModuleIds(allRelatedModuleIds);
        if (HussarUtils.isEmpty(resources)) {
            return Collections.emptyMap();
        }
        Map moduleToResources = resources.stream().collect(Collectors.groupingBy(SysResources::getModuleId, Collectors.mapping(SysResources::getId, Collectors.toSet())));
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        moduleToAllChildren.forEach((moduleId, childModuleIds) -> {
            Set resourceIds = childModuleIds.stream().filter(moduleToResources::containsKey).flatMap(id -> ((Set)moduleToResources.get(id)).stream()).collect(Collectors.toSet());
            result.put((Long)moduleId, resourceIds);
        });
        return result;
    }

    private List<SysResources> getResByModuleIds(Set<Long> allRelatedModuleIds) {
        if (HussarUtils.isEmpty(allRelatedModuleIds)) {
            return new ArrayList<SysResources>();
        }
        List partModuleIds = LambdaQueryUtil.getSplitList(new ArrayList<Long>(allRelatedModuleIds));
        return this.sysResourcesMapper.selectByModuleIds(partModuleIds);
    }

    private void getAllChildModules(Long moduleId, Map<Long, List<Long>> parentToChildrenMap, Set<Long> result) {
        if (result.add(moduleId)) {
            parentToChildrenMap.getOrDefault(moduleId, Collections.emptyList()).forEach(childId -> this.getAllChildModules((Long)childId, parentToChildrenMap, result));
        }
    }

    private boolean buildModuleState(JSTreeModel module, Set<Long> selectedResourceIds, Map<Long, Set<Long>> moduleResourceMap) {
        Long moduleId = module.getId();
        Set moduleResources = moduleResourceMap.getOrDefault(moduleId, Collections.emptySet());
        long selectedCount = moduleResources.stream().filter(selectedResourceIds::contains).count();
        return HussarUtils.isNotEmpty(moduleResources) && selectedCount == (long)moduleResources.size();
    }
}

