/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ArrayListMultimap;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruFilterUnitService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.StruFilteredVo;
import com.jxdinfo.hussar.authorization.organ.vo.StruVO;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserAttachmentMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserOrganFeignDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalQueryUserMangerService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.localQueryUserManagerServiceImpl")
public class LocalQueryUserManagerServiceImpl
extends CommonQueryOrganizationManager
implements ILocalQueryUserMangerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalQueryUserManagerServiceImpl.class);
    private static final String CONTAIN_SYS = "containSys";
    private static final String ESCAPE_SYMBOL = "escapeSymbol";
    private static final String USER_ACCOUNT = "userAccount";
    private static final String USER_NAME = "userName";
    private static final String ACCOUNT_STATUS = "accountStatus";
    private static final String ACCOUNT_PROPERTY = "accountProperty";
    private static final String STU_PATH = "struPath";
    private static final String USER_IDS = "userIds";
    private static final String USER_NAME_LOWER_CASE = "userNameLowerCase";
    private static final String FILTER_STRU_IDS = "filterStruIds";
    private static final Pattern ALL_LETTER = Pattern.compile("^[A-Za-z0-9]+$");
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    @Lazy
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;
    @Resource
    private SysUserAttachmentMapper attachmentMapper;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Autowired(required=false)
    private ISysTenantMultUserService sysTenantMultUserService;
    @Resource
    private ISysStruFilterUnitService sysStruFilterUnitService;
    private static final Long[] THREE_SENIOR_ADMINS = new Long[]{1450757481235202050L, 1450757642371981314L, 1450757642371981324L};
    private static String GRADE_SYSTEMADMIN_TYPE = "2";
    private static String GRADE_SECAUDITADMIN_TYPE = "1";
    private static String GRADE_SECURITYADMIN_TYPE = "0";
    private static int SPLIT_LT = 500;

    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String struPath;
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)currentUser) && (HussarUtils.equals((Object)innerOrganNodeId, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)outOrganNodeId, (Object)queryUserDto.getDepStruId()))) {
            String organProperty = HussarUtils.equals((Object)innerOrganNodeId, (Object)queryUserDto.getDepStruId()) ? "0" : "1";
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId(), currentUser);
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (HussarUtils.isNotEmpty((Object)currentUser) && currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            queryUserDto.setContainSys("0");
        }
        queryParams.put(CONTAIN_SYS, StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(innerOrganNodeId, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(outOrganNodeId, depStruId.get())) {
            struPath = "1";
            queryParams.put(CONTAIN_SYS, "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struPath = struTemp.getStruFid();
            queryParams.put(CONTAIN_SYS, "0");
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.isEmpty((Object)casKeyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    String tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)casKeyList)) {
                for (String cacheKey : casKeyList) {
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                    if (!HussarUtils.isNotEmpty((Object)model)) continue;
                    lockUserIds.add(Long.parseLong(model.getUserId()));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put(USER_ACCOUNT, SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put(ACCOUNT_STATUS, StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put(ACCOUNT_PROPERTY, StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put(STU_PATH, StringUtils.trimToEmpty((String)struPath));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUserOrganInfosNew((Page<SearchUserVo>)page, queryParams);
        this.fillOrganInfos(userInfoList);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    private void fillOrganInfos(List<SearchUserVo> userInfoList) {
        if (HussarUtils.isEmpty(userInfoList)) {
            return;
        }
        List userIdList = userInfoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List<UserOrganPostVo> organByUserIds = this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIdList), null);
        ArrayListMultimap userOrganMap = ArrayListMultimap.create();
        for (UserOrganPostVo userOrganPostVo : organByUserIds) {
            userOrganMap.put((Object)userOrganPostVo.getUserId(), (Object)userOrganPostVo);
        }
        for (SearchUserVo vo : userInfoList) {
            List organInfoList = userOrganMap.get((Object)vo.getId());
            if (HussarUtils.isEmpty((Object)organInfoList)) continue;
            String organName = organInfoList.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            vo.setDepartmentName(organName);
        }
    }

    private void fillDepartmentName(List<SearchUserVo> userInfoList) {
        if (HussarUtils.isEmpty(userInfoList)) {
            return;
        }
        List userIdList = userInfoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List<UserOrganPostVo> organByUserIds = this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIdList), null);
        Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (SearchUserVo vo : userInfoList) {
            List<UserOrganPostVo> organInfoList = userOrganMap.get(vo.getId());
            if (HussarUtils.isEmpty(organInfoList)) continue;
            String organName = organInfoList.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            vo.setDepartmentName(organName);
        }
    }

    public Page<SearchUserTreeVo> searchUser(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        page.setOptimizeCountSql(false);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        switch (resultType) {
            case "0": {
                List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)struUsers)) {
                    List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                    queryUserParams.put(USER_IDS, userIdList);
                    break;
                }
                return page;
            }
            case "1": {
                List<Long> struIdList = this.getSubOrganByIds(organIds);
                List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)struUsers)) {
                    List userIdList = struUsers.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
                    queryUserParams.put(USER_IDS, userIdList);
                    break;
                }
                return page;
            }
            case "2": {
                queryUserParams.put(USER_IDS, null);
                break;
            }
            default: {
                List struUsers;
                List<Long> struIdList = this.getSubOrganByIds(organIds);
                if (HussarUtils.isNotEmpty(struIdList) && HussarUtils.isNotEmpty((Object)(struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))))) {
                    List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                    userIds.addAll(userIdList);
                    userIds = userIds.stream().distinct().collect(Collectors.toList());
                }
                queryUserParams.put(USER_IDS, userIds);
            }
        }
        queryUserParams.put("name", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryUserParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchUserTreeVo> searchUserTreeVos = this.sysUsersMapper.searchUserTreeVo((Page<SearchUserTreeVo>)page, queryUserParams);
        if (HussarUtils.isEmpty(searchUserTreeVos)) {
            return page;
        }
        this.wrapSearchUsers(searchUserTreeVos);
        page.setRecords(searchUserTreeVos);
        return page;
    }

    private void wrapSearchUsers(List<SearchUserTreeVo> searchUserTreeVos) {
        List ids = searchUserTreeVos.stream().map(SearchUserTreeVo::getId).collect(Collectors.toList());
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, ids));
        Map<Long, List<SysStruUser>> map = struUsers.stream().collect(Collectors.groupingBy(SysStruUser::getUserId));
        List struIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List organVos = this.sysOrganService.getOrgansByStruIds(struIds);
        Map organVoMap = organVos.stream().collect(Collectors.toMap(SearchOrganVo::getId, Function.identity()));
        for (SearchUserTreeVo userTreeVo : searchUserTreeVos) {
            List<SysStruUser> struUserList = map.get(userTreeVo.getId());
            if (!HussarUtils.isNotEmpty(struUserList)) continue;
            List list = struUserList.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
            List vos = LocalQueryUserManagerServiceImpl.getCollection(organVoMap, list);
            String organFnames = null;
            String organNames = null;
            if (HussarUtils.isNotEmpty(vos)) {
                organNames = vos.stream().map(SearchOrganVo::getLabel).collect(Collectors.joining(","));
                organFnames = vos.stream().map(SearchOrganVo::getOrganFname).collect(Collectors.joining(","));
            }
            userTreeVo.setParentName(organNames);
            userTreeVo.setOrganFname(organFnames);
        }
    }

    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        List list;
        List<Object> result = new ArrayList<UserVo>();
        if (HussarUtils.isEmpty(organIds) && HussarUtils.isEmpty(userIds)) {
            return result;
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            List<UserVo> userList = this.sysUsersMapper.getUserByIds(userIds);
            result.addAll(userList);
        }
        if (HussarUtils.isNotEmpty(organIds) && HussarUtils.isNotEmpty((Object)(list = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds))))) {
            List fidList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String fid : fidList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
            }
            List sysStrus = this.sysStruService.list((Wrapper)wrapper);
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            List<UserVo> userVoList = this.sysUsersMapper.getUserByOrganIds(struIdList);
            result.addAll(userVoList);
        }
        if (HussarUtils.isNotEmpty(result)) {
            result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        }
        return result;
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        ArrayList<OrganUserTreeVo> organUserTreeVos = new ArrayList<OrganUserTreeVo>();
        if (HussarUtils.isEmpty(parentOrganIds)) {
            return organUserTreeVos;
        }
        List<Long> organIds = this.getParentOrganIds(parentOrganIds);
        for (Long organId : organIds) {
            SysOrgan sysOrgan;
            if (organId.equals(innerOrganNodeId)) {
                sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "0", this.sysStruMapper.getOrganFname(innerOrganNodeId));
                continue;
            }
            if (organId.equals(outOrganNodeId)) {
                sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "1", this.sysStruMapper.getOrganFname(outOrganNodeId));
                continue;
            }
            this.getOrganUserTree(needParentOrganInfo, organUserTreeVos, organId, resultType);
        }
        return HussarTreeParser.getTreeList(organUserTreeVos);
    }

    private List<Long> getParentOrganIds(List<Long> struIds) {
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        if (!struIds.contains(innerOrganNodeId) && !struIds.contains(outOrganNodeId)) {
            List sysStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, String> fidMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getStruFid));
            ArrayList<Long> removeIds = new ArrayList<Long>();
            block0: for (Long struId : struIds) {
                int num = 0;
                String fidParent = fidMap.get(struId);
                for (Long id : struIds) {
                    String fid = fidMap.get(id);
                    if (fidParent.contains(fid)) {
                        ++num;
                    }
                    if (num <= 1) continue;
                    removeIds.add(struId);
                    continue block0;
                }
            }
            struIds.removeAll(removeIds);
            return new ArrayList<Long>(struIds);
        }
        if (struIds.contains(innerOrganNodeId) && struIds.contains(outOrganNodeId)) {
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(innerOrganNodeId);
            result.add(outOrganNodeId);
            return result;
        }
        Long rootId = struIds.contains(innerOrganNodeId) ? innerOrganNodeId : outOrganNodeId;
        List sysStrus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds));
        sysStrus.removeIf(item -> HussarUtils.equals((Object)item.getId(), (Object)innerOrganNodeId) || HussarUtils.equals((Object)item.getId(), (Object)outOrganNodeId));
        if (HussarUtils.isNotEmpty((Object)sysStrus)) {
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).collect(Collectors.toList());
            List parentStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)rootId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List parentFidList = parentStrus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)parentStrus)) {
                List<Long> parentOrganIds = this.getParentOrganIds(struIdList);
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(rootId);
                result.addAll(parentOrganIds);
                return result;
            }
            ArrayList<SysStru> strus = new ArrayList<SysStru>();
            for (SysStru stru : sysStrus) {
                String parentFid;
                String struFid = stru.getStruFid();
                int num = 0;
                Iterator iterator = parentFidList.iterator();
                while (iterator.hasNext() && !struFid.contains(parentFid = (String)iterator.next())) {
                    ++num;
                }
                if (num != parentFidList.size()) continue;
                strus.add(stru);
            }
            if (HussarUtils.isEmpty(strus)) {
                ArrayList result = new ArrayList();
                result.add(rootId);
                return result;
            }
            List<Long> parentIds = strus.stream().map(SysStru::getId).collect(Collectors.toList());
            List<Long> parentOrganIds = this.getParentOrganIds(parentIds);
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(rootId);
            result.addAll(parentOrganIds);
            return result;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(rootId);
        return result;
    }

    private void getOrganUserTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType) {
        List<OrganUserTreeVo> organs;
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(PermitConstants.TREE_TYPE_ORGAN)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (resultType.equals(PermitConstants.TREE_TYPE_USER)) {
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<Object> userTreeVos = new ArrayList();
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
                userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUserWithSec(LambdaQueryUtil.getSplitList(struIds), securityLevel);
            } else {
                userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            }
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                flag = true;
                organUserTreeVos.addAll(userTreeVos);
            }
        }
        if (resultType.equals(PermitConstants.TREE_TYPE_ORGAN_USER)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<Object> userTreeVos = new ArrayList();
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
                userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUserWithSec(LambdaQueryUtil.getSplitList(struIds), securityLevel);
            } else {
                userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            }
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                organs.addAll(userTreeVos);
            }
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (needParentOrganInfo.booleanValue()) {
            SearchOrganVo organVo = this.sysStruMapper.getOrganById(organId);
            if (HussarUtils.isEmpty((Object)organVo)) {
                return;
            }
            OrganUserTreeVo organUserTreeVo = this.initRootTree(organVo.getLabel(), organId);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(struIds);
            organUserTreeVo.setUserCount(organIdUserCount.get(organId));
            organUserTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVo.setIcon(organVo.getIcon());
            organUserTreeVo.setOrganType(organVo.getOrganType());
            organUserTreeVos.add(organUserTreeVo);
        }
    }

    private void getInAndOutTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType, String organProperty, String organName) {
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(PermitConstants.TREE_TYPE_ORGAN) || resultType.equals(PermitConstants.TREE_TYPE_ORGAN_USER)) {
            List<OrganUserTreeVo> internalOrgans = this.getOneOrganInfo(organId, resultType, organProperty);
            flag = internalOrgans.size() > 0;
            organUserTreeVos.addAll(internalOrgans);
        }
        if (needParentOrganInfo.booleanValue()) {
            OrganUserTreeVo internalOrganStaffTreeVo = this.initRootTree(organName, organId);
            internalOrganStaffTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVos.add(internalOrganStaffTreeVo);
        }
    }

    private List<OrganUserTreeVo> getOneOrganInfo(Long organId, Integer resultType, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", organId);
        queryParams.put("organProperty", organProperty);
        List<OrganUserTreeVo> organs = this.sysStruMapper.getOrganUserTreeOnlyOrgan(queryParams);
        if (HussarUtils.isEmpty(organs)) {
            return organs;
        }
        if (!resultType.equals(PermitConstants.TREE_TYPE_ORGAN)) {
            List<Long> oneOrganIds = organs.stream().map(s -> (Long)s.getId()).distinct().collect(Collectors.toList());
            Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(oneOrganIds);
            for (OrganUserTreeVo treeVo : organs) {
                int count = organIdUserCount.get((long)((Long)treeVo.getId()));
                treeVo.setUserCount(Integer.valueOf(count));
                if (resultType.equals(PermitConstants.TREE_TYPE_USER)) {
                    treeVo.setHasChildren(Boolean.valueOf(count > 0));
                    continue;
                }
                if (!resultType.equals(PermitConstants.TREE_TYPE_ORGAN_USER)) continue;
                treeVo.setHasChildren(Boolean.valueOf(treeVo.getHasChildren() != false || count > 0));
            }
        }
        return organs;
    }

    private OrganUserTreeVo initRootTree(String organName, Long parentId) {
        OrganUserTreeVo internalOrganUserTreeVo = new OrganUserTreeVo();
        internalOrganUserTreeVo.setLabel(organName);
        internalOrganUserTreeVo.setId((Serializable)parentId);
        internalOrganUserTreeVo.setTypes("organ");
        return internalOrganUserTreeVo;
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        boolean flag;
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean bl = flag = HussarUtils.isNotEmpty((Object)keyList) || HussarUtils.isNotEmpty((Object)casKeyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (flag) {
                    Optional<String> optional;
                    if (HussarUtils.isNotEmpty((Object)keyList)) {
                        optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                        ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                            String tmpkey = (String)optional.get();
                            UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                            if (null != model && model.getLockTime() != null) {
                                vo.setAccountStatus(UserStatus.LOCKED.getCode());
                            }
                        });
                    } else if (HussarUtils.isNotEmpty((Object)casKeyList)) {
                        optional = casKeyList.parallelStream().filter(item -> item.contains(String.valueOf(vo.getId()))).findAny();
                        ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                            String tmpkey = (String)optional.get();
                            UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)tmpkey)), UserLockModel.class);
                            if (null != model && model.getLockTime() != null) {
                                vo.setAccountStatus(UserStatus.LOCKED.getCode());
                            }
                        });
                    }
                }
                vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)vo.getExpiredTime()));
            }
        }
    }

    public UserStaffVo getUserAndStaffInfo(Long userId) {
        UserStaffVo vo = (UserStaffVo)HussarCacheUtil.get((String)"low_code_user_info", (Object)userId);
        if (HussarUtils.isEmpty((Object)vo) && HussarUtils.isNotEmpty((Object)(vo = this.sysUsersMapper.getUserAndStaffInfo(userId)))) {
            List<UserOrganPostVo> organs = this.sysStruUserMapper.getOrganByUserId(userId);
            List<UserOrganPostVo> posts = this.sysUserPostMapper.getPostByUserId(userId);
            vo.setOrgans(organs);
            vo.setPosts(posts);
            HussarCacheUtil.put((String)"low_code_user_info", (Object)userId, (Object)vo, (long)180L);
        }
        return vo;
    }

    public Page<SearchUserVo> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put(USER_ACCOUNT, StringUtils.trimToEmpty((String)userAccount));
        queryParams.put(USER_NAME, StringUtils.trimToEmpty((String)userName));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUserList((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    public Page<SearchUserVo> searchUsersAllowPinyin(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String struPath;
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.equals((Object)innerOrganNodeId, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)outOrganNodeId, (Object)queryUserDto.getDepStruId())) {
            String organproperty;
            String organProperty = HussarUtils.equals((Object)innerOrganNodeId, (Object)queryUserDto.getDepStruId()) ? "0" : "1";
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId(), currentUser);
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            StruVO stru = this.sysStruMapper.getStruByStruId(parentId);
            if (stru != null && !HussarUtils.equals((Object)organProperty, (Object)(organproperty = this.sysStruMapper.getOrganPropertyByOrganId(stru.getOrganId())))) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (HussarUtils.isNotEmpty((Object)currentUser) && currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        String containSys = StringUtils.trimToEmpty((String)queryUserDto.getContainSys());
        if (Objects.equals(innerOrganNodeId, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(outOrganNodeId, depStruId.get())) {
            struPath = "1";
            containSys = "0";
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struPath = struTemp.getStruFid();
            containSys = "0";
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.isEmpty((Object)casKeyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                for (String cacheKey : keyList) {
                    String tmpKey = cacheKey;
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)casKeyList)) {
                for (String cacheKey : casKeyList) {
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                    if (!HussarUtils.isNotEmpty((Object)model)) continue;
                    lockUserIds.add(Long.parseLong(model.getUserId()));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put(USER_ACCOUNT, SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put(ACCOUNT_STATUS, StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put(ACCOUNT_PROPERTY, StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put(STU_PATH, StringUtils.trimToEmpty((String)struPath));
        String userName = SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName());
        if (HussarUtils.isNotEmpty((Object)userName)) {
            boolean isAllLetter = ALL_LETTER.matcher(userName).matches();
            String userNameLowerCase = null;
            if (isAllLetter) {
                userNameLowerCase = userName.toLowerCase();
                queryParams.put(USER_NAME_LOWER_CASE, userNameLowerCase);
            }
        }
        if (this.struSafetyConfigService.isDisplayOnlyCurrentStruInfo().booleanValue()) {
            queryParams.put("isCurrentStruUser", true);
            queryParams.put("struId", queryUserDto.getDepStruId());
        }
        ArrayList filterUserIds = new ArrayList();
        SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
        LOGGER.info("\u67e5\u8be2\u7528\u6237\u6570\u636e\u8fc7\u6ee4\u7cfb\u7edf\u89d2\u8272\uff0c\u5f53\u524d\u5206\u4fdd\u72b6\u6001\uff1a{}", (Object)protectStatus.getConfigValue());
        if (null != protectStatus && "3".equals(protectStatus.getConfigValue()) && HussarUtils.isNotEmpty((Object)this.sysTenantMultUserService)) {
            List threeSeniorAdmins = Arrays.stream(THREE_SENIOR_ADMINS).collect(Collectors.toList());
            filterUserIds.addAll(threeSeniorAdmins);
            ArrayList<String> userTypeList = new ArrayList<String>();
            userTypeList.add(GRADE_SYSTEMADMIN_TYPE);
            userTypeList.add(GRADE_SECAUDITADMIN_TYPE);
            userTypeList.add(GRADE_SECURITYADMIN_TYPE);
            queryParams.put("userTypeList", userTypeList);
            List splitListLt = LambdaQueryUtil.getSplitListLt(filterUserIds, (int)SPLIT_LT);
            queryParams.put("filterUserIds", splitListLt);
        }
        List<SearchUserVo> userInfoList = null;
        if ("1".equals(containSys)) {
            userInfoList = this.sysUsersMapper.searchUserAllAllowPinyin((Page<SearchUserVo>)page, queryParams);
        } else if ("0".equals(containSys)) {
            userInfoList = this.sysUsersMapper.searchUserIsNotSysAllowPinyin((Page<SearchUserVo>)page, queryParams);
        }
        if (userInfoList != null && userInfoList.size() > 0) {
            this.fillOrganInfos(userInfoList);
            this.wrapUsers(userInfoList);
            this.fillUserSignInfos(userInfoList);
        }
        page.setRecords(TransUtil.trans(userInfoList));
        return page;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page<SearchUserTreeVo> searchUserAllowPinyin(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        void var9_17;
        List userIdList;
        List<Long> struIdList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        if ("0".equals(resultType)) {
            List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            List list = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
            queryUserParams.put(USER_IDS, list);
        } else if ("1".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            List list = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)list)) return page;
            userIdList = list.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            queryUserParams.put(USER_IDS, userIdList);
        } else if ("3".equals(resultType)) {
            List list;
            struIdList = this.getSubOrganByIds(organIds);
            if (HussarUtils.isNotEmpty(struIdList) && HussarUtils.isNotEmpty((Object)(list = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))))) {
                userIdList = list.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                userIds.addAll(userIdList);
                userIds = userIds.stream().distinct().collect(Collectors.toList());
            }
            queryUserParams.put(USER_IDS, userIds);
        }
        queryUserParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        String userName = SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName());
        if (HussarUtils.isNotEmpty((Object)userName)) {
            boolean bl = ALL_LETTER.matcher(userName).matches();
            String userNameLowerCase = null;
            if (bl) {
                userNameLowerCase = userName.toLowerCase();
                queryUserParams.put(USER_NAME_LOWER_CASE, userNameLowerCase);
            }
        }
        queryUserParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        ArrayList arrayList = new ArrayList();
        if ("2".equals(resultType)) {
            List<SearchUserTreeVo> list = this.sysUsersMapper.searchUserTreeVoWithStruAllowPinyin((Page<SearchUserTreeVo>)page, queryUserParams);
        } else {
            List<SearchUserTreeVo> list = this.sysUsersMapper.searchUserTreeVoAllowPinyin((Page<SearchUserTreeVo>)page, queryUserParams);
        }
        if (HussarUtils.isEmpty((Object)var9_17)) {
            return page;
        }
        this.wrapSearchUsers((List<SearchUserTreeVo>)var9_17);
        page.setRecords((List)var9_17);
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page<SearchUserTreeVo> searchUserWithUserDept(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        List userIdList;
        List struUsers;
        List<Long> struIdList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        if ("0".equals(resultType)) {
            List struUsers2 = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers2)) return page;
            List userIdList2 = struUsers2.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
            queryUserParams.put(USER_IDS, userIdList2);
        } else if ("1".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            userIdList = struUsers.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            queryUserParams.put(USER_IDS, userIdList);
        } else if ("3".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            if (HussarUtils.isNotEmpty(struIdList) && HussarUtils.isNotEmpty((Object)(struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))))) {
                userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                userIds.addAll(userIdList);
                userIds = userIds.stream().distinct().collect(Collectors.toList());
            }
            queryUserParams.put(USER_IDS, userIds);
        }
        queryUserParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        String userName = SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName());
        if (HussarUtils.isNotEmpty((Object)userName)) {
            boolean isAllLetter = ALL_LETTER.matcher(userName).matches();
            String userNameLowerCase = null;
            if (isAllLetter) {
                userNameLowerCase = userName.toLowerCase();
                queryUserParams.put(USER_NAME_LOWER_CASE, userNameLowerCase);
            }
        }
        queryUserParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        Long deptId = currentUser.getDeptId();
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo struFilteredVo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            Set fileredStruIds = struFilteredVo.getFilteredStruIds();
            queryUserParams.put(FILTER_STRU_IDS, fileredStruIds);
        }
        ArrayList arrayList = new ArrayList();
        List<SearchUserTreeVo> list = this.sysUsersMapper.searchUserTreeVoWithWithUserDept((Page<SearchUserTreeVo>)page, queryUserParams);
        if (HussarUtils.isEmpty(list)) {
            return page;
        }
        this.wrapSearchUsers(list);
        page.setRecords(list);
        return page;
    }

    public List<OrganUserTreeVo> lazyOrganUserTreeWithUserDept(UserOrganFeignDto userOrganFeignDto) {
        Long inOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        ArrayList<Long> parentOrganIds = userOrganFeignDto.getParentOrganIds();
        Boolean needParentOrganInfo = userOrganFeignDto.getNeedParentOrganInfo();
        Integer resultType = userOrganFeignDto.getResultType();
        List<Object> organUserTreeVos = new ArrayList<OrganUserTreeVo>();
        if (HussarUtils.isEmpty((Object)parentOrganIds)) {
            return organUserTreeVos;
        }
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        Long deptId = currentUser.getDeptId();
        Set fileredStruIds = new HashSet();
        Long rootId = this.sysStruMapper.getStruRootId(deptId);
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo filteredStruInfo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            fileredStruIds = filteredStruInfo.getFilteredStruIds();
            SysStru closestUnitStru = filteredStruInfo.getClosestUnitStru();
            if (parentOrganIds.contains(rootId)) {
                parentOrganIds = new ArrayList<Long>();
                parentOrganIds.add(closestUnitStru.getParentId());
            }
        }
        List<Long> organIds = this.getParentOrganIds((List<Long>)parentOrganIds);
        for (Long organId : organIds) {
            SysOrgan sysOrgan;
            if (organId.equals(inOrganNodeId)) {
                sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "0", this.sysStruMapper.getOrganFname(inOrganNodeId));
                continue;
            }
            if (organId.equals(outOrganNodeId)) {
                sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "1", this.sysStruMapper.getOrganFname(outOrganNodeId));
                continue;
            }
            this.getOrganUserTree(needParentOrganInfo, organUserTreeVos, organId, resultType);
        }
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            Set finalFileredStruIds = fileredStruIds;
            organUserTreeVos = organUserTreeVos.stream().filter(organPostTreeVo -> {
                if (organPostTreeVo.getTypes().equals("organ")) {
                    return finalFileredStruIds.contains(organPostTreeVo.getId());
                }
                return finalFileredStruIds.contains(organPostTreeVo.getParentId());
            }).collect(Collectors.toList());
            organUserTreeVos.forEach(organPostTreeVo -> {
                if (!(finalFileredStruIds.contains(organPostTreeVo.getParentId()) || inOrganNodeId.equals(organPostTreeVo.getId()) || outOrganNodeId.equals(organPostTreeVo.getId()))) {
                    organPostTreeVo.setParentId((Serializable)rootId);
                }
            });
        }
        return HussarTreeParser.getTreeList(organUserTreeVos);
    }

    private void fillUserSignInfos(List<SearchUserVo> searchUserVoList) {
        if (HussarUtils.isEmpty(searchUserVoList)) {
            return;
        }
        List userIdList = searchUserVoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List userSignVoList = this.userAttachmentService.listUserSignByUserIds(userIdList);
        if (HussarUtils.isEmpty((Object)userSignVoList)) {
            return;
        }
        ArrayListMultimap userSignMap = ArrayListMultimap.create();
        for (SysUserAttachmentVo sysUserAttachmentVo : userSignVoList) {
            userSignMap.put((Object)sysUserAttachmentVo.getUserId(), (Object)sysUserAttachmentVo);
        }
        for (SearchUserVo vo : searchUserVoList) {
            List signInfoList = userSignMap.get((Object)vo.getId());
            if (HussarUtils.isEmpty((Object)signInfoList)) continue;
            if (signInfoList.size() > 1) {
                LOGGER.info("\u5f53\u524d\u7528\u6237\u5b58\u5728\u591a\u4e2a\u7b7e\u540d,\u907f\u514d\u524d\u7aef\u5f02\u5e38\uff0c\u53d6\u7b2c\u4e00\u4e2a===>{}", (Object)vo.getId());
            }
            SysUserAttachmentVo userAttachmentVo = (SysUserAttachmentVo)signInfoList.get(0);
            vo.setFileType(userAttachmentVo.getFileType());
            vo.setBusiType(userAttachmentVo.getBusiType());
            vo.setUserSignImgBase64(userAttachmentVo.getImgBase64());
            vo.setUserSignFileId(userAttachmentVo.getFileId());
        }
    }

    public List<SysStru> getChildStruByFids(List<String> currentFIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        for (String fid : currentFIds) {
            ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
        }
        return this.sysStruMapper.selectList((Wrapper)wrapper);
    }

    public List<SysStruUser> getStruUsersBystruIds(List<Long> currentStruIds) {
        return this.sysStruUserMapper.getStruUserByStruIds(currentStruIds);
    }

    public List<SysStruUser> getStruUserByStruIdsWithSec(List<Long> currentStruIds, Integer securityLevel) {
        return this.sysStruUserMapper.getStruUserByStruIdsWithSec(currentStruIds, securityLevel);
    }
}

