/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResAndModDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseChangeFunctionService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseChangeFunctionServiceImpl")
public class HussarBaseChangeFunctionServiceImpl
implements IHussarBaseChangeFunctionService {
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    @Lazy
    private ISysResManageService sysResManageService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;

    @HussarDs(value="#connName")
    public void updateFunction(String connName, FuncInfoDto funcInfoDto) {
        Long functionId = funcInfoDto.getFunctionId();
        SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        if (ToolUtil.isNotEmpty((Object)functions)) {
            functions.setFunctionName(funcInfoDto.getFunctionName());
            functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
            this.sysResManageService.functionSave(connName, functions);
            this.sysFunctionResourcesService.saveFunctionRes(connName, functionId, funcInfoDto.getResources());
        }
    }

    @HussarDs(value="#connName")
    public void updateFunctionIncrement(String connName, FuncResAndModDto funcResAndModDto, Set<Long> addResIdSet, Set<Long> delResIdSet) {
        Long functionId = funcResAndModDto.getFunctionId();
        SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        if (ToolUtil.isNotEmpty((Object)functions)) {
            functions.setFunctionName(funcResAndModDto.getFunctionName());
            functions.setDefaultResourceId(funcResAndModDto.getDefaultResourceId());
            this.sysResManageService.functionSave(connName, functions);
            this.sysFunctionResourcesService.saveFunctionResIncrement(connName, functions.getId(), addResIdSet, delResIdSet);
        }
    }
}

