/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleUserRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppVisitDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryFunctionManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.vo.AppFuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppMenuFuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppVisitVo;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryFunctionManagerImpl")
public class QueryFunctionManagerImpl
implements QueryFunctionManager {
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysRoleDataRightMapper sysRoleDataRightMapper;
    @Resource
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Resource
    private SysRoleUserRightsMapper sysRoleUserRightsMapper;
    private static final String APP_ID = "appId";
    private static final String ROLE_ID = "roleId";
    private static final String ROLE_IDS = "roleIds";
    private static final String RES_TYPE_ID = "resTypeId";
    private static final String FUNCTION_CODE = "functionCode";

    @Override
    public AppMenuFuncResVo getAppMenuFuncResInfo(Long appId) {
        AppMenuFuncResVo result = new AppMenuFuncResVo();
        ArrayList<SysMenu> menus = new ArrayList<SysMenu>();
        SysMenu menu = (SysMenu)this.sysMenuMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getId, (Object)appId)).eq(SysMenu::getParentId, (Object)4));
        if (HussarUtils.isNotEmpty((Object)menu)) {
            menus.add(menu);
        }
        if (HussarUtils.isNotEmpty((Object)menu)) {
            List twoMenus = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getParentId, (Object)appId));
            menus.addAll(twoMenus);
            if (HussarUtils.isNotEmpty((Object)twoMenus)) {
                List parentIds = twoMenus.stream().map(SysMenu::getId).distinct().collect(Collectors.toList());
                List threeMenus = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysMenu::getParentId, parentIds));
                menus.addAll(threeMenus);
            }
        }
        result.setMenus(menus);
        List functionModules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        result.setFuncModules(functionModules);
        List functions = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getAppId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        result.setFunctions(functions);
        List resourceModules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getAppId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        result.setResModules(resourceModules);
        List resources = this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getAppId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        result.setResources(resources);
        if (HussarUtils.isNotEmpty((Object)functions) && HussarUtils.isNotEmpty((Object)resources)) {
            List functionIds = functions.stream().map(SysFunctions::getId).distinct().collect(Collectors.toList());
            List resourceIds = resources.stream().map(SysResources::getId).distinct().collect(Collectors.toList());
            List relations = this.sysFunctionResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds)).in(SysFunctionResources::getResourceId, resourceIds));
            result.setFuncResRelations(relations);
        }
        return result;
    }

    @Override
    public List<AppVisitVo> getAppVisitInfoList(QueryAppVisitDto queryAppVisitDto) {
        ArrayList<AppVisitVo> result = new ArrayList<AppVisitVo>();
        List roleIds = queryAppVisitDto.getRoleIds();
        Long appId = queryAppVisitDto.getAppId();
        String visitType = queryAppVisitDto.getVisitType();
        if (HussarUtils.isEmpty((Object)roleIds)) {
            return result;
        }
        if ("1".equals(visitType)) {
            this.getAppVisitInfo(appId, roleIds, "menu_", "res_menu", "1", result);
        }
        if ("2".equals(visitType)) {
            this.getAppVisitInfo(appId, roleIds, "element_", "res_element", "2", result);
        }
        if ("3".equals(visitType)) {
            this.getAppVisitDataRightInfo(appId, roleIds, result);
        }
        if (HussarUtils.isBlank((CharSequence)visitType)) {
            this.getAllAppVisitInfo(appId, roleIds, result);
        }
        return result;
    }

    @Override
    public AppMenuFuncResVo getAppMenuFuncResByFormId(Long appId, Long formId) {
        AppMenuFuncResVo result = new AppMenuFuncResVo();
        ArrayList<SysMenu> menus = new ArrayList<SysMenu>();
        SysMenu menu = (SysMenu)this.sysMenuMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getId, (Object)formId)).eq(SysMenu::getIsLeaf, (Object)"1"));
        menus.add(menu);
        result.setMenus(menus);
        List functions = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getAppId, (Object)appId)).eq(SysFunctions::getFunctionModuleId, (Object)formId));
        result.setFunctions(functions);
        List resources = this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getAppId, (Object)appId)).eq(SysResources::getModuleId, (Object)formId));
        result.setResources(resources);
        if (HussarUtils.isNotEmpty((Object)functions) && HussarUtils.isNotEmpty((Object)resources)) {
            List functionIds = functions.stream().map(SysFunctions::getId).distinct().collect(Collectors.toList());
            List resourceIds = resources.stream().map(SysResources::getId).distinct().collect(Collectors.toList());
            List relations = this.sysFunctionResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds)).in(SysFunctionResources::getResourceId, resourceIds));
            result.setFuncResRelations(relations);
        }
        return result;
    }

    @Override
    public List<Long> getAuthorityFormList(List<Long> roleIds, Long appId) {
        if (HussarUtils.isEmpty(roleIds)) {
            return this.sysFunctionsMapper.getModuleIdsByAppId(appId);
        }
        return this.sysFunctionsMapper.getAuthorityModuleIdsByAppId(roleIds, appId);
    }

    @Override
    public Map<Long, List<SysFunctions>> getFunctionsByResTypeId(Long appId, Long roleId, String resTypeId) {
        HashMap<Long, List<SysFunctions>> result = new HashMap<Long, List<SysFunctions>>();
        HashMap<String, Object> queryFuncParams = new HashMap<String, Object>();
        queryFuncParams.put(APP_ID, appId);
        queryFuncParams.put(ROLE_ID, roleId);
        queryFuncParams.put(RES_TYPE_ID, resTypeId);
        List<SysFunctions> functionsList = this.sysFunctionsMapper.getFunctionsByResTypeId(queryFuncParams);
        Map funcMap = functionsList.stream().collect(Collectors.toMap(SysFunctions::getId, Function.identity()));
        List<AppFuncResVo> list = this.sysFunctionResourcesMapper.getAppFuncResInfoList(queryFuncParams);
        Map<Long, List<AppFuncResVo>> map = list.stream().collect(Collectors.groupingBy(AppFuncResVo::getFormId));
        for (Map.Entry<Long, List<AppFuncResVo>> entry : map.entrySet()) {
            Long formId = entry.getKey();
            List<AppFuncResVo> voList = entry.getValue();
            List funcIds = voList.stream().map(AppFuncResVo::getFunctionId).distinct().collect(Collectors.toList());
            ArrayList funcList = new ArrayList();
            for (Long funcId : funcIds) {
                if (!funcMap.containsKey(funcId)) continue;
                funcList.add(funcMap.get(funcId));
            }
            result.put(formId, funcList);
        }
        return result;
    }

    private void getAllAppVisitInfo(Long appId, List<Long> roleIds, List<AppVisitVo> result) {
        List<SysRoleFunctions> roleFunctionList = this.getRoleFunctionsList(appId, roleIds, null);
        Map<Long, List<SysRoleFunctions>> funcMap = roleFunctionList.stream().collect(Collectors.groupingBy(SysRoleFunctions::getRoleId));
        List pargeFuncList = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getAppId, (Object)appId)).like(SysFunctions::getFunctionCode, (Object)"menu_"));
        List pageFuncIds = pargeFuncList.stream().map(SysFunctions::getId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(pageFuncIds)) {
            return;
        }
        List funcIds = roleFunctionList.stream().map(SysRoleFunctions::getFunctionId).filter(pageFuncIds::contains).collect(Collectors.toList());
        if (HussarUtils.isEmpty(funcIds)) {
            return;
        }
        List<SysRoleResource> roleResourceList = this.getRoleResourcesList(appId, roleIds, null);
        Map<Long, List<SysRoleResource>> resMap = roleResourceList.stream().collect(Collectors.groupingBy(SysRoleResource::getRoleId));
        List roleDataRights = this.sysRoleDataRightMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleDataRight::getRoleId, roleIds)).in(SysRoleDataRight::getFunctionId, funcIds)).eq(SysRoleDataRight::getResTypeCode, (Object)"res_form_rights"));
        Map<Long, List<SysRoleDataRight>> roleDataRightMap = roleDataRights.stream().collect(Collectors.groupingBy(SysRoleDataRight::getRoleId));
        List dataRightIds = roleDataRights.stream().map(SysRoleDataRight::getDataRightsId).distinct().collect(Collectors.toList());
        Map<Object, Object> roleStruRightMap = new HashMap();
        Map<Object, Object> roleUserRightMap = new HashMap();
        if (HussarUtils.isNotEmpty(dataRightIds)) {
            List roleStruRights = this.sysRoleStruRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleDataRightsId, dataRightIds));
            roleStruRightMap = roleStruRights.stream().collect(Collectors.groupingBy(SysRoleStruRights::getRoleId));
            List roleUserRights = this.sysRoleUserRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleUserRights::getRoleDataRightsId, dataRightIds));
            roleUserRightMap = roleUserRights.stream().collect(Collectors.groupingBy(SysRoleUserRights::getRoleId));
        }
        for (Long roleId : roleIds) {
            AppVisitVo appVisitVo = new AppVisitVo();
            if (HussarUtils.isNotEmpty(funcMap.get(roleId))) {
                List<SysRoleFunctions> roleFunctions = funcMap.get(roleId);
                appVisitVo.setRoleFunctions(roleFunctions);
            }
            if (HussarUtils.isNotEmpty(resMap.get(roleId))) {
                List<SysRoleResource> roleResources = resMap.get(roleId);
                appVisitVo.setRoleResources(roleResources);
            }
            if (HussarUtils.isNotEmpty(roleDataRightMap.get(roleId))) {
                List<SysRoleDataRight> roleDataRight = roleDataRightMap.get(roleId);
                appVisitVo.setRoleDataRights(roleDataRight);
            }
            if (HussarUtils.isNotEmpty((Object)roleStruRightMap.get(roleId))) {
                List roleStruRight = (List)roleStruRightMap.get(roleId);
                appVisitVo.setRoleStruRights(roleStruRight);
            }
            if (HussarUtils.isNotEmpty(roleUserRightMap.get(roleId))) {
                List roleUserRight = (List)roleUserRightMap.get(roleId);
                appVisitVo.setRoleUserRights(roleUserRight);
            }
            appVisitVo.setRoleId(roleId);
            result.add(appVisitVo);
        }
    }

    private void getAppVisitDataRightInfo(Long appId, List<Long> roleIds, List<AppVisitVo> result) {
        List<SysRoleFunctions> roleFunctionList = this.getRoleFunctionsList(appId, roleIds, "menu_");
        List funcIds = roleFunctionList.stream().map(SysRoleFunctions::getFunctionId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(funcIds)) {
            return;
        }
        List<SysRoleResource> roleResourceList = this.getRoleResourcesList(appId, roleIds, "res_form_rights");
        Map<Long, List<SysRoleResource>> resMap = roleResourceList.stream().collect(Collectors.groupingBy(SysRoleResource::getRoleId));
        List roleDataRights = this.sysRoleDataRightMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleDataRight::getRoleId, roleIds)).in(SysRoleDataRight::getFunctionId, funcIds)).eq(SysRoleDataRight::getResTypeCode, (Object)"res_form_rights"));
        Map<Long, List<SysRoleDataRight>> roleDataRightMap = roleDataRights.stream().collect(Collectors.groupingBy(SysRoleDataRight::getRoleId));
        Map<Object, Object> roleStruRightMap = new HashMap();
        Map<Object, Object> roleUserRightMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)roleDataRights)) {
            List dataRightIds = roleDataRights.stream().map(SysRoleDataRight::getDataRightsId).distinct().collect(Collectors.toList());
            List roleStruRights = this.sysRoleStruRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleDataRightsId, dataRightIds));
            roleStruRightMap = roleStruRights.stream().collect(Collectors.groupingBy(SysRoleStruRights::getRoleId));
            List roleUserRights = this.sysRoleUserRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleUserRights::getRoleDataRightsId, dataRightIds));
            roleUserRightMap = roleUserRights.stream().collect(Collectors.groupingBy(SysRoleUserRights::getRoleId));
        }
        for (Long roleId : roleIds) {
            AppVisitVo appVisitVo = new AppVisitVo();
            if (HussarUtils.isNotEmpty(resMap)) {
                List<SysRoleResource> roleResources = resMap.get(roleId);
                appVisitVo.setRoleResources(roleResources);
            }
            if (HussarUtils.isNotEmpty(roleDataRightMap)) {
                List<SysRoleDataRight> roleDataRight = roleDataRightMap.get(roleId);
                appVisitVo.setRoleDataRights(roleDataRight);
            }
            if (HussarUtils.isNotEmpty(roleStruRightMap.get(roleId))) {
                List roleStruRight = (List)roleStruRightMap.get(roleId);
                appVisitVo.setRoleStruRights(roleStruRight);
            }
            if (HussarUtils.isNotEmpty(roleUserRightMap.get(roleId))) {
                List roleUserRight = (List)roleUserRightMap.get(roleId);
                appVisitVo.setRoleUserRights(roleUserRight);
            }
            appVisitVo.setRoleId(roleId);
            appVisitVo.setVisitType("3");
            result.add(appVisitVo);
        }
    }

    private void getAppVisitInfo(Long appId, List<Long> roleIds, String prefix, String resTypeId, String visitType, List<AppVisitVo> result) {
        List<SysRoleFunctions> roleFunctionList = this.getRoleFunctionsList(appId, roleIds, prefix);
        Map<Long, List<SysRoleFunctions>> funcMap = roleFunctionList.stream().collect(Collectors.groupingBy(SysRoleFunctions::getRoleId));
        List<SysRoleResource> roleResourceList = this.getRoleResourcesList(appId, roleIds, resTypeId);
        Map<Long, List<SysRoleResource>> resMap = roleResourceList.stream().collect(Collectors.groupingBy(SysRoleResource::getRoleId));
        for (Long roleId : roleIds) {
            AppVisitVo appVisitVo = new AppVisitVo();
            if (HussarUtils.isNotEmpty(funcMap.get(roleId))) {
                List<SysRoleFunctions> roleFunctions = funcMap.get(roleId);
                appVisitVo.setRoleFunctions(roleFunctions);
            }
            if (HussarUtils.isNotEmpty(resMap.get(roleId))) {
                List<SysRoleResource> roleResources = resMap.get(roleId);
                appVisitVo.setRoleResources(roleResources);
            }
            appVisitVo.setRoleId(roleId);
            appVisitVo.setVisitType(visitType);
            result.add(appVisitVo);
        }
    }

    private List<SysRoleResource> getRoleResourcesList(Long appId, List<Long> roleIds, String resTypeId) {
        HashMap<String, Object> queryResParams = new HashMap<String, Object>();
        queryResParams.put(APP_ID, appId);
        queryResParams.put(ROLE_IDS, roleIds);
        queryResParams.put(RES_TYPE_ID, resTypeId);
        return this.sysRoleResourceMapper.getAppRoleResInfo(queryResParams);
    }

    private List<SysRoleFunctions> getRoleFunctionsList(Long appId, List<Long> roleIds, String prefix) {
        HashMap<String, Object> queryFuncParams = new HashMap<String, Object>();
        queryFuncParams.put(APP_ID, appId);
        queryFuncParams.put(ROLE_IDS, roleIds);
        queryFuncParams.put(FUNCTION_CODE, prefix);
        return this.sysRoleFunctionsMapper.getAppRoleFuncInfo(queryFuncParams);
    }

    @Override
    public List<SysFunctions> getFunctionListByFuncCode(List<String> functionCodes) {
        if (HussarUtils.isEmpty(functionCodes)) {
            return new ArrayList<SysFunctions>();
        }
        LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysFunctions::getFunctionCode, functionCodes);
        queryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysFunctionsMapper.selectList((Wrapper)queryWrapper);
    }
}

