/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.deleteUserManagerImpl")
public class DeleteUserManagerImpl
implements DeleteUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteUserManagerImpl.class);
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysAuditConfigService sysAuditConfig;
    @Autowired
    private ISysUserIpService sysUserIpService;
    @Autowired
    private ISysUsersAuditService sysUsersAuditService;
    @Autowired
    private ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruUserAuditService sysStruUserAuditService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysUserPostAuditService sysUserPostAuditService;
    @Resource
    private UserChangeNotify userChangeNotify;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;

    @Override
    @HussarTransactional
    public String deleteUser(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_THIS_USER.getMessage()), (Object)id);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = (SysUsers)this.sysUsersMapper.selectById(id);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
        }
        AssertUtil.isFalse((boolean)shiroUser.getId().equals(id), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("2");
            LocalDateTime now = LocalDateTime.now();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            sysUsersAudit.setCreateTime(now);
            sysUsersAudit.setLastTime(now);
            sysUsersAudit.setCreator(securityUser.getId());
            sysUsersAudit.setLastEditor(securityUser.getId());
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        sysUser.setAccountStatus(UserStatus.DELETE.getCode());
        this.sysUsersMapper.updateById(sysUser);
        this.sysStruMapper.updatePrincipal(sysUser.getId());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUser.getId()));
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)id));
        this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getUserId, (Object)id));
        this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)id));
        this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)id));
        this.userChangeNotify.notify(DataChangeType.DELETE, new Object[]{sysUser});
        this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(id)});
        UserLogoutCacheUtil.kickOutUser((Long)sysUser.getId());
        HussarCacheUtil.evictKeysLike((String)"low_code_user_info", (String)"*");
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage());
    }
}

