/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.manager.ApprovedAuditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserAuditManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approvedAuditUserManagerImpl")
public class ApprovedAuditUserManagerImpl
extends CommonUserAuditManager
implements ApprovedAuditUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovedAuditUserManagerImpl.class);
    @Autowired
    private ISysStruUserAuditService sysStruUserAuditService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private ISysStruUserService sysStruUserService;

    @Override
    @HussarTransactional
    public String approved(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_AUDIT_PASS.getMessage()), (Object)id);
        SysUsersAudit usersAudit = this.getSysUsersAudit(id);
        String currentStatus = usersAudit.getCurrentStatus();
        String result = null;
        if (currentStatus.equals("0")) {
            result = this.doAuditAdd(usersAudit);
        } else if (currentStatus.equals("1")) {
            result = this.doAuditEdit(usersAudit);
        } else if (currentStatus.equals("2")) {
            result = this.doAuditDelete(usersAudit);
        } else if (currentStatus.equals("4")) {
            result = this.doAuditCancel(usersAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        return result;
    }

    private String doAuditAdd(SysUsersAudit sysUsersAudit) {
        String secure = sysUsersAudit.getPassword();
        boolean existAccount = this.sysUsersService.isExistAccount(sysUsersAudit.getUserAccount());
        AssertUtil.isFalse((boolean)existAccount, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        sysUsers.setPassword(pwd);
        this.sysUsersService.save((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        String ips = this.queryAuditIp(sysUsersAudit.getUserId(), "0");
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
        this.sysUserIpAuditService.remove((Wrapper)wrapper);
        LambdaQueryWrapper userroleAuditLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userroleAuditLambdaQueryWrapper.eq(SysUserroleAudit::getUserId, (Object)sysUsersAudit.getUserId())).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.UserAuditButRoleNotAudit.getCode());
        List sysUserroleAudits = this.sysUserroleAuditMapper.selectList((Wrapper)userroleAuditLambdaQueryWrapper);
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        for (SysUserroleAudit sysUserroleAudit : sysUserroleAudits) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUserroleAudit.getUserId());
            sysUserRole.setGrantedRole(sysUserroleAudit.getRoleId());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            userRoleList.add(sysUserRole);
        }
        this.userRoleService.saveBatch(userRoleList);
        this.sysUserroleAuditMapper.delete((Wrapper)userroleAuditLambdaQueryWrapper);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }

    private String doAuditEdit(SysUsersAudit sysUsersAudit) {
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        sysUsersAudit.setIsAudit("1");
        String ips = this.queryAuditIp(sysUsersAudit.getUserId(), "1");
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
        this.sysUserIpAuditService.remove((Wrapper)wrapper);
        SysUsers old = this.sysUsersService.getById(sysUsers.getId());
        sysUsers.setUserOrder(old.getUserOrder());
        if (!"1".equals(old.getAccountStatus()) && "1".equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
        }
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }

    private String doAuditDelete(SysUsersAudit sysUsersAudit) {
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        Long userId = sysUsersAudit.getUserId();
        sysUsers.setId(userId);
        sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(userId));
        this.sysStruMapper.updatePrincipal(sysUsers.getId());
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getUserId, (Object)userId));
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)userId));
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
        this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }

    private String doAuditCancel(SysUsersAudit sysUsersAudit) {
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(Long.valueOf(sysUsersAudit.getUserId()));
        sysUsers.setAccountStatus(UserStatus.CANCEL.getCode());
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsersAudit.getUserId()));
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)sysUsers.getId()));
        this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getUserId, (Object)sysUsers.getId()));
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }
}

