/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.AddStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryAssistPostDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferStaffDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleStaffVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffListVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.expansion.core.annotations.ExpansionModelId;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u4eba\u5458\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.authorization.organ.controller.hussarBaseStaffController")
@RequestMapping(value={"/hussarBase/authorization/staff"})
@ExpansionModelId(modelId="staffExtendColumnInfo")
public class HussarBaseStaffController {
    @Autowired
    private IHussarBaseStaffService staffService;
    @Resource
    private IHussarBaseOrganizationService organizationService;

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", notes="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8")
    @CheckPermission(value={"hussarBase:authorization:staff:lazyLoadingStaffTree"})
    @GetMapping(value={"/lazyLoadingStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> lazyLoadingStaffTree(@ApiParam(value="\u4eba\u5458\u6240\u5728\u673a\u6784id") @RequestParam Long parentId) {
        return this.staffService.lazyLoadingStaffTree(parentId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868")
    @CheckPermission(value={"hussarBase:authorization:staff:staffList"})
    @GetMapping(value={"/staffList"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<StaffListVo>> staffList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u4eba\u5458dto") QueryStaffDto queryStaffDto) {
        return this.staffService.queryStaff(pageInfo, queryStaffDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811")
    @CheckPermission(value={"hussarBase:authorization:staff:getOrderStaffTree"})
    @GetMapping(value={"/getOrderStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> getOrderStaffTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.staffService.getOrderStaffTree(parentId);
    }

    @ApiOperation(value="\u9009\u62e9\u4eba\u5458", notes="\u9009\u62e9\u4eba\u5458")
    @GetMapping(value={"/selectStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u9009\u62e9\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> selectStaffTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.staffService.selectStaffTree(parentId);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u4eba\u5458\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u4eba\u5458\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:staff:backStaffTree"})
    @GetMapping(value={"/backStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> backStaffTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam(value="id") Long id) {
        return this.staffService.backStaffTree(id);
    }

    @ApiOperation(value="\u65b0\u589e\u4eba\u5458", notes="\u65b0\u589e\u4eba\u5458")
    @PostMapping(value={"/addStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:addStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u65b0\u589e\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addStaff(@ApiParam(value="\u65b0\u589e\u4eba\u5458DTO") @RequestBody AddStaffDto addStaffDto) {
        return this.staffService.addStaff(addStaffDto);
    }

    @ApiOperation(value="\u4fee\u6539\u4eba\u5458", notes="\u4fee\u6539\u4eba\u5458")
    @PostMapping(value={"/editStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:editStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fee\u6539\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckSafe
    public ApiResponse<String> editStaff(@ApiParam(value="\u4fee\u6539\u4eba\u5458DTO") @RequestBody EditStaffDto editStaffDto) {
        return this.staffService.editStaff(editStaffDto);
    }

    @ApiOperation(value="\u4eba\u5458\u4fe1\u606f\u67e5\u770b", notes="\u4eba\u5458\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"/viewStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:viewStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u4fe1\u606f\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<StaffPartialVo> viewStaff(@ApiParam(value="\u4eba\u5458ID") @RequestParam Long id) {
        return this.staffService.viewStaff(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/loadStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:loadStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<StaffInfoVo> loadStaff(@ApiParam(value="\u4eba\u5458ID") @RequestParam Long id) {
        return this.staffService.loadStaff(id);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u4eba\u5458", notes="\u6839\u636eID\u5220\u9664\u4eba\u5458")
    @CheckPermission(value={"hussarBase:authorization:staff:deleteStaff"})
    @PostMapping(value={"/deleteStaff"})
    @CheckSafe
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636eID\u5220\u9664\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteStaff(@ApiParam(value="\u4eba\u5458ID") @RequestBody Long id) {
        return this.staffService.deleteStaff(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", notes="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f")
    @PostMapping(value={"/sortStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:sortStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> sortStaff(@ApiParam(value="\u4eba\u5458id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.staffService.sortStaff(idList);
    }

    @ApiOperation(value="\u8f6c\u79fb\u4eba\u5458", notes="\u8f6c\u79fb\u4eba\u5458")
    @PostMapping(value={"/transferStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:transferStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u8f6c\u79fb\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> transferStaff(@ApiParam(value="\u7ec4\u7ec7\u8f6c\u79fbdto") @RequestBody TransferStaffDto transferStaffDto) {
        return this.staffService.transferStaff(transferStaffDto);
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868", notes="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868")
    @GetMapping(value={"/loadAssistPostByStaffId"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganizationVo>> loadAssistPostByStaffId(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u517c\u804c\u5c97\u4f4dDTO") QueryAssistPostDto queryAssistPostDto) {
        return this.staffService.loadAssistPostByStaffId(pageInfo, queryAssistPostDto);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u7528\u6237\u4eba\u5458", notes="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u7528\u6237\u4eba\u5458")
    @GetMapping(value={"/unRelateUserStaffList"})
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u9009\u62e9\u7ec4\u4ef6", eventDesc="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u7528\u6237\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SimpleStaffVo>> unRelateUserStaffList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long organId, @ApiParam(value="\u4eba\u5458\u540d\u5b57") @RequestParam String staffName, @ApiParam(value="\u7528\u6237id") @RequestParam(required=false) Long userId) {
        return this.staffService.unRelateUserStaffList(pageInfo, organId, staffName, userId);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868(\u8868\u683c)", notes="\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868(\u8868\u683c)")
    @GetMapping(value={"/list"})
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u9009\u62e9\u7ec4\u4ef6", eventDesc="\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:authorization:staff:list"})
    public ApiResponse<Page<StaffVo>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long organId, @ApiParam(value="\u4eba\u5458\u540d\u5b57") @RequestParam String staffName, @ApiParam(value="\u4eba\u5458\u7f16\u7801") @RequestParam String staffCode) {
        return this.staffService.list(pageInfo, organId, staffName, staffCode);
    }

    @ApiOperation(value="\u65b0\u589e\u4eba\u5458", notes="\u65b0\u589e\u4eba\u5458")
    @PostMapping(value={"/add"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u7ba1\u7406", eventDesc="\u65b0\u589e\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:authorization:staff:addStaff"})
    public ApiResponse<String> add(@ApiParam(value="\u4eba\u5458\u4fe1\u606f") @RequestBody StaffDto staffDto) {
        return this.staffService.add(staffDto);
    }

    @ApiOperation(value="\u4fee\u6539\u4eba\u5458", notes="\u4fee\u6539\u4eba\u5458")
    @PostMapping(value={"/edit"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fee\u6539\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:authorization:staff:editStaff"})
    public ApiResponse<String> edit(@ApiParam(value="\u4eba\u5458\u4fe1\u606f") @RequestBody StaffDto staffDto) {
        return this.staffService.edit(staffDto);
    }

    @ApiOperation(value="\u5220\u9664\u4eba\u5458", notes="\u5220\u9664\u4eba\u5458")
    @PostMapping(value={"/delete"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u7ba1\u7406", eventDesc="\u5220\u9664\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"hussarBase:authorization:staff:deleteStaff"})
    public ApiResponse<String> delete(@ApiParam(value="\u4eba\u5458id") @RequestBody Long staffId) {
        return this.staffService.delete(staffId);
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8be6\u60c5", notes="\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<StaffVo> detail(@ApiParam(value="\u4eba\u5458id") @RequestParam Long staffId) {
        return this.staffService.detail(staffId);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6570\u636e\u6743\u9650\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868", notes="\u7ec4\u7ec7\u6570\u636e\u6743\u9650\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/organDataAuthority"})
    @AuditLog(moduleName="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u7ec4\u7ec7\u6570\u636e\u6743\u9650", eventDesc="\u7ec4\u7ec7\u6570\u636e\u6743\u9650\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<StaffVo>> organDataAuthorityStaff(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u4eba\u5458\u540d\u5b57") @RequestParam String staffName, @ApiParam(value="\u4eba\u5458\u7f16\u7801") @RequestParam String workId) {
        return this.staffService.organDataAuthorityStaff(pageInfo, staffName, workId);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811")
    @GetMapping(value={"/getOrderUnifyStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SimpleOrganVo> getOrderUnifyStaffTree(@ApiParam(value="\u5f53\u524d\u7ec4\u7ec7\u7ed3\u6784id") @RequestParam Long struId) {
        return this.staffService.getOrderUnifyStaffTree(struId);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", notes="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f")
    @PostMapping(value={"/sortUnifyStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:authorization:staff:sortUnifyStaff"})
    public ApiResponse<String> sortUnifyStaff(@ApiParam(value="\u4eba\u5458id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.staffService.sortUnifyStaff(idList);
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", notes="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811")
    @GetMapping(value={"/getStaffTreeInitVos"})
    @AuditLog(moduleName="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventDesc="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganTreeInitVo>> getStaffTreeInitVos(@RequestParam(value="parentId") Long parentId, @RequestParam(value="ifLazy") int ifLazy, @RequestParam(required=false, value="defaultLevel") Integer defaultLevel) {
        return ApiResponse.success((Object)this.staffService.getStaffTreeInitVos(parentId, ifLazy, defaultLevel));
    }

    @ApiOperation(value="\u83b7\u53d6\u5230\u4e0b\u5c5e\u4eba\u5458\u6570\u636e", notes="\u83b7\u53d6\u5230\u4e0b\u5c5e\u4eba\u5458\u6570\u636e")
    @GetMapping(value={"/getChildrenStaff"})
    @AuditLog(moduleName="\u83b7\u53d6\u5230\u4e0b\u5c5e\u4eba\u5458\u6570\u636e", eventDesc="\u83b7\u53d6\u5230\u4e0b\u5c5e\u4eba\u5458\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getChildrenStaff(@RequestParam(value="parentId") Long parentId) {
        return ApiResponse.success((Object)this.staffService.getChildrenStaffAndOrgan(parentId));
    }

    @ApiOperation(value="\u6309\u7167\u4eba\u5458\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", notes="\u6309\u7167\u4eba\u5458\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/getStaffsLikeName"})
    @AuditLog(moduleName="\u6309\u7167\u4eba\u5458\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventDesc="\u6309\u7167\u4eba\u5458\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getStaffsLikeName(@RequestParam(value="searchValue") String searchValue) {
        return ApiResponse.success((Object)this.staffService.getStaffsLikeName(searchValue));
    }

    @ApiOperation(value="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", notes="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811")
    @GetMapping(value={"/getUpStaffTreeByOrganId"})
    @AuditLog(moduleName="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventDesc="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUpStaffTreeByOrganId(@RequestParam(value="id") Long id, @RequestParam(value="parentId") Long parentId) {
        return ApiResponse.success((Object)this.staffService.getUpStaffTreeByOrganId(id, parentId));
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f", notes="\u6839\u636e\u4eba\u5458Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f")
    @GetMapping(value={"/getStaffInfoById"})
    @AuditLog(moduleName="\u6839\u636e\u4eba\u5458Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f", eventDesc="\u6839\u636e\u4eba\u5458Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<OrganTreeInitVo> getStaffInfoById(@RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.staffService.getStaffInfoById(id));
    }

    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u5230\u4e0b\u96c6\u4eba\u5458\u4fe1\u606f", notes="\u6839\u636e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u5230\u4e0b\u96c6\u4eba\u5458\u4fe1\u606f")
    @GetMapping(value={"/getStaffsByPatentId"})
    @AuditLog(moduleName="\u6839\u636e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u5230\u4e0b\u96c6\u4eba\u5458\u4fe1\u606f", eventDesc="\u6839\u636e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u5230\u4e0b\u96c6\u4eba\u5458\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getStaffsByParentId(@RequestParam(value="id") Long id) {
        return this.staffService.getStaffsByParentId(id);
    }
}

