/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.audit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAssistOrganAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.vo.SysStruAuditVo;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganInfoMapVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.StruAuditDto;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruAuditServiceImpl
extends HussarServiceImpl<SysStruAuditMapper, SysStruAudit>
implements ISysStruAuditService {
    @Resource
    SysStruAuditMapper sysStruAuditMapper;
    @Resource
    ISysOrganAuditService iSysOrganAuditService;
    @Resource
    ISysOfficeAuditService iSysOfficeAuditService;
    @Resource
    ISysStaffAuditService iSysStaffAuditService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysOrganService iSysOrganService;
    @Resource
    private ISysStaffService iSysStaffService;
    @Resource
    private ISysOfficeService iSysOfficeService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    SysStruAssistOrganAuditMapper sysStruAssistOrganAudit;
    @Resource
    ISysStruAssistOrganService sysStruAssistOrgan;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    @Lazy
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static final String SEX = "sex";

    public boolean checkCanOperate(Long struId) {
        SysStruAudit sysStruAudit = (SysStruAudit)super.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruAudit::getState, (Object)"0")).eq(SysStruAudit::getRealStruId, (Object)struId));
        return sysStruAudit == null;
    }

    @Deprecated
    public IPage<SysStruAuditVo> queryOrganAudit(Page<SysStruAuditVo> pages, StruAuditDto struAuditDto) {
        if (ToolUtil.isEmpty(pages)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        String organName = struAuditDto == null ? "" : struAuditDto.getOrganName();
        String type = struAuditDto == null ? "" : struAuditDto.getState();
        return pages.setRecords(this.sysStruAuditMapper.queryOrganAudit(pages, organName, type));
    }

    public OrganInfoVo getOrgInfoById(Long struId) {
        return this.sysStruAuditMapper.getOrgInfoById(struId);
    }

    public String getNewParentName(Long struId) {
        return this.sysStruAuditMapper.getNewParentName(struId);
    }

    @HussarTransactional
    public String verifyVue(SysStruAudit struAudit) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)struAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_STRU_AUDIT_NOT_NULL.getMessage()));
        }
        Long struId = struAudit.getId();
        String type = struAudit.getState();
        String inUse = struAudit.getInUse();
        Long realStruId = struAudit.getRealStruId();
        if ("2".equals(type)) {
            SysStruAudit sysStruAudit = new SysStruAudit();
            sysStruAudit.setId(struId);
            sysStruAudit.setState("2");
            this.sysStruAssistOrganAudit.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrganAudit::getStruId, (Object)realStruId));
            boolean flag2 = super.updateById((BaseEntity)sysStruAudit);
            if (!flag2) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_REJECT_FAIL.getMessage()));
            }
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.REJECT_SUCCESS.getMessage());
        }
        if ("3".equals(inUse) || "4".equals(inUse)) {
            SysStruAudit sysStruAudit = (SysStruAudit)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStruAudit::getId, (Object)struId), false);
            if (HussarUtils.isEmpty((Object)sysStruAudit)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_FAIL.getMessage()));
            }
            SysStru sysStru = new SysStru();
            CopyPropertieUtils.copyProperties((Object)sysStru, (Object)sysStruAudit);
            sysStru.setId(sysStruAudit.getRealStruId());
            this.handleOrganDelAndChange(inUse, sysStru, realStruId, sysStruAudit);
            sysStruAudit.setState("1");
            super.updateById((BaseEntity)sysStruAudit);
            flag = true;
        } else {
            flag = true;
            SysStruAudit sysStruAudit = (SysStruAudit)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStruAudit::getId, (Object)struId));
            SysOrganAudit sysOrganAudit = (SysOrganAudit)this.iSysOrganAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getId, (Object)sysStruAudit.getOrganId()));
            SysStru sysStru = new SysStru();
            boolean struFlag = this.handleStru(sysStru, sysStruAudit, inUse, sysOrganAudit);
            flag &= struFlag;
            SysOrgan sysOrgan = new SysOrgan();
            boolean organFlag = this.handleOrgan(sysOrgan, sysOrganAudit, inUse, sysStru);
            flag &= organFlag;
            List assistOrganAudits = this.sysStruAssistOrganAudit.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrganAudit::getStruId, (Object)realStruId));
            ArrayList idList = new ArrayList();
            assistOrganAudits.forEach(item -> idList.add(item.getAssistParentId()));
            String join = StringUtils.join(idList, (String)",");
            this.sysStruAssistOrgan.saveAssistOrgan(join, realStruId);
            this.sysStruAssistOrganAudit.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrganAudit::getStruId, (Object)realStruId));
            this.sysUsersMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
            this.handleCas(organFlag, inUse, sysOrgan, sysStru);
            flag = this.handleOfficeAndStaff(sysStruAudit, sysStru, flag);
            sysStruAudit.setState("1");
            boolean stateFlag = super.updateById((BaseEntity)sysStruAudit);
            flag &= stateFlag;
        }
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_FAIL.getMessage()));
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }

    private void handleOrganDelAndChange(String inUse, SysStru sysStru, Long realStruId, SysStruAudit sysStruAudit) {
        if ("3".equals(inUse)) {
            this.iSysStruService.removeById((Object)sysStru);
            if (ToolUtil.equals((Object)"9", (Object)((SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId())).getOrganType())) {
                this.sysStruAssistOrganMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getStruId, (Object)realStruId));
                JSONObject object = new JSONObject();
                object.put("sysOrgan", null);
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("person", null, (Object)object, Constants.NONE_NODE_ID);
            } else {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysStruRoleAudit::getStruId, (Object)realStruId);
                this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
                this.bpmAbstractPushMsgMatcher.delete("organ", sysStru.getId(), null);
                this.abstractPushMsgMatcher.insertOperation("organ", null, (Object)sysStru.getId(), Constants.NONE_NODE_ID);
            }
            this.sysStruAuditMapper.updateStates(sysStruAudit.getRealStruId());
        } else {
            this.sysOrgManageService.orgCodeChange(sysStru.getId(), sysStru.getParentId(), sysStru.getStruType(), sysStru.getStruLevel());
            this.iSysStruService.updateById((Object)sysStru);
            if (ToolUtil.equals((Object)"9", (Object)((SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId())).getOrganType())) {
                this.sysStruAssistOrganMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getStruId, (Object)realStruId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)sysStru.getParentId()));
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(SysUsers::getEmployeeId, (Object)realStruId);
                List usersListOfOrganChange = this.sysUsersService.list((Wrapper)wrapper);
                for (SysUsers sysUsers : usersListOfOrganChange) {
                    sysUsers.setDepartmentId(sysStru.getParentId());
                    sysUsers.setCorporationId(sysStru.getParentId());
                }
                this.sysUsersService.saveOrUpdateBatch((Collection)usersListOfOrganChange);
                JSONObject object = new JSONObject();
                object.put("sysOrgan", null);
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("person", "update", (Object)object, Constants.NONE_NODE_ID);
            } else {
                this.bpmAbstractPushMsgMatcher.pushOrgan(null, sysStru, "update");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", null);
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_NODE_ID);
            }
        }
    }

    private void handleCas(boolean organFlag, String inUse, SysOrgan sysOrgan, SysStru sysStru) {
        if (!organFlag) {
            return;
        }
        if ("1".equals(inUse)) {
            JSONObject object = new JSONObject();
            object.put("sysOrgan", (Object)sysOrgan);
            object.put("sysStru", (Object)sysStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "add", (Object)object, Constants.NONE_NODE_ID);
            this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "add");
        } else if (!ToolUtil.equals((Object)"9", (Object)((SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId())).getOrganType())) {
            this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "update");
            JSONObject object = new JSONObject();
            object.put("sysOrgan", (Object)sysOrgan);
            object.put("sysStru", (Object)sysStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_NODE_ID);
        } else {
            JSONObject object = new JSONObject();
            object.put("sysOrgan", (Object)sysOrgan);
            object.put("sysStru", (Object)sysStru);
            this.abstractPushMsgMatcher.insertOperation("person", "update", (Object)object, Constants.NONE_NODE_ID);
        }
    }

    private boolean handleOfficeAndStaff(SysStruAudit sysStruAudit, SysStru sysStru, boolean flag) {
        SysStaffAudit sysStaffAudit;
        SysOfficeAudit sysOfficeAudit = (SysOfficeAudit)this.iSysOfficeAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOfficeAudit::getStruId, (Object)sysStruAudit.getId()));
        if (ToolUtil.isNotEmpty((Object)sysOfficeAudit)) {
            SysOffice sysOffice = new SysOffice();
            CopyPropertieUtils.copyProperties((Object)sysOffice, (Object)sysOfficeAudit);
            sysOffice.setStruId(sysStru.getId());
            sysOffice.setId(sysOfficeAudit.getRealOfficeId());
            boolean officeFlag = this.iSysOfficeService.saveOrUpdate((Object)sysOffice);
            flag &= officeFlag;
        }
        if (ToolUtil.isNotEmpty((Object)(sysStaffAudit = (SysStaffAudit)this.iSysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)sysStruAudit.getId()))))) {
            SysStaff sysStaff = new SysStaff();
            CopyPropertieUtils.copyProperties((Object)sysStaff, (Object)sysStaffAudit);
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setId(sysStaffAudit.getRealStaffId());
            boolean staffFlag = this.iSysStaffService.saveOrUpdate((Object)sysStaff);
            flag &= staffFlag;
        }
        return flag;
    }

    private boolean handleStru(SysStru sysStru, SysStruAudit sysStruAudit, String inUse, SysOrganAudit sysOrganAudit) {
        CopyPropertieUtils.copyProperties((Object)sysStru, (Object)sysStruAudit);
        sysStru.setId(sysStruAudit.getRealStruId());
        if (!"1".equals(inUse)) {
            sysStru.setOrganId(sysOrganAudit.getRealOrganId());
        }
        return this.iSysStruService.saveOrUpdate((Object)sysStru);
    }

    private boolean handleOrgan(SysOrgan sysOrgan, SysOrganAudit sysOrganAudit, String inUse, SysStru sysStru) {
        CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysOrganAudit);
        if ("2".equals(inUse)) {
            sysOrgan.setId(sysOrganAudit.getRealOrganId());
        } else {
            sysOrgan.setId(sysStru.getOrganId());
        }
        this.sysOrgManageService.wrapAddOrgan(sysStru, sysOrgan);
        return this.iSysOrganService.saveOrUpdate((Object)sysOrgan);
    }

    public OrganInfoVo getEditOrgInfoById(Long struId) {
        return this.sysStruAuditMapper.getEditOrgInfoById(struId);
    }

    public OrganInfoMapVo getStruAuditDetail(SysStruAudit sysStruAudit) {
        if (ToolUtil.isEmpty((Object)sysStruAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_STRU_AUDIT_NOT_NULL.getMessage()));
        }
        OrganInfoMapVo organInfoMapVo = new OrganInfoMapVo();
        Long struId = sysStruAudit.getId();
        String type = sysStruAudit.getInUse();
        Long realStruId = sysStruAudit.getRealStruId();
        if ("1".equals(type)) {
            OrganInfoVo orgInfo = this.getOrgInfoById(struId);
            organInfoMapVo.setOrgData(orgInfo);
        } else if ("2".equals(type)) {
            OrganInfoVo orgInfo = this.getEditOrgInfoById(struId);
            OrganInfoVo oldOrgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
            organInfoMapVo.setOrgData(orgInfo);
            organInfoMapVo.setOldOrgData(oldOrgInfo);
        } else if ("3".equals(type)) {
            OrganInfoVo orgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
            organInfoMapVo.setOrgData(orgInfo);
        } else {
            OrganInfoVo oldOrgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
            String newParentName = this.getNewParentName(struId);
            OrganInfoVo orgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
            orgInfo.setParentName(newParentName);
            organInfoMapVo.setOrgData(orgInfo);
            organInfoMapVo.setOldOrgData(oldOrgInfo);
        }
        return organInfoMapVo;
    }

    public JSONObject getStaffAuditDetail(SysStruAudit sysStruAudit) {
        if (ToolUtil.isEmpty((Object)sysStruAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_STRU_AUDIT_NOT_NULL.getMessage()));
        }
        sysStruAudit = (SysStruAudit)this.sysStruAuditMapper.selectById(sysStruAudit.getId());
        Long struId = sysStruAudit.getId();
        String type = sysStruAudit.getInUse();
        JSONObject jsonObject = new JSONObject();
        Long realStruId = sysStruAudit.getRealStruId();
        switch (type) {
            case "1": {
                this.organAdd(struId, jsonObject);
                break;
            }
            case "2": {
                this.organEdit(realStruId, struId, jsonObject);
                break;
            }
            case "3": {
                this.organDelete(realStruId, jsonObject);
                break;
            }
            default: {
                this.organDefult(realStruId, struId, jsonObject);
            }
        }
        return jsonObject;
    }

    public List<SysStruAssistOrganAudit> getAssistDetail(Long struId) {
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_AUDIT_ID_NOT_EMPTY.getMessage()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrganAudit::getStruId, (Object)struId);
        return this.sysStruAssistOrganAudit.selectList((Wrapper)wrapper);
    }

    public List<SysStruAssistOrganAudit> getAssistDetail(String struId) {
        return this.getAssistDetail(Long.parseLong(struId));
    }

    private void organAdd(Long struId, JSONObject jsonObject) {
        OrganInfoVo orgInfo = this.getOrgInfoById(struId);
        SysStaffAudit staff = (SysStaffAudit)this.iSysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)struId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaffAudit();
        }
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("staffData", (Object)staff);
    }

    private void organEdit(Long realStruId, Long struId, JSONObject jsonObject) {
        String odlSex;
        List<String> list = this.sysStruAssistOrganAudit.getStruId(realStruId);
        List<String> list1 = this.sysStruAssistOrganMapper.getStruId(realStruId);
        boolean typeDetails = ToolUtil.isEmpty(list) && ToolUtil.isEmpty(list1) ? false : !list.containsAll(list1) || !list1.containsAll(list);
        OrganInfoVo orgInfo = this.getEditOrgInfoById(struId);
        SysStaffAudit staff = (SysStaffAudit)this.iSysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)struId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaffAudit();
        }
        OrganInfoVo oldOrgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
        SysStaff oldStaff = (SysStaff)this.iSysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)realStruId));
        String sex = staff.getSex();
        if (sex != null) {
            List dicSingleList = this.sysDicRefService.getDictByType(SEX);
            for (DicSingle dicSingle : dicSingleList) {
                if (!dicSingle.getValue().equals(sex)) continue;
                sex = TranslateUtil.getTranslateName((String)dicSingle.getLabelLangKey());
                break;
            }
            staff.setSex(sex);
        }
        if ((odlSex = oldStaff.getSex()) != null) {
            List dicSingleList = this.sysDicRefService.getDictByType(SEX);
            for (DicSingle dicSingle : dicSingleList) {
                if (!dicSingle.getValue().equals(odlSex)) continue;
                odlSex = TranslateUtil.getTranslateName((String)dicSingle.getLabelLangKey());
                break;
            }
            oldStaff.setSex(odlSex);
        }
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("staffData", (Object)staff);
        jsonObject.put("oldOrgData", (Object)oldOrgInfo);
        jsonObject.put("oldStaffData", (Object)oldStaff);
        jsonObject.put("typeDetails", (Object)typeDetails);
    }

    private void organDelete(Long realStruId, JSONObject jsonObject) {
        OrganInfoVo orgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
        SysStaff staff = (SysStaff)this.iSysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)realStruId), false);
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        }
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("staffData", (Object)staff);
    }

    private void organDefult(Long realStruId, Long struId, JSONObject jsonObject) {
        String sex;
        OrganInfoVo oldOrgInfo = this.sysOrgManageService.getOldOrgInfoById(realStruId);
        String newParentName = this.getNewParentName(struId);
        SysStaffAudit staff = (SysStaffAudit)this.iSysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)struId));
        SysStaff oldStaff = (SysStaff)this.iSysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)realStruId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaffAudit();
        }
        if ((sex = oldStaff.getSex()) != null) {
            List dicSingleList = this.sysDicRefService.getDictByType(SEX);
            for (DicSingle dicSingle : dicSingleList) {
                if (!dicSingle.getValue().equals(sex)) continue;
                sex = TranslateUtil.getTranslateName((String)dicSingle.getLabelLangKey());
                break;
            }
            oldStaff.setSex(sex);
        }
        OrganInfoVo orgInfo = this.getEditOrgInfoById(struId);
        Long orgInfoId = orgInfo.getId();
        orgInfo.setParentName(newParentName);
        if ("4".equals(orgInfo.getInUse())) {
            CopyPropertieUtils.copyProperties((Object)orgInfo, (Object)oldOrgInfo);
            orgInfo.setId(orgInfoId);
            orgInfo.setParentName(newParentName);
            CopyPropertieUtils.copyProperties((Object)staff, (Object)oldStaff);
        }
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("staffData", (Object)staff);
        jsonObject.put("oldOrgData", (Object)oldOrgInfo);
        jsonObject.put("oldStaffData", (Object)oldStaff);
    }
}

