/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authorization.permit.dao.SysPasswordHistMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalSysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@DependsOn(value={"springContextHolder"})
public class LocalSysUsersServiceImpl
extends HussarBaseServiceImpl<SysUsersMapper, SysUsers>
implements ILocalSysUsersService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalSysUsersServiceImpl.class);
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysPasswordHistMapper sysPasswordHistMapper;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private IHussarBaseUserService hussarBaseUserService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};

    public SysUsers getOne(String connName, String userAccount, List<String> accountStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).in(SysUsers::getAccountStatus, accountStatus);
        return HussarUtils.isEmpty((Object)connName) ? (SysUsers)this.getOne((Wrapper)queryWrapper) : (SysUsers)this.getOne(connName, (Wrapper)queryWrapper);
    }

    public List<SysUsers> getExpireTemporary(LocalDateTime end) {
        return ((SysUsersMapper)this.baseMapper).getExpireTemporaty(end);
    }

    public Boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public List<SysPasswordHist> getPwdHist(Long userId) {
        return this.sysPasswordHistMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPasswordHist::getUserId, (Object)userId)).orderByDesc(HussarBaseEntity::getCreateTime));
    }

    @HussarTransactional
    public void updatePwd(SysUsers sysUsers) {
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(sysUsers.getId());
        user.setPassword(sysUsers.getPassword());
        user.setPswdUptTime(Java8DateUtils.currentLocalDateTime());
        String pwdExtinctTime = DateUtil.getAfterDayDate((String)(this.hussarPwdConfigService.getPasswordHist() + ""));
        user.setPswdTime(Java8DateUtils.convertStringToLocalDateTime((String)pwdExtinctTime));
        this.updateById((BaseEntity)user);
        List<SysPasswordHist> list = this.sysPasswordHistMapper.lastCreateTime(sysUsers.getId());
        if (list.size() >= this.hussarPwdConfigService.getPwdRepeatTime() && list.size() != 0) {
            SysPasswordHist sysPasswordHist = list.get(list.size() - 1);
            this.sysPasswordHistMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPasswordHist::getUserId, (Object)sysPasswordHist.getUserId())).eq(SysPasswordHist::getPassword, (Object)sysPasswordHist.getPassword()));
        }
        SysPasswordHist sph = new SysPasswordHist();
        sph.setUserId(sysUsers.getId());
        sph.setPassword(sysUsers.getPassword());
        this.sysPasswordHistMapper.insert(sph);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        loginLock.removeUserCache(String.valueOf(sysUsers.getId()));
    }

    public SysUsers getUserByAccountAndStatus(String connName, String userAccount, List<String> accountStatus) {
        if (HussarUtils.isEmpty((Object)connName)) {
            SysUsers userInfo = this.hussarBaseUserService.getUserInfo(userAccount, accountStatus);
            return userInfo;
        }
        SysUsers userInfo = this.hussarBaseUserService.getUserInfo(connName, userAccount, accountStatus);
        return userInfo;
    }
}

