/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.StaffUserMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IStaffUserService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class StaffUserServiceImpl
extends HussarServiceImpl<StaffUserMapper, SysStaff>
implements IStaffUserService {
    @Resource
    private StaffUserMapper staffUserMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;

    @HussarTransactional
    public void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, boolean isUpper) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruLevel() + 1));
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        SysUsers user = new SysUsers();
        user.setUserAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName());
        user.setUserName(sysOrgan.getOrganName());
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule()) : this.hussarPwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        user.setPassword(pwd);
        user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        user.setAccountStatus(com.jxdinfo.hussar.authorization.enums.UserStatus.OK.getCode());
        user.setSecurityLevel(Integer.valueOf(1));
        user.setMaxSessions(Integer.valueOf(1));
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCorporationId(sysStru.getParentId());
        user.setDepartmentId(sysStru.getParentId());
        user.setEmployeeId(sysStru.getId());
        user.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(user.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        this.sysUsersService.save((Object)user);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && user.geteMail() != null) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)pass);
        }
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleService.save((Object)userRole);
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            object.put("sysStaff", (Object)sysStaff);
        }
        object.put("sysUser", (Object)user);
        this.abstractPushMsgMatcher.insertOperation("person", "add", (Object)object, Constants.NONE_ID);
        this.bpmAbstractPushMsgMatcher.pushUser(user, "add", sysOrgan.getOrganCode());
        ArrayList<SysUserRole> bpmUserRoleVoList = new ArrayList<SysUserRole>();
        bpmUserRoleVoList.add(userRole);
        this.bpmAbstractPushMsgMatcher.pushUserRole(bpmUserRoleVoList, "add");
    }

    @HussarTransactional
    public void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String userAccount, String secretLevel) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Long level = this.staffUserMapper.getMaxLevel(sysStru.getParentId());
        Integer struLevel = null;
        struLevel = ToolUtil.isEmpty((Object)level) ? Integer.valueOf(1) : Integer.valueOf(level.toString());
        sysStru.setStruLevel(struLevel);
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        SysUsers user = new SysUsers();
        user.setSecurityLevel(Integer.valueOf(60));
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            user.setUserAccount(userAccount);
            if (ToolUtil.isNotEmpty((Object)secretLevel)) {
                user.setSecurityLevel(Integer.valueOf(Integer.parseInt(secretLevel)));
            }
        } else {
            user.setUserAccount(sysOrgan.getOrganName());
        }
        user.setUserName(sysOrgan.getOrganName());
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule()) : this.hussarPwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        user.setPassword(pwd);
        user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        user.setAccountStatus(com.jxdinfo.hussar.authorization.enums.UserStatus.OK.getCode());
        user.setSecurityLevel(Integer.valueOf(1));
        user.setMaxSessions(Integer.valueOf(1));
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCorporationId(sysStru.getParentId());
        user.setDepartmentId(sysStru.getParentId());
        user.setEmployeeId(sysStru.getId());
        user.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(user.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        this.sysUsersService.save((Object)user);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && user.geteMail() != null) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)pass);
        }
        SysStruUser sysStruUser = new SysStruUser();
        sysStruUser.setStruId(sysStru.getId());
        sysStruUser.setUserId(user.getId());
        sysStruUser.setCreateTime(LocalDateTime.now());
        sysStruUser.setLastTime(LocalDateTime.now());
        sysStruUser.setDelFlag("0");
        sysStruUser.setCreator(Long.valueOf(Long.parseLong("1450757642371981324")));
        sysStruUser.setLastEditor(Long.valueOf(Long.parseLong("1450757642371981324")));
        this.sysStruUserService.save((Object)sysStruUser);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleService.save((Object)userRole);
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            object.put("sysStaff", (Object)sysStaff);
        }
        object.put("sysUser", (Object)user);
        this.abstractPushMsgMatcher.insertOperation("person", "add", (Object)object, Constants.NONE_ID);
        this.bpmAbstractPushMsgMatcher.pushUser(user, "add", sysOrgan.getOrganCode());
        ArrayList<SysUserRole> bpmUserRoleVoList = new ArrayList<SysUserRole>();
        bpmUserRoleVoList.add(userRole);
        this.bpmAbstractPushMsgMatcher.pushUserRole(bpmUserRoleVoList, "add");
    }

    @HussarTransactional
    public void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        this.addStaffUser(sysStru, sysOrgan, sysStaff, false);
    }

    @HussarTransactional
    public void editStaffUserVue(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String ids) {
        SysUsers user;
        this.sysOrganMapper.updateById(sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById(sysStru);
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        Long sysStruId = sysStru.getId();
        this.iSysStruAssistOrganService.saveAssistOrgan(ids, sysStruId);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            super.saveOrUpdate((BaseEntity)sysStaff);
        }
        if (ToolUtil.isNotEmpty((Object)(user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).ne(SysUsers::getAccountStatus, (Object)com.jxdinfo.hussar.authorization.enums.UserStatus.DELETE.getCode()), false)))) {
            user.setUserName(sysOrgan.getOrganName());
            this.sysUsersService.updateById((Object)user);
        }
    }

    @HussarTransactional
    public void editStaffUserVue(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String ids, String userAccount, String secretLevel, String accountStatus) {
        SysUsers user;
        this.sysOrganMapper.updateById(sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById(sysStru);
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        Long sysStruId = sysStru.getId();
        this.iSysStruAssistOrganService.saveAssistOrgan(ids, sysStruId);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            super.saveOrUpdate((BaseEntity)sysStaff);
        }
        if (ToolUtil.isNotEmpty((Object)(user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).ne(SysUsers::getAccountStatus, (Object)com.jxdinfo.hussar.authorization.enums.UserStatus.DELETE.getCode()), false)))) {
            if (ToolUtil.isNotEmpty((Object)userAccount)) {
                user.setUserAccount(userAccount);
                user.setUserName(sysOrgan.getOrganName());
                user.setCorporationId(sysStru.getParentId());
                user.setDepartmentId(sysStru.getParentId());
                if (ToolUtil.isNotEmpty((Object)secretLevel)) {
                    user.setSecurityLevel(Integer.valueOf(Integer.parseInt(secretLevel)));
                }
                if (ToolUtil.isNotEmpty((Object)accountStatus)) {
                    user.setAccountStatus(accountStatus);
                }
            } else {
                user.setUserName(sysOrgan.getOrganName());
            }
            this.sysUsersService.updateById((Object)user);
        }
    }

    @HussarTransactional
    public String deleteStaffUserVue(Long struId) {
        SysStru sysStru;
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_DEL_ID.getMessage()));
        }
        StringBuffer msg = new StringBuffer();
        if (!this.iSysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_PERSONNEL_HAVE_UNAPPROVED.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.iSysStruAuditService.save((Object)sysStruAudit);
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_DEL_SUC_EFFECTIVE.getMessage()));
        } else {
            sysStru = (SysStru)this.sysStruService.getById((Serializable)struId);
            this.sysStruMapper.deleteById(struId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_DEL_SUC.getMessage()));
            if ("9".equals(sysStru.getStruType())) {
                Long organId = sysStru.getOrganId();
                if (ToolUtil.isNotEmpty((Object)organId)) {
                    this.sysOrganService.removeById((Serializable)organId);
                }
                QueryWrapper sysStaffQueryWrapper = new QueryWrapper();
                sysStaffQueryWrapper.lambda().eq(SysStaff::getStruId, (Object)struId);
                this.sysStaffService.remove((Wrapper)sysStaffQueryWrapper);
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getEmployeeId, (Object)struId);
        List sysUsersList = this.sysUsersService.list((Wrapper)wrapper);
        if (HussarUtils.isEmpty((Object)sysUsersList)) {
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_NOT_ASSOCIATED_USER.getMessage()));
        } else {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
                for (SysUsers sysUser : sysUsersList) {
                    if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
                    }
                    if (shiroUser.getId().equals(sysUser.getId())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
                    }
                    if (this.iSysUsersAuditService.adjustEdit(sysUser.getId())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_UNAPPROVED_DEL.getMessage()));
                    }
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
                    sysUsersAudit.setId(null);
                    sysUsersAudit.setUserId(sysUser.getId());
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCurrentStatus("2");
                    this.iSysUsersAuditService.save((Object)sysUsersAudit);
                }
                msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUC_SYN_DEL_USER_APPROVAL.getMessage()));
            } else {
                for (SysUsers sysUser : sysUsersList) {
                    if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
                    }
                    if (shiroUser.getId().equals(sysUser.getId())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
                    }
                    sysUser.setAccountStatus(UserStatus.DELETE.getCode());
                    sysUser.setEmployeeId(Long.valueOf(0L));
                    this.sysStruMapper.updatePrincipal(sysUser.getId());
                    this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
                    this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
                    this.sysUsersService.updateById((Object)sysUser);
                }
                msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_DEL_SUCCESSFUL.getMessage()));
            }
        }
        return msg.toString();
    }

    public boolean isAccountExist(SysStru stru) {
        boolean flag = false;
        Long count = this.sysUsersService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)stru.getOrganAlias())).ne(SysUsers::getAccountStatus, (Object)com.jxdinfo.hussar.authorization.enums.UserStatus.DELETE.getCode())).ne(SysUsers::getEmployeeId, (Object)stru.getId()));
        if (count > 0L) {
            flag = true;
        }
        return flag;
    }
}

