/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.organ.IHussarBaseOrganizationAdapter;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.ExportOrganExcelManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.SortOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruFilterUnitService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.StruFilteredVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.excel.enums.TipConstantsEnum;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganizationServiceImpl")
public class HussarBaseOrganizationServiceImpl
implements IHussarBaseOrganizationService {
    @Autowired
    private AddOrganizationManager addOrganizationManager;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Autowired
    private DeleteOrganizationManager deleteOrganizationManager;
    @Autowired
    private SortOrganizationManager sortOrganizationManager;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private IHussarBaseOrganizationAdapter hussarBaseOrganizationAdapter;
    @Resource
    private ExportOrganExcelManager exportOrganExcelManager;
    @Resource(name="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganCustomExcelServiceImpl")
    private IHussarBaseCustomExcelService hussarBaseCustomExcelService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    protected IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private ISysStruFilterUnitService sysStruFilterUnitService;

    @HussarTransactional
    public ApiResponse<String> addOrganization(AddOrganizationDto addOrganizationDto) {
        return this.addOrganizationManager.addOrganization(addOrganizationDto);
    }

    @HussarTransactional
    public ApiResponse<String> editOrganization(EditOrganizationDto editOrganizationDto) {
        return ApiResponse.success((String)this.editOrganizationManager.editOrganization(editOrganizationDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteOrganization(Long struId) {
        return ApiResponse.success((String)this.deleteOrganizationManager.deleteOrganization(struId));
    }

    @HussarTransactional
    public ApiResponse<String> sortOrganization(List<Long> idList) {
        return ApiResponse.success((String)this.sortOrganizationManager.sortOrganization(idList));
    }

    @HussarTransactional
    public ApiResponse<String> transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        return ApiResponse.success((String)this.transferOrganizationManager.transferOrganization(transferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> getTransferOrganizationTree(QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.getTransferOrganizationTree(queryTransferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganizationTree(Long parentId, String organProperty) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTree(parentId, organProperty));
    }

    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTree(parentId));
    }

    public ApiResponse<List<OrganizationTreeVo>> loadRootOrganizationPostTree() {
        return ApiResponse.success(this.queryOrganizationManager.loadRootOrganizationPostTree());
    }

    public ApiResponse<List<OrganizationTreeVo>> loadRootOrganizationPostTreeWithUserDept() {
        return ApiResponse.success(this.queryOrganizationManager.loadRootOrganizationPostTreeWithUserDept());
    }

    public ApiResponse<OrganizationPartialVo> viewOrganization(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.viewOrganization(id));
    }

    public ApiResponse<OrganizationInfoVo> loadOrganization(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.loadOrganizationById(struId));
    }

    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(PageInfo pageInfo, String name) {
        return ApiResponse.success(this.queryOrganizationManager.searchOrganization(pageInfo, name));
    }

    public ApiResponse<List<OrganizationTreeVo>> backOrganizationTree(Long organId) {
        return ApiResponse.success(this.queryOrganizationManager.backOrganizationTree(organId));
    }

    public ApiResponse<Page<OrganizationVo>> queryOrganization(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.queryOrganizationAllowPinyin(pageInfo, queryOrganizationDto));
    }

    @HussarTransactional
    public void organizationChange(Long orgId, Long parentId, String orgType, Integer struOrder) {
        this.transferOrganizationManager.organizationChange(orgId, parentId, orgType, struOrder);
    }

    @HussarTransactional
    public synchronized void refreshOrgan() {
        this.hussarBaseOrganizationAdapter.refreshOrgan();
    }

    public ApiResponse<List<SysStruRuleVo>> getOrganizationTypeByParentId(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrganizationTypeByParentId(parentId));
    }

    public ApiResponse<List<OrganizationTreeVo>> getOrderOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrderOrganizationTree(parentId));
    }

    public ApiResponse<OrganizationTreeVo> lazyOrganizationById(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.lazyOrganizationById(id));
    }

    public ApiResponse<List<ReadOnlyOrganizationTreeVo>> lazyLoadingOrganizationTreeNoPermissions(Long parentId, String organProperty) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTreeNoPermissions(parentId, organProperty));
    }

    public ApiResponse<Page<OrganizationVo>> transferOrganizationList(PageInfo pageInfo, QueryTransferOrganizationListDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.transferOrganizationList(pageInfo, queryOrganizationDto));
    }

    public ApiResponse<String> getOrganFname(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getOrganFname(struId), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public ApiResponse<SelectCustomOrgTreeVo> getCustomOrgTree(Long dataRightId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getCustomOrgTree(dataRightId));
    }

    public ApiResponse<Page<OrganizationTreeVo>> getOrganListByType(PageInfo pageInfo, String organType, String organName) {
        return ApiResponse.success(this.queryOrganizationManager.getOrganListByType(pageInfo, organType, organName));
    }

    public ApiResponse<List<OrganVo>> getRoleOrgan(String roleId) {
        return ApiResponse.success(this.queryOrganizationManager.getRoleOrgan(roleId));
    }

    public List<OrganTreeInitVo> getOrganTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)com.jxdinfo.hussar.authorization.enums.TipConstantsEnum.AUTHOR_ENTER_TRUE_LAZY_PARAM.getMessage()));
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, false, false);
        if (parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
            organs.add(firstOrgan);
        }
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenOrgan(Long parentId) {
        return this.queryOrganizationManager.getChildrenOrgan(parentId, false, false);
    }

    public List<OrganTreeInitVo> getOrgansLikeName(String searchValue) {
        return this.queryOrganizationManager.getOrgansLikeName(searchValue);
    }

    public List<OrganTreeInitVo> getUpOrganTreeByOrganId(Long id) {
        int defaultLevel = 0;
        if (!id.equals(OrganConstants.ROOT_ORGAN_ID)) {
            Integer level = this.sysStruMapper.getStruLevelByStruId(id);
            if (level != null) {
                defaultLevel = level;
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)com.jxdinfo.hussar.authorization.enums.TipConstantsEnum.AUTHOR_ENTER_TRUE_PARAM.getMessage()));
            }
        }
        List<Object> parentLevelOrganList = new ArrayList();
        parentLevelOrganList = this.sysStruMapper.queryUpOrgansByFidAndLevel("", defaultLevel, false, false);
        for (OrganTreeInitVo organTreeInitVo : parentLevelOrganList) {
            organTreeInitVo.setChangedLevel(organTreeInitVo.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
        parentLevelOrganList.add(firstOrgan);
        Long l = this.queryOrganizationManager.getParentOrganId(id);
        List<Object> organList = new ArrayList();
        organList = this.sysStruMapper.queryBrotherOrgans(l, false, false);
        organList.addAll(parentLevelOrganList);
        return this.queryOrganizationManager.getOrganTree(organList);
    }

    public OrganTreeInitVo getOrganInfoById(Long struId) {
        return this.queryOrganizationManager.getOrganInfoById(struId);
    }

    public void exportOrganExcel(String ids, Long taskId, boolean exportKey) throws Exception {
        this.exportOrganExcelManager.exportOrganExcel(ids, taskId, exportKey);
    }

    public void exportOrganExcelWithSecurity(String ids, Long taskId, boolean exportKey, String securityLevel) throws Exception {
        this.exportOrganExcelManager.exportOrganExcelWithSecurity(ids, taskId, exportKey, securityLevel);
    }

    public void exportOrganExcelWithSecurityForBigDate(List<String> idList, Long taskId, Boolean exportKey, String securityLevel) throws Exception {
        this.exportOrganExcelManager.exportOrganExcelWithSecurityForBigDate(idList, taskId, exportKey, securityLevel);
    }

    public void downloadOrganExcelImpTpl(HttpServletResponse response, String fileKey) {
        this.exportOrganExcelManager.downloadOrganExcelImpTpl(response, fileKey);
    }

    public void checkOrganExcel(MultipartFile file, String scenario, Long taskId) {
        InputStream input;
        try {
            input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = file.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), OrganExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap(), this.exportOrganExcelManager.getOrganExcelOptions());
        });
    }

    public void checkOrganExcelWithSecurity(MultipartFile file, String scenario, Long taskId, String securityLevel) {
        ApiResponse fileResponse;
        InputStream input;
        try {
            input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = file.getOriginalFilename();
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            FileAddition addition = new FileAddition();
            addition.setSecurityLevel(securityLevel);
            String securityAddition = JsonUtil.toJson((Object)addition);
            fileResponse = this.ossService.backgroundUploadWithAddition(file, securityAddition);
        } else {
            fileResponse = this.ossService.backgroundUpload(file);
        }
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        Locale locale = LocaleContextHolder.getLocale();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), OrganExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap(), this.exportOrganExcelManager.getOrganExcelOptions());
        });
    }

    public void importOrganExcel(String scenario, Long taskId) {
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        Locale locale = LocaleContextHolder.getLocale();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ImportSheetMsg importSheetMsg = new ImportSheetMsg(Integer.valueOf(0), OrganExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg);
            this.hussarBaseExcelService.importExcelSheets(importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap());
        });
    }

    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganTreeSearch(QueryOrganizationDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganTreeSearch(queryOrganizationDto));
    }

    public ApiResponse<Boolean> checkSameOrganName(String organName, Long parentId, Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.checkSameOrganName(organName, parentId, id));
    }

    public ApiResponse<List<OrganizationTreeVo>> getRolePostTree() {
        return ApiResponse.success(this.queryOrganizationManager.getRolePostTree());
    }

    private Map<String, Integer> getExcludeColumnIndexesMap() {
        HashMap<String, Integer> excludeColumnIndexesMap = new HashMap<String, Integer>();
        excludeColumnIndexesMap.put(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PRIMARY_KEY.getMessage()), 12);
        return excludeColumnIndexesMap;
    }

    public ApiResponse<String> getUserOrgRootId() {
        String rootId = "1";
        List<String> struIdList = this.sysStruMapper.getStruIdList();
        String struFid = struIdList.stream().max(Comparator.comparingInt(String::length)).orElse(null);
        if (HussarUtils.isNotEmpty((Object)struFid)) {
            String[] split;
            for (String id : split = struFid.split("/")) {
                SysStru check;
                if (!HussarUtils.isNotEmpty((Object)id) || !HussarUtils.isNotEmpty((Object)(check = (SysStru)this.sysStruMapper.selectById((Serializable)((Object)id))))) continue;
                rootId = String.valueOf(check.getId());
                break;
            }
        }
        return ApiResponse.success((Object)rootId, (String)"success");
    }

    public List<OrganTreeInitVo> getOrganTreeInitVosWithUserDept(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)com.jxdinfo.hussar.authorization.enums.TipConstantsEnum.AUTHOR_ENTER_TRUE_LAZY_PARAM.getMessage()));
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<Object> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, false, false);
        Long deptId = BaseSecurityUtil.getUser().getDeptId();
        Long rootId = OrganConstants.ROOT_ORGAN_ID;
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo filteredStruInfo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            rootId = filteredStruInfo.getRootId();
            SysStru closestUnitStru = filteredStruInfo.getClosestUnitStru();
            Set fileredStruIds = filteredStruInfo.getFilteredStruIds();
            organs = organs.stream().filter(organ -> fileredStruIds.contains(organ.getId())).collect(Collectors.toList());
            for (OrganTreeInitVo organTreeInitVo : organs) {
                if (!((Long)organTreeInitVo.getId()).equals(closestUnitStru.getId())) continue;
                organTreeInitVo.setParentId((Serializable)rootId);
                break;
            }
        }
        if (parentId.equals(rootId)) {
            OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(rootId);
            organs.add(firstOrgan);
        }
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }
}

