/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addBatchOutsideOrganizationManagerImpl")
public class AddBatchOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements AddBatchOutsideOrganizationManager {
    @Override
    public R<AddOutsideOrganizationDto> addBatchOrganizations(List<AddOutsideOrganizationDto> organs) {
        R result = new R();
        List errors = OrganUtil.validateMany(organs);
        Map organTypeMap = this.organTypeService.queryOrganTypeMap();
        List<String> organCodes = organs.stream().map(item -> StringUtils.trimToEmpty((String)item.getOrganCode())).distinct().collect(Collectors.toList());
        List<String> duplicateCodes = this.sysOrganMapper.selectDuplicateCodeByCodes(organCodes);
        for (AddOutsideOrganizationDto organ : organs) {
            String organType = StringUtils.trimToEmpty((String)organ.getOrganType());
            if (this.duplicateOrganCode(organ, organs, duplicateCodes)) {
                OrganUtil.addErrorMsg((List)errors, (Object)organ, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATION_CODE_DUPLICATION.getMessage())});
            }
            if (organTypeMap.get(organType) == null) {
                OrganUtil.addErrorMsg((List)errors, (Object)organ, (String)"organType", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NON_EXIST_ORG_TYPE.getMessage())});
            }
            if (!HussarUtils.isBlank((CharSequence)organ.getParentOrganCode()) || !HussarUtils.isNotEmpty(organTypeMap.get(organType)) || ((SysOrganType)organTypeMap.get(organType)).getParentType().equals("0")) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)organ, (String)"organType", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_COMPLIANT_ORG_TYPE.getMessage())});
        }
        Map<String, Set<String>> typeRuleMap = this.getOrganTypeRuleMap();
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (!result.isSuccess()) {
            return result;
        }
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (AddOutsideOrganizationDto dto : organs) {
            multiValueMap.add((Object)StringUtils.trimToEmpty((String)dto.getParentOrganCode()), (Object)dto);
        }
        this.handleStruOrganOffice((LinkedMultiValueMap<String, AddOutsideOrganizationDto>)multiValueMap, typeRuleMap, dataMappings, (R<AddOutsideOrganizationDto>)result);
        return result;
    }

    private void handleStruOrganOffice(LinkedMultiValueMap<String, AddOutsideOrganizationDto> multiValueMap, Map<String, Set<String>> typeRuleMap, List<DataMapping> dataMappings, R<AddOutsideOrganizationDto> result) {
        LinkedHashSet<SysStru> sysStruCollection = new LinkedHashSet<SysStru>();
        LinkedHashSet<SysStru> updateCollection = new LinkedHashSet<SysStru>();
        LinkedHashSet<SysOrgan> sysOrganCollection = new LinkedHashSet<SysOrgan>();
        LinkedHashSet<SysOffice> sysOfficeCollection = new LinkedHashSet<SysOffice>();
        for (Map.Entry entry : multiValueMap.entrySet()) {
            Long parentId;
            String parentOrganCode = (String)entry.getKey();
            AtomicBoolean existDb = new AtomicBoolean();
            int level = 1;
            SysOrgan parentSysOrgan = null;
            SysStru parentSysStru = null;
            String organProperty = "0";
            if (HussarUtils.isBlank((CharSequence)parentOrganCode)) {
                parentId = Constants.ROOT_NODE_ID;
            } else if (parentOrganCode.equals(String.valueOf(Constants.ROOT_NODE_ID))) {
                parentId = Constants.ROOT_NODE_ID;
            } else if (parentOrganCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
                parentId = Constants.OUT_STRU_NODE_ID;
                organProperty = "1";
            } else {
                parentSysOrgan = this.findSysOrgan(parentOrganCode, sysOrganCollection);
                parentSysStru = this.findSysStru(parentSysOrgan, sysStruCollection, existDb);
                level = parentSysStru != null ? parentSysStru.getStruLevel() + 1 : 1;
                parentId = parentSysStru == null ? Constants.ROOT_NODE_ID : parentSysStru.getId();
                organProperty = parentSysOrgan != null ? parentSysOrgan.getOrganProperty() : null;
            }
            int struOrder = this.getStruOrder(parentId, sysStruCollection);
            List children = (List)entry.getValue();
            for (AddOutsideOrganizationDto addOrganizationDto : children) {
                this.checkOrganType(addOrganizationDto, parentSysOrgan, typeRuleMap);
                SysStru sysStru = new SysStru();
                SysOffice sysOffice = new SysOffice();
                SysOrgan sysOrgan = new SysOrgan();
                sysOrgan.setOrganProperty(organProperty);
                this.initializationAdd(parentId, level, struOrder, addOrganizationDto, sysStru, sysOrgan, sysOffice);
                dataMappings.add(new DataMapping(sysStru.getId(), sysOrgan.getOrganCode()));
                this.wrapAddOrgan(sysStruCollection, updateCollection, sysOrganCollection, sysOfficeCollection, parentId, level, existDb, sysStru, sysOrgan, sysOffice, parentSysStru, parentSysOrgan);
            }
        }
        result.setSuccessList(dataMappings);
        this.organService.saveBatch(sysOrganCollection);
        this.sysOfficeService.saveBatch(sysOfficeCollection);
        if (HussarUtils.isNotEmpty(updateCollection)) {
            this.struService.updateBatchById(updateCollection);
        }
        this.struService.saveBatch(sysStruCollection);
    }

    @NotNull
    private Map<String, Set<String>> getOrganTypeRuleMap() {
        List rules = this.sysStruRuleMapper.selectList(null);
        HashMap<String, Set<String>> typeMap = new HashMap<String, Set<String>>();
        for (SysStruRule rule : rules) {
            HashSet<String> set;
            String organType = rule.getOrganType();
            if (typeMap.containsKey(organType)) {
                set = new HashSet((Collection)typeMap.get(organType));
                set.add(rule.getSysOrganType());
                typeMap.put(organType, set);
                continue;
            }
            set = new HashSet<String>();
            set.add(rule.getSysOrganType());
            typeMap.put(organType, set);
        }
        return typeMap;
    }

    private void checkOrganType(AddOutsideOrganizationDto addOrganizationDto, SysOrgan parentSysOrgan, Map<String, Set<String>> typeRuleMap) {
        if (HussarUtils.isNotEmpty((Object)parentSysOrgan)) {
            Set<String> list = typeRuleMap.get(addOrganizationDto.getOrganType());
            if (HussarUtils.isEmpty(list)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
            }
            if (!list.contains(parentSysOrgan.getOrganType())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
            }
        }
    }

    private void wrapAddOrgan(Set<SysStru> sysStruList, Set<SysStru> updateCollection, Set<SysOrgan> sysOrganCollection, Set<SysOffice> sysOfficeCollection, Long parentId, int level, AtomicBoolean existDb, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, SysStru parentSysStru, SysOrgan parentSysOrgan) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        if (level > 1) {
            pSeq = parentSysStru.getStruSeq();
            pFid = parentSysStru.getStruFid();
            sysOrgan.setParentTypeCode(parentSysOrgan.getOrganType());
            organFcode = parentSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = parentSysOrgan.getOrganFname() + organFname;
            parentSysStru.setIsLeaf("N");
            if (existDb.get()) {
                updateCollection.add(parentSysStru);
            } else {
                sysStruList.add(parentSysStru);
            }
        }
        sysStru.setStruSeq(this.getStruSeqByParentId(parentId, sysStruList, pFid, pSeq, level));
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
        sysStruList.add(sysStru);
        sysOrganCollection.add(sysOrgan);
        sysOfficeCollection.add(sysOffice);
    }

    private void initializationAdd(Long parentId, int level, Integer struOrder, AddOutsideOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String organName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)addOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAddress());
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(parentId);
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setOrganAlias(organAlias);
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer n = struOrder;
        Integer n2 = struOrder = Integer.valueOf(struOrder + 1);
        sysStru.setStruOrder(n);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(organCode);
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
        sysOrgan.setOrganType(organType);
        sysOrgan.setExpansionMap(addOrganizationDto.getExpansionMap());
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        sysOrgan.setOrganCode(organCode);
        sysStru.setIsLeaf("Y");
    }

    private boolean duplicateOrganCode(AddOutsideOrganizationDto organ, List<AddOutsideOrganizationDto> organs, List<String> duplicateCodes) {
        if (HussarUtils.isNotEmpty(organs)) {
            for (AddOutsideOrganizationDto dto : organs) {
                if (dto == organ) break;
                if (dto == organ || !dto.getOrganCode().trim().equals(organ.getOrganCode().trim())) continue;
                return true;
            }
        }
        return duplicateCodes.contains(StringUtils.trimToEmpty((String)organ.getOrganCode()));
    }

    private SysOrgan findSysOrgan(String organCode, Set<SysOrgan> sysOrganList) {
        if (HussarUtils.isNotEmpty((Object)organCode)) {
            Optional<SysOrgan> find;
            if (HussarUtils.isNotEmpty(sysOrganList) && (find = sysOrganList.stream().filter(item -> item.getOrganCode().equals(organCode)).findFirst()).isPresent()) {
                return find.get();
            }
            SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode)));
            AssertUtil.isNotNull((Object)sysOrganTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_INFO.getMessage()));
            return sysOrganTemp;
        }
        return null;
    }

    private SysStru findSysStru(SysOrgan sysOrgan, Set<SysStru> sysStruList, AtomicBoolean existDb) {
        existDb.set(true);
        if (sysOrgan == null) {
            return null;
        }
        Long organId = sysOrgan.getId();
        if (HussarUtils.isNotEmpty(sysStruList)) {
            for (SysStru temp : sysStruList) {
                if (!Objects.equals(temp.getOrganId(), organId)) continue;
                existDb.set(false);
                return temp;
            }
        }
        SysStru sysStruTemp = (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)organId));
        AssertUtil.isNotNull((Object)sysStruTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_INFO.getMessage()));
        return sysStruTemp;
    }

    private String getStruSeqByParentId(Long parentId, Set<SysStru> sysStruList, String pFid, String pSeq, int level) {
        String struSeq = "";
        if (HussarUtils.isNotEmpty(sysStruList)) {
            Optional<String> max = sysStruList.stream().filter(item -> Objects.equals(item.getParentId(), parentId)).map(SysStru::getStruSeq).max(String::compareTo);
            if (max.isPresent()) {
                String maxStruSeq = max.get();
                return this.getStruSeqByMaxStruSeq(maxStruSeq, pSeq, level);
            }
            struSeq = this.getStruSeq(pFid, pSeq, level);
        } else {
            struSeq = this.getStruSeq(pFid, pSeq, level);
        }
        return struSeq;
    }

    private int getStruOrder(Long parentId, Set<SysStru> sysStruList) {
        Optional<Integer> max;
        Integer struOrder = 1;
        Integer maxOrder = HussarUtils.isNotEmpty(sysStruList) ? ((max = sysStruList.stream().filter(item -> Objects.equals(item.getParentId(), parentId)).map(SysStru::getStruOrder).max(Integer::compare)).isPresent() ? max.get() : this.sysStruMapper.getMaxOrderById(parentId)) : this.sysStruMapper.getMaxOrderById(parentId);
        if (HussarUtils.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        return struOrder;
    }
}

