/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.post.dto.QueryAuditPostDto;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditService;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostAuditMapper;
import com.jxdinfo.hussar.authorization.relational.manager.QueryUserPostAuditManager;
import com.jxdinfo.hussar.authorization.relational.vo.UserPostAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.queryUserPostAuditManagerImpl")
public class QueryUserPostAuditManagerImpl
implements QueryUserPostAuditManager {
    @Resource
    private SysUserPostAuditMapper sysUserPostAuditMapper;
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private ISysPostAuditService sysPostAuditService;
    @Autowired
    private ISysUsersAuditService sysUsersAuditService;

    @Override
    public Page<UserPostAuditVo> queryUserPostAuditList(PageInfo pageInfo, QueryAuditPostDto queryAuditPostDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryAuditPostDto.getUserName()));
        queryParams.put("postName", SqlQueryUtil.transferSpecialChar((String)queryAuditPostDto.getPostName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditPostDto.getAuditStatus())) {
            queryParams.put("auditStatus", String.valueOf(queryAuditPostDto.getAuditStatus()));
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List postAudits = this.sysPostAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysPostAudit::getAuditStatus, (Object)"1")).eq(SysPostAudit::getOperateType, (Object)"1"));
        List noPostIds = postAudits.stream().map(SysPostAudit::getPostId).collect(Collectors.toList());
        List usersAudits = this.sysUsersAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysUsersAudit::getIsAudit, (Object)"1")).eq(SysUsersAudit::getCurrentStatus, (Object)"0"));
        List noUserIds = usersAudits.stream().map(SysUsersAudit::getUserId).collect(Collectors.toList());
        queryParams.put("noPostIds", noPostIds);
        queryParams.put("noUserIds", noUserIds);
        List<UserPostAuditVo> userPostAuditVos = this.sysUserPostAuditMapper.queryUserPostAuditList((Page<UserPostAuditVo>)page, queryParams);
        if (HussarUtils.isEmpty(userPostAuditVos)) {
            page.setRecords(userPostAuditVos);
            return page;
        }
        List userIds = userPostAuditVos.stream().map(UserPostAuditVo::getUserId).distinct().collect(Collectors.toList());
        List organByUserIds = this.hussarBaseOrganizationBoService.getOrganByUserIds(userIds);
        Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (UserPostAuditVo auditVo : userPostAuditVos) {
            List<UserOrganPostVo> userOrganPostVos = userOrganMap.get(auditVo.getUserId());
            String organNames = null;
            if (HussarUtils.isNotEmpty(userOrganPostVos)) {
                organNames = userOrganPostVos.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            }
            auditVo.setOrganName(organNames);
        }
        page.setRecords(userPostAuditVos);
        return page;
    }
}

