/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruFilterUnitService;
import com.jxdinfo.hussar.authorization.organ.vo.StruFilteredVo;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ILocalPostBoService;
import com.jxdinfo.hussar.authorization.post.vo.OrganPostTreeVo;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.authorization.post.vo.PostVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.post.service.impl.localPostBoServiceImpl")
public class LocalPostBoServiceImpl
implements ILocalPostBoService {
    private static final String PARENT_ID = "parentId";
    private static final String ORGAN_PROPERTY = "organProperty";
    @Resource
    private SysPostMapper sysPostMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private ISysStruFilterUnitService sysStruFilterUnitService;

    public List<PostBasicVo> getPostsByStruId(Long struId, String postName) {
        List<PostVo> postVos;
        ArrayList<PostBasicVo> result = new ArrayList<PostBasicVo>();
        if (HussarUtils.isNotEmpty((Object)struId)) {
            postVos = this.sysPostMapper.postSelect(null, struId, postName);
        } else {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("postName", postName);
            postVos = this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
        }
        if (HussarUtils.isEmpty(postVos)) {
            return result;
        }
        for (PostVo vo : postVos) {
            PostBasicVo post = new PostBasicVo();
            post.setPostId(vo.getPostId());
            post.setPostName(vo.getPostName());
            result.add(post);
        }
        return result;
    }

    public List<OrganPostTreeVo> lazyLoadOrganPostTree(Long parentId) {
        AssertUtil.isNotNull((Object)parentId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAMETERS.getMessage()));
        ArrayList<Object> result = new ArrayList<Object>();
        if (!HussarUtils.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
            List postIds;
            LambdaQueryWrapper relationWrapper;
            List posts;
            List struPosts;
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId) ? "0" : (HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId) ? "1" : null);
            List<OrganPostTreeVo> organTree = this.getOrganizationTree(parentId, organProperty);
            if (HussarUtils.isNotEmpty(organTree)) {
                List struIds = organTree.stream().map(s -> (Long)s.getId()).collect(Collectors.toList());
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStruPost::getStruId, struIds).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                List list = this.sysStruPostService.list((Wrapper)wrapper);
                Map<Long, Long> map = list.stream().collect(Collectors.groupingBy(SysStruPost::getStruId, Collectors.counting()));
                for (OrganPostTreeVo tree : organTree) {
                    Boolean flag = tree.getHasChildren();
                    Long postNum = map.get(tree.getId());
                    boolean postFlag = HussarUtils.isNotEmpty((Object)postNum) && postNum > 0L;
                    tree.setHasChildren(Boolean.valueOf(flag != false || postFlag));
                }
                result.addAll(organTree);
            }
            if (!HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId) && HussarUtils.isNotEmpty((Object)(struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)parentId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")))) && HussarUtils.isNotEmpty((Object)(posts = this.sysPostMapper.selectList((Wrapper)(relationWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysPost::getId, postIds = struPosts.stream().map(SysStruPost::getPostId).distinct().collect(Collectors.toList())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByAsc(SysPost::getPostOrder)))))) {
                ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
                for (SysPost post : posts) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getId());
                    vo.setLabel(post.getPostName());
                    vo.setParentId((Serializable)parentId);
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        } else {
            ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            List<PostVo> postList = this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
            if (HussarUtils.isNotEmpty(postList)) {
                for (PostVo post : postList) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getPostId());
                    vo.setLabel(post.getPostName());
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        }
        return HussarTreeParser.getTreeList(result);
    }

    public List<PostBasicVo> getPostInfoByIds(List<Long> postIds) {
        ArrayList<PostBasicVo> result = new ArrayList<PostBasicVo>();
        if (HussarUtils.isEmpty(postIds)) {
            return result;
        }
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysPost::getId, postIds);
        wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List posts = this.sysPostMapper.selectList((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)posts)) {
            for (SysPost post : posts) {
                PostBasicVo vo = new PostBasicVo();
                vo.setPostId(post.getId());
                vo.setPostName(post.getPostName());
                result.add(vo);
            }
        }
        return result;
    }

    private List<OrganPostTreeVo> getOrganizationTree(Long parentId, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENT_ID, parentId);
        queryParams.put(ORGAN_PROPERTY, organProperty);
        return this.sysStruMapper.searchOrganTree(queryParams);
    }

    public List<OrganPostTreeVo> organPostSearch(String name) {
        ArrayList<OrganPostTreeVo> organPostTreeVoList = new ArrayList<OrganPostTreeVo>();
        List sysPosts = this.sysPostMapper.selectList((Wrapper)new LambdaQueryWrapper().like(SysPost::getPostName, (Object)name));
        if (HussarUtils.isNotEmpty((Object)sysPosts)) {
            Map<Long, String> postMaps = sysPosts.stream().collect(Collectors.toMap(SysPost::getId, SysPost::getPostName));
            List<Long> postIds = this.wrapPostInfo(postMaps, organPostTreeVoList);
            this.wrapOrganPostInfo(postIds, organPostTreeVoList);
        }
        List organPostTreeVos = HussarTreeParser.getTreeList(organPostTreeVoList);
        for (OrganPostTreeVo organPostTreeVo : organPostTreeVos) {
            this.sysRolesService.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organPostTreeVo);
        }
        return organPostTreeVos;
    }

    public List<OrganPostTreeVo> lazyLoadOrganPostTreeWithUserDept(Long parentId) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        Long deptId = currentUser.getDeptId();
        Set fileredStruIds = new HashSet();
        Long rootId = this.sysStruMapper.getStruRootId(deptId);
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo filteredStruInfo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            fileredStruIds = filteredStruInfo.getFilteredStruIds();
            SysStru closestUnitStru = filteredStruInfo.getClosestUnitStru();
            if (parentId.equals(rootId)) {
                parentId = closestUnitStru.getParentId();
            }
        }
        AssertUtil.isNotNull((Object)parentId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAMETERS.getMessage()));
        List<Object> result = new ArrayList();
        if (!HussarUtils.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
            List postIds;
            LambdaQueryWrapper relationWrapper;
            List posts;
            List struPosts;
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId) ? "0" : (HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId) ? "1" : null);
            List<OrganPostTreeVo> organTree = this.getOrganizationTree(parentId, organProperty);
            if (HussarUtils.isNotEmpty(organTree)) {
                List struIds = organTree.stream().map(s -> (Long)s.getId()).collect(Collectors.toList());
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStruPost::getStruId, struIds).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                List list = this.sysStruPostService.list((Wrapper)wrapper);
                Map<Long, Long> map = list.stream().collect(Collectors.groupingBy(SysStruPost::getStruId, Collectors.counting()));
                for (OrganPostTreeVo tree : organTree) {
                    Boolean flag = tree.getHasChildren();
                    Long postNum = map.get(tree.getId());
                    boolean postFlag = HussarUtils.isNotEmpty((Object)postNum) && postNum > 0L;
                    tree.setHasChildren(Boolean.valueOf(flag != false || postFlag));
                }
                result.addAll(organTree);
            }
            if (!HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId) && HussarUtils.isNotEmpty((Object)(struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)parentId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")))) && HussarUtils.isNotEmpty((Object)(posts = this.sysPostMapper.selectList((Wrapper)(relationWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysPost::getId, postIds = struPosts.stream().map(SysStruPost::getPostId).distinct().collect(Collectors.toList())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByAsc(SysPost::getPostOrder)))))) {
                ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
                for (SysPost post : posts) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getId());
                    vo.setLabel(post.getPostName());
                    vo.setParentId((Serializable)parentId);
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        } else {
            ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            List<PostVo> postList = this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
            if (HussarUtils.isNotEmpty(postList)) {
                for (PostVo post : postList) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getPostId());
                    vo.setLabel(post.getPostName());
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        }
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            Set finalFileredStruIds = fileredStruIds;
            result = result.stream().filter(organPostTreeVo -> {
                if (organPostTreeVo.getTypes().equals("organ")) {
                    return finalFileredStruIds.contains(organPostTreeVo.getId());
                }
                return finalFileredStruIds.contains(organPostTreeVo.getParentId());
            }).collect(Collectors.toList());
            result.forEach(organPostTreeVo -> {
                if (!(finalFileredStruIds.contains(organPostTreeVo.getParentId()) || OrganConstants.STRU_IN_ROOT_ID.equals(organPostTreeVo.getId()) || OrganConstants.STRU_OUT_ROOT_ID.equals(organPostTreeVo.getId()))) {
                    organPostTreeVo.setParentId((Serializable)rootId);
                }
            });
        }
        return HussarTreeParser.getTreeList(result);
    }

    public List<OrganPostTreeVo> organPostSearchWithUserDept(String name) {
        SecurityUser currentUser;
        Long deptId;
        List<Object> organPostTreeVoList = new ArrayList<OrganPostTreeVo>();
        List sysPosts = this.sysPostMapper.selectList((Wrapper)new LambdaQueryWrapper().like(SysPost::getPostName, (Object)name));
        if (HussarUtils.isNotEmpty((Object)sysPosts)) {
            Map<Long, String> postMaps = sysPosts.stream().collect(Collectors.toMap(SysPost::getId, SysPost::getPostName));
            List<Long> postIds = this.wrapPostInfo(postMaps, organPostTreeVoList);
            this.wrapOrganPostInfo(postIds, organPostTreeVoList);
        }
        if (HussarUtils.isNotEmpty((Object)(deptId = (currentUser = BaseSecurityUtil.getUser()).getDeptId()))) {
            StruFilteredVo filteredStruInfo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            Set fileredStruIds = filteredStruInfo.getFilteredStruIds();
            SysStru sysStru = filteredStruInfo.getClosestUnitStru();
            Long rootId = this.sysStruMapper.getStruRootId(deptId);
            organPostTreeVoList = organPostTreeVoList.stream().filter(organPostTreeVo -> {
                if (organPostTreeVo.getTypes().equals("organ")) {
                    return fileredStruIds.contains(organPostTreeVo.getId()) || rootId.equals(organPostTreeVo.getId());
                }
                return fileredStruIds.contains(organPostTreeVo.getParentId());
            }).collect(Collectors.toList());
            organPostTreeVoList.forEach(organPostTreeVo -> {
                if (((Long)organPostTreeVo.getId()).equals(sysStru.getId())) {
                    organPostTreeVo.setParentId((Serializable)rootId);
                }
            });
        }
        List organPostTreeVos = HussarTreeParser.getTreeList(organPostTreeVoList);
        for (OrganPostTreeVo organPostTreeVo2 : organPostTreeVos) {
            this.sysRolesService.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organPostTreeVo2);
        }
        return organPostTreeVos;
    }

    private List<Long> wrapPostInfo(Map<Long, String> postMaps, List<OrganPostTreeVo> organPostTreeVoList) {
        ArrayList<Long> postIds = new ArrayList<Long>();
        for (Map.Entry<Long, String> postMap : postMaps.entrySet()) {
            List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postMap.getKey()));
            if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
                List struIds = sysStruPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
                for (Long struId : struIds) {
                    OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                    organPostTreeVo.setId((Serializable)postMap.getKey());
                    organPostTreeVo.setLabel(postMap.getValue());
                    organPostTreeVo.setParentId((Serializable)struId);
                    organPostTreeVo.setTypes("post");
                    organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                    organPostTreeVoList.add(organPostTreeVo);
                }
            } else {
                OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                organPostTreeVo.setId((Serializable)postMap.getKey());
                organPostTreeVo.setLabel(postMap.getValue());
                organPostTreeVo.setParentId((Serializable)Long.valueOf(13L));
                organPostTreeVo.setTypes("post");
                organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                organPostTreeVoList.add(organPostTreeVo);
                OrganPostTreeVo organPostTreeVo3 = new OrganPostTreeVo();
                organPostTreeVo3.setId((Serializable)Long.valueOf(13L));
                organPostTreeVo3.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_ASSOCIATED_WITH_ORGAN.getMessage()));
                organPostTreeVo3.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo3);
            }
            postIds.add(postMap.getKey());
        }
        return postIds;
    }

    private void wrapOrganPostInfo(List<Long> postIds, List<OrganPostTreeVo> organPostTreeVoList) {
        List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getPostId, postIds));
        if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
            List<Long> struIds = sysStruPosts.stream().map(SysStruPost::getStruId).distinct().collect(Collectors.toList());
            List<Long> finalStruIds = this.queryOrganizationManager.getParentStruByIds(struIds);
            List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.sysStruMapper.getOrganTreeOnlyOrgan(finalStruIds, null);
            List organPostTreeVos = HussarUtils.copy(organUserTreeOnlyOrgan, OrganPostTreeVo.class);
            ArrayList rootIds = Lists.newArrayListWithCapacity((int)2);
            if (organUserTreeOnlyOrgan.stream().anyMatch(o -> HussarUtils.equals((Object)o.getParentId(), (Object)Constants.ROOT_NODE_ID))) {
                rootIds.add(Constants.ROOT_NODE_ID);
            }
            if (organUserTreeOnlyOrgan.stream().anyMatch(o -> HussarUtils.equals((Object)o.getParentId(), (Object)Constants.OUT_STRU_NODE_ID))) {
                rootIds.add(Constants.OUT_STRU_NODE_ID);
            }
            if (HussarUtils.isNotEmpty((Object)rootIds)) {
                List<OrganUserTreeVo> rootOrganUsers = this.sysStruMapper.getOrganTreeOnlyOrgan(rootIds, null);
                List rootOrganPosts = HussarUtils.copy(rootOrganUsers, OrganPostTreeVo.class);
                organPostTreeVoList.addAll(rootOrganPosts);
            }
            organPostTreeVoList.addAll(organPostTreeVos);
        }
    }
}

