/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.adapter.user.IHussarBaseUserBoAdapter;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.integration.authentication.support.AbstractUserAuthorizationChangeReporter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.service.impl.roleUserAuthorizationChangeReporter")
public class RoleUserAuthorizationChangeReporter
extends AbstractUserAuthorizationChangeReporter {
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    IHussarBaseUserBoAdapter hussarBaseUserBoAdapter;
    private static final String ORGAN = "organ";
    private static final String POST = "post";
    private static final String USER = "user";
    private static final String FUNCTION = "function";
    private static final String RESOURCE = "resource";
    private static final String ROLE = "role";
    private static final String ROLE_BATCH = "roleBatch";

    public List<Long> getUserIds(Object ... objects) {
        String type = (String)objects[0];
        List<Object> users = new ArrayList();
        HussarCacheUtil.evictKeysLike((String)"hussar_user_cache", (String)"user_id_");
        if (HussarUtils.equals((Object)type, (Object)POST)) {
            List postIds = (List)objects[1];
            if (HussarUtils.isEmpty((Object)postIds)) {
                return new ArrayList<Long>();
            }
            users = this.hussarBaseUserBoAdapter.getUsersByPostIds(postIds);
        }
        if (HussarUtils.equals((Object)type, (Object)ORGAN)) {
            List struIds = (List)objects[1];
            if (HussarUtils.isEmpty((Object)struIds)) {
                return new ArrayList<Long>();
            }
            users = this.sysUsersMapper.getUsersByStruIds(struIds);
        }
        if (HussarUtils.equals((Object)type, (Object)USER)) {
            List userIds = (List)objects[1];
            return userIds;
        }
        if (HussarUtils.equals((Object)type, (Object)FUNCTION) || HussarUtils.equals((Object)type, (Object)RESOURCE) || HussarUtils.equals((Object)type, (Object)ROLE)) {
            Long roleId = (Long)objects[1];
            ArrayList<Long> roleIds = new ArrayList<Long>();
            roleIds.add(roleId);
            if (HussarUtils.isEmpty(roleIds)) {
                return new ArrayList<Long>();
            }
            users = this.hussarBaseUserBoAdapter.getUserInfoByRoleId(roleIds);
        }
        if (HussarUtils.equals((Object)type, (Object)ROLE_BATCH)) {
            List roleIds = (List)objects[1];
            if (HussarUtils.isEmpty((Object)roleIds)) {
                return new ArrayList<Long>();
            }
            users = this.hussarBaseUserBoAdapter.getUserInfoByRoleId(roleIds);
        }
        return users.stream().map(UserVo::getId).distinct().collect(Collectors.toList());
    }
}

