/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.manager.ApprovedAuditOrganizationManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonOrganizationAuditManager;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approvedAuditOrganizationManagerImpl")
public class ApprovedAuditOrganizationManagerImpl
extends CommonOrganizationAuditManager
implements ApprovedAuditOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovedAuditOrganizationManagerImpl.class);

    @Override
    @HussarTransactional
    public String approved(Long id) {
        boolean flag;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STRU_AUDIT_PASS.getMessage()), (Object)id);
        SysStruAudit strumAudit = this.getSysStruAuditByStruid(id);
        Long organId = strumAudit.getOrganId();
        String inUse = strumAudit.getInUse();
        if ("3".equals(inUse) || "4".equals(inUse)) {
            SysStru sysStru = new SysStru();
            CopyPropertieUtils.copyProperties((Object)sysStru, (Object)strumAudit);
            sysStru.setId(strumAudit.getRealStruId());
            flag = this.doAuditDeleteAndChange(strumAudit, sysStru, inUse);
        } else {
            flag = this.doAuditAddAndUpdate(strumAudit, organId, inUse);
        }
        AssertUtil.isTrue((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_FAIL.getMessage()));
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.THROUGH_SUCCESS.getMessage());
    }

    private boolean doAuditAddAndUpdate(SysStruAudit struAudit, Long organId, String inUse) {
        boolean stateFlag;
        boolean flag = true;
        SysOrganAudit sysOrganAudit = (SysOrganAudit)this.sysOrganAuditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getId, (Object)organId));
        SysStru sysStru = new SysStru();
        CopyPropertieUtils.copyProperties((Object)sysStru, (Object)struAudit);
        sysStru.setId(struAudit.getRealStruId());
        if (!"1".equals(inUse)) {
            sysStru.setOrganId(sysOrganAudit.getRealOrganId());
        }
        if ("1".equals(inUse)) {
            int level = sysStru.getStruLevel();
            if (level > 1) {
                SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
                pSysStru.setIsLeaf("N");
                this.sysStruMapper.updateById(pSysStru);
            }
            sysStru.setId(struAudit.getId());
            struAudit.setRealStruId(struAudit.getId());
        }
        SysOrgan sysOrgan = new SysOrgan();
        CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysOrganAudit);
        this.processExtendColumnData(sysOrgan);
        if ("2".equals(inUse)) {
            sysOrgan.setId(sysOrganAudit.getRealOrganId());
            SysOrgan tempOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysOrgan.getId());
            if (!Objects.equals(sysOrganAudit.getOrganName().trim(), tempOrgan.getOrganName())) {
                String currentFname = tempOrgan.getOrganFname();
                String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + sysOrganAudit.getOrganName().trim();
                HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
                queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)tempOrgan.getOrganFcode()));
                queryOrgParams.put("organId", tempOrgan.getId());
                queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
                List<SysOrgan> sysOrgans = this.sysOrganMapper.getSubOrganByFcode(queryOrgParams);
                for (SysOrgan temp : sysOrgans) {
                    temp.setOrganFname(temp.getOrganFname().replaceFirst(Pattern.quote(currentFname), newFname));
                }
                this.sysOrganService.updateBatchById(sysOrgans);
            }
        } else {
            sysOrgan.setId(sysStru.getOrganId());
        }
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan, !"2".equals(inUse));
        boolean struFlag = this.sysStruService.saveOrUpdate((Object)sysStru);
        flag &= struFlag;
        boolean organFlag = this.sysOrganService.saveOrUpdate((Object)sysOrgan);
        flag &= organFlag;
        SysOfficeAudit sysOfficeAudit = (SysOfficeAudit)this.sysOfficeAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOfficeAudit::getStruId, (Object)struAudit.getId()));
        if (ToolUtil.isNotEmpty((Object)sysOfficeAudit)) {
            SysOffice sysOffice = new SysOffice();
            CopyPropertieUtils.copyProperties((Object)sysOffice, (Object)sysOfficeAudit);
            sysOffice.setStruId(sysStru.getId());
            sysOffice.setId(sysOfficeAudit.getRealOfficeId());
            boolean officeFlag = this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            flag &= officeFlag;
        }
        struAudit.setState("1");
        boolean bl = stateFlag = this.sysStruAuditMapper.updateById(struAudit) > 0;
        if ((flag &= stateFlag) && "1".equals(inUse)) {
            this.organChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStru.getId(), sysOrgan, null});
        }
        if (flag && "2".equals(inUse)) {
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysStru.getId(), sysOrgan, null});
        }
        return flag;
    }

    private boolean doAuditDeleteAndChange(SysStruAudit struAudit, SysStru sysStru, String inUse) {
        boolean flag2;
        boolean flag1 = false;
        if ("4".equals(inUse)) {
            AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
            ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
            Integer struOrder = orderTree.get();
            this.transferOrganizationManager.organizationChange(struAudit.getRealStruId(), struAudit.getParentId(), struAudit.getStruType(), struOrder);
            flag1 = true;
        }
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(struAudit.getRealStruId());
        if ("3".equals(inUse)) {
            flag1 = this.delOrganByStruId(sysStru.getId());
        }
        struAudit.setState("1");
        boolean bl = flag2 = this.sysStruAuditMapper.updateById(struAudit) > 0;
        if ("3".equals(inUse)) {
            this.sysStruAuditMapper.updateStates(struAudit.getRealStruId());
            this.organChangeNotify.notify(DataChangeType.DELETE, new Object[]{struAudit.getRealStruId(), sysOrgan, null});
        }
        if ("4".equals(inUse)) {
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{struAudit.getRealStruId(), sysOrgan, null});
        }
        return flag1 && flag2;
    }

    private void processExtendColumnData(SysOrgan sysOrgan) {
        if (HussarUtils.isNotEmpty((Object)this.hussarExpansionProperties) && this.hussarExpansionProperties.isEnable() && HussarUtils.isNotEmpty((Object)sysOrgan.getExpansionMap())) {
            HashMap finalExpansionMap = new HashMap();
            Map currentExpansionMap = sysOrgan.getExpansionMap();
            String prefix = this.hussarExpansionProperties.getPrefixProperty();
            for (String key : currentExpansionMap.keySet()) {
                finalExpansionMap.put(prefix + key, currentExpansionMap.get(key));
            }
            sysOrgan.setExpansionMap(finalExpansionMap);
        }
    }
}

