/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dto.SwitchIdentityDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u8eab\u4efd\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseUserIdentityController")
@RequestMapping(value={"/hussarBase/authorization/permit/identity"})
public class HussarBaseUserIdentityController {
    @Autowired
    private IHussarBaseUserIdentityService hussarBaseUserIdentityService;
    @Resource
    private ILocalHussarBaseUserIdentityService localHussarBaseUserIdentityService;

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u8eab\u4efd", notes="\u5207\u6362\u7528\u6237\u8eab\u4efd")
    @PostMapping(value={"/switchUserIdentity"})
    @AuditLog(moduleName="\u7528\u6237\u8eab\u4efd\u7ba1\u7406", eventDesc="\u5207\u6362\u7528\u6237\u8eab\u4efd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> switchUserIdentity(@ApiParam(value="\u5207\u6362\u7528\u6237\u8eab\u4efdDto") @RequestBody SwitchIdentityDto switchIdentityDto) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        switchIdentityDto.setUserDetails(userDetails);
        switchIdentityDto.setAppId(Long.valueOf(1L));
        userDetails = this.hussarBaseUserIdentityService.switchUserIdentity(switchIdentityDto);
        this.localHussarBaseUserIdentityService.updateSecurityUser(userDetails);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SWITCH_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868")
    @GetMapping(value={"/getUserOrganPostList"})
    @AuditLog(moduleName="\u7528\u6237\u8eab\u4efd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserOrganPostVo>> getUserOrganPostList() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        }
        Long userId = user.getId();
        return ApiResponse.success((Object)this.hussarBaseUserIdentityService.getUserOrganPost(userId));
    }
}

