/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditResDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourcesAuditService;
import com.jxdinfo.hussar.authorization.permit.vo.AuditResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u5ba1\u6838"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseResourceAuditController")
@RequestMapping(value={"/hussarBase/authorization/resourceAudit"})
public class HussarBaseResourceAuditController {
    @Resource
    private IHussarBaseResourcesAuditService hussarBaseResourcesAuditService;

    @ApiOperation(value="\u8d44\u6e90\u5ba1\u6838\u5217\u8868", notes="\u8d44\u6e90\u5ba1\u6838\u5217\u8868")
    @GetMapping(value={"/resourceAuditList"})
    @AuditLog(moduleName="\u8d44\u6e90\u5ba1\u6838", eventDesc="\u8d44\u6e90\u5ba1\u6838\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:authorization:resourceAudit:resourceAuditList"})
    public ApiResponse<Page<ResourceAuditVo>> resourceAuditList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u8d44\u6e90\u5ba1\u6838dto") QueryAuditResDto queryAuditResDto) {
        return this.hussarBaseResourcesAuditService.resourceAuditList(pageInfo, queryAuditResDto);
    }

    @ApiOperation(value="\u8d44\u6e90\u5ba1\u6838\u901a\u8fc7", notes="\u8d44\u6e90\u5ba1\u6838\u901a\u8fc7")
    @PostMapping(value={"/resourcePass"})
    @AuditLog(moduleName="\u8d44\u6e90\u5ba1\u6838", eventDesc="\u8d44\u6e90\u5ba1\u6838\u901a\u8fc7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:authorization:resourceAudit:resourcePass"})
    public ApiResponse<Boolean> resourcePass(@ApiParam(value="\u8d44\u6e90\u5ba1\u6838id") @RequestBody Long auditId) {
        return this.hussarBaseResourcesAuditService.pass(auditId);
    }

    @ApiOperation(value="\u8d44\u6e90\u5ba1\u6838\u9a73\u56de", notes="\u8d44\u6e90\u5ba1\u6838\u9a73\u56de")
    @PostMapping(value={"/resourceReject"})
    @AuditLog(moduleName="\u8d44\u6e90\u5ba1\u6838", eventDesc="\u8d44\u6e90\u5ba1\u6838\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:authorization:resourceAudit:resourceReject"})
    public ApiResponse<Boolean> resourceReject(@ApiParam(value="\u8d44\u6e90\u5ba1\u6838id") @RequestBody Long auditId) {
        return this.hussarBaseResourcesAuditService.reject(auditId);
    }

    @ApiOperation(value="\u67e5\u770b\u8d44\u6e90\u5ba1\u6838\u4fe1\u606f\u8be6\u60c5", notes="\u67e5\u770b\u8d44\u6e90\u5ba1\u6838\u4fe1\u606f\u8be6\u60c5")
    @GetMapping(value={"/getResourceAuditDetail"})
    @AuditLog(moduleName="\u8d44\u6e90\u5ba1\u6838", eventDesc="\u67e5\u770b\u8d44\u6e90\u5ba1\u6838\u4fe1\u606f\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:authorization:resourceAudit:getResourceAuditDetail"})
    public ApiResponse<AuditResourceDetailVo> getResourceAuditDetail(@ApiParam(value="\u8d44\u6e90\u5ba1\u6838id") @RequestParam Long auditId) {
        return this.hussarBaseResourcesAuditService.getResourceAuditDetail(auditId);
    }
}

