/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganTypeDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTypeTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.common.annotion.NoRepeatMethod;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/sysOrganFront"})
public class SysOrganTypeFrontController
extends HussarBaseController<SysOrganType, ISysOrganTypeService> {
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u5206\u9875", notes="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u5206\u9875")
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"sysOrganFront:getList"})
    @NoRepeatMethod(timeout=50L, autoCompletion=false)
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysOrganTypeVo>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysOrganTypeVo> page, @ApiParam(value="\u7ec4\u7ec7\u7ed3\u6784\u7c7b\u578b") SysOrganType sysOrganType) {
        sysOrganType.setTypeName(ToolUtil.isNotEmpty((Object)sysOrganType.getTypeName()) ? sysOrganType.getTypeName().replace("%", "\\%").replace("_", "\\_") : "");
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrganTypeList(page, sysOrganType));
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", notes="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b")
    @GetMapping(value={"/orgTypeOption"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysOrganType>> orgTypeOption() {
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrgTypeOption());
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f")
    @CheckPermission(value={"sysOrganFront:selectOrg"})
    @GetMapping(value={"selectOrg"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganType> selectOrg(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801") @RequestParam String orgCode) {
        if (ToolUtil.isEmpty((Object)orgCode)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
        }
        return ApiResponse.success((Object)this.iSysOrganTypeService.getById((Serializable)Long.valueOf(Long.parseLong(orgCode))));
    }

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b", notes="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b")
    @PostMapping(value={"/add"})
    @CheckPermission(value={"sysOrganFront:add"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u65b0\u589e\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse add(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b\u5bf9\u8c61") @RequestBody SysOrganType sysOrganType) {
        this.iSysOrganTypeService.checkOrganTypeInfo((Object)sysOrganType, "add");
        return this.iSysOrganTypeService.saveSysOrganType(sysOrganType);
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", notes="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b")
    @PostMapping(value={"/edit"})
    @CheckPermission(value={"sysOrganFront:edit"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse edit(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578bdto") @RequestBody SysOrganTypeDto sysOrganTypeDto) {
        this.iSysOrganTypeService.checkOrganTypeInfo((Object)sysOrganTypeDto, "edit");
        return this.iSysOrganTypeService.updateSysOrganType(sysOrganTypeDto);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b", notes="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b")
    @PostMapping(value={"/delByIds"})
    @CheckPermission(value={"sysOrganFront:delByIds"})
    @CheckSafe
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delByIds(@ApiParam(value="\u5220\u9664\u7684\u7ec4\u7ec7\u7c7b\u578bid\u5b57\u7b26\u4e32") @RequestBody String ids) {
        ids = ids.replace("\"", "");
        return this.iSysOrganTypeService.deleteByIds(ids);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", notes="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4")
    @GetMapping(value={"/getOrgTypeExcludeStaff"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0b\u62c9\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysOrganType>> getOrgTypeExcludeStaff() {
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrgTypeExcludeStaff());
    }

    @ApiOperation(value="\u7c7b\u578b\u7f16\u8f91-\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", notes="\u7c7b\u578b\u7f16\u8f91-\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b")
    @GetMapping(value={"/getEditOrgTypeOption"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u7c7b\u578b\u7f16\u8f91-\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysOrganType>> getEditOrgTypeOption(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801") @RequestParam String organType) {
        if (ToolUtil.isEmpty((Object)organType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
        }
        return ApiResponse.success((Object)this.iSysOrganTypeService.getEditOrgTypeOption(organType));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u6811")
    @GetMapping(value={"/getOrgTypeTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTypeTreeVo>> getOrgTypeTree() {
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrgTypeTree());
    }
}

