/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.post.dto.PostDto;
import com.jxdinfo.hussar.authorization.post.manager.EditPostManager;
import com.jxdinfo.hussar.authorization.post.manager.impl.CommonPostManagerImpl;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.editPostManagerImpl")
public class EditPostManagerImpl
extends CommonPostManagerImpl
implements EditPostManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditPostManagerImpl.class);

    @Override
    public String editPost(PostDto postDto) {
        List organIds = postDto.getOrganIds();
        List userIds = postDto.getUserIds();
        List roleIds = postDto.getRoleIds();
        if (HussarUtils.isNotEmpty((Object)postDto.getOrganTypeCode()) && HussarUtils.isNotEmpty((Object)userIds)) {
            this.checkRelation(postDto);
        }
        SysPost post = this.initialization(postDto);
        return this.processAuditIfNecessary(post, organIds, userIds, roleIds);
    }

    private String processAuditIfNecessary(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isPostAudit()) {
            return this.doProcessPostAudit(post, organIds, userIds, roleIds);
        }
        String msg = this.doProcessPost(post, organIds, userIds, roleIds);
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        return msg;
    }

    private String doProcessPostAudit(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        Long postId = post.getId();
        SysPostAudit sysPostAudit = (SysPostAudit)this.sysPostAuditService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getAuditStatus, (Object)"0")).eq(SysPostAudit::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)sysPostAudit), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
        SysPost oldPost = (SysPost)this.sysPostMapper.selectById(post.getId());
        boolean flag = this.comparePost(post, oldPost);
        if (!flag) {
            SysPostAudit audit = new SysPostAudit();
            BeanUtils.copyProperties((Object)post, (Object)audit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
            audit.setPostId(postId);
            audit.setOperateType("2");
            audit.setAuditStatus("0");
            this.sysPostAuditService.save((Object)audit);
        }
        boolean postFlag = this.doProcessStruPost(organIds, postId, true);
        boolean userFlag = this.doProcessUserPost(userIds, postId, true);
        boolean roleFlag = this.doProcessPostRole(roleIds, postId, true);
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{oldPost});
        if (flag && !userFlag && !roleFlag && !postFlag) {
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    private boolean doProcessPostRole(List<Long> roleIds, Long postId, boolean auditFlag) {
        List<Long> delRoleIdList;
        List oldPostRoleList = this.sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId));
        List<Long> oldRoleIds = oldPostRoleList.stream().map(SysPostRole::getRoleId).collect(Collectors.toList());
        ArrayList<Long> addRoleIdList = new ArrayList();
        if (HussarUtils.isNotEmpty(roleIds)) {
            addRoleIdList = roleIds.stream().filter(item -> !oldRoleIds.contains(item)).collect(Collectors.toList());
            delRoleIdList = oldRoleIds.stream().filter(item -> !roleIds.contains(item)).collect(Collectors.toList());
        } else {
            delRoleIdList = oldRoleIds;
        }
        if (auditFlag) {
            if (HussarUtils.isNotEmpty(addRoleIdList) || HussarUtils.isNotEmpty(delRoleIdList)) {
                List postRoleAudits = this.sysPostRoleAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getAuditStatus, (Object)"0")).eq(SysPostRoleAudit::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)postRoleAudits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ROLE.getMessage()));
            }
            if (HussarUtils.isNotEmpty(roleIds)) {
                this.delPostRole(postId, delRoleIdList, true);
                if (HussarUtils.isNotEmpty(addRoleIdList)) {
                    this.savePostRole(postId, addRoleIdList, true);
                }
            } else {
                this.delPostRole(postId, delRoleIdList, true);
            }
        } else if (HussarUtils.isNotEmpty(roleIds)) {
            this.delPostRole(postId, delRoleIdList, false);
            if (HussarUtils.isNotEmpty(addRoleIdList)) {
                this.savePostRole(postId, addRoleIdList, false);
            }
        } else {
            this.delPostRole(postId, delRoleIdList, false);
        }
        return HussarUtils.isNotEmpty(addRoleIdList) || HussarUtils.isNotEmpty(delRoleIdList);
    }

    private boolean doProcessStruPost(List<Long> struIds, Long postId, boolean auditFlag) {
        List<Long> delStruIdList;
        List<Long> reportStruIds = new ArrayList<Long>(struIds);
        List oldList = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
        List<Long> oldStruIds = oldList.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
        reportStruIds.addAll(oldStruIds);
        reportStruIds = reportStruIds.stream().distinct().collect(Collectors.toList());
        ArrayList<Long> addStruIdList = new ArrayList();
        if (HussarUtils.isNotEmpty(struIds)) {
            addStruIdList = struIds.stream().filter(item -> !oldStruIds.contains(item)).collect(Collectors.toList());
            delStruIdList = oldStruIds.stream().filter(item -> !struIds.contains(item)).collect(Collectors.toList());
        } else {
            delStruIdList = oldStruIds;
        }
        if (auditFlag) {
            if (HussarUtils.isNotEmpty(addStruIdList) || HussarUtils.isNotEmpty(delStruIdList)) {
                List struPostAudits = this.sysStruPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getAuditStatus, (Object)"0")).eq(SysStruPostAudit::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)struPostAudits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ORGAN.getMessage()));
            }
            if (HussarUtils.isNotEmpty(struIds)) {
                this.delStruPost(postId, delStruIdList, true);
                if (HussarUtils.isNotEmpty(addStruIdList)) {
                    this.saveStruPost(postId, addStruIdList, true);
                }
            } else {
                this.delStruPost(postId, delStruIdList, true);
            }
        } else if (HussarUtils.isNotEmpty(struIds)) {
            this.delStruPost(postId, delStruIdList, false);
            if (HussarUtils.isNotEmpty(addStruIdList)) {
                this.saveStruPost(postId, addStruIdList, false);
            }
        } else {
            this.delStruPost(postId, delStruIdList, false);
        }
        return HussarUtils.isNotEmpty(addStruIdList) || HussarUtils.isNotEmpty(delStruIdList);
    }

    private boolean doProcessUserPost(List<Long> userIds, Long postId, boolean auditFlag) {
        List<Long> delUserIdList;
        List<Long> reportUserIds = new ArrayList<Long>(userIds);
        List oldList = this.sysUserPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId));
        List<Long> oldUserIds = oldList.stream().map(SysUserPost::getUserId).collect(Collectors.toList());
        reportUserIds.addAll(oldUserIds);
        reportUserIds = reportUserIds.stream().distinct().collect(Collectors.toList());
        ArrayList<Long> addUserIdList = new ArrayList();
        if (HussarUtils.isNotEmpty(userIds)) {
            addUserIdList = userIds.stream().filter(item -> !oldUserIds.contains(item)).collect(Collectors.toList());
            delUserIdList = oldUserIds.stream().filter(item -> !userIds.contains(item)).collect(Collectors.toList());
        } else {
            delUserIdList = oldUserIds;
        }
        if (auditFlag) {
            if (HussarUtils.isNotEmpty(addUserIdList) || HussarUtils.isNotEmpty(delUserIdList)) {
                List userPostAudits = this.sysUserPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getAuditStatus, (Object)"0")).eq(SysUserPostAudit::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)userPostAudits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_USER_RELATION_EXIST_REVIEW.getMessage()));
            }
            if (HussarUtils.isNotEmpty(userIds)) {
                this.delUserPost(postId, delUserIdList, true);
                if (HussarUtils.isNotEmpty(addUserIdList)) {
                    this.saveUserPost(postId, addUserIdList, true);
                }
            } else {
                this.delUserPost(postId, delUserIdList, true);
            }
        } else {
            if (HussarUtils.isNotEmpty(userIds)) {
                this.delUserPost(postId, delUserIdList, false);
                if (HussarUtils.isNotEmpty(addUserIdList)) {
                    this.saveUserPost(postId, addUserIdList, false);
                }
            } else {
                this.delUserPost(postId, delUserIdList, false);
            }
            this.postUserAuthorizationChangeReporter.report(new Object[]{reportUserIds});
        }
        return HussarUtils.isNotEmpty(addUserIdList) || HussarUtils.isNotEmpty(delUserIdList);
    }

    private String doProcessPost(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        Long postId = post.getId();
        SysPost oldPost = (SysPost)this.sysPostMapper.selectById(post.getId());
        boolean flag = this.comparePost(post, oldPost);
        if (!flag) {
            this.sysPostMapper.updateById(post);
        }
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
        if (HussarUtils.isNotEmpty(organIds)) {
            this.saveStruPost(postId, organIds, false);
        }
        this.doProcessUserPost(userIds, postId, false);
        this.doProcessPostRole(roleIds, postId, false);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    private SysPost initialization(PostDto postDto) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_DTO_INITIALIZE_SYS_PARAM.getMessage()), (Object)JSON.toJSONString((Object)postDto));
        long id = postDto.getPostId();
        SysPost post = (SysPost)this.sysPostMapper.selectById(Long.valueOf(id));
        AssertUtil.isNotNull((Object)post, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_NO_EXIST_POST.getMessage()));
        post.setPostName(StringUtils.trimToEmpty((String)postDto.getPostName()));
        post.setOrganTypeCode(postDto.getOrganTypeCode());
        post.setPostDesc(postDto.getPostDesc());
        return post;
    }

    private boolean comparePost(SysPost newPost, SysPost oldPost) {
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newPost.getPostName()), (Object)StringUtils.trimToEmpty((String)oldPost.getPostName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newPost.getPostCode()), (Object)StringUtils.trimToEmpty((String)oldPost.getPostCode()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newPost.getOrganTypeCode()), (Object)StringUtils.trimToEmpty((String)oldPost.getOrganTypeCode()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newPost.getPostDesc()), (Object)StringUtils.trimToEmpty((String)oldPost.getPostDesc()))) {
            return false;
        }
        return HussarUtils.equals((Object)newPost.getPostOrder(), (Object)oldPost.getPostOrder());
    }

    private void checkRelation(PostDto postDto) {
        List organIds = postDto.getOrganIds();
        AssertUtil.isNotEmpty((Collection)organIds, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_POST_ORGAN_USER.getMessage()));
        List userIds = postDto.getUserIds();
        List struUserList = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, (Collection)userIds)).in(SysStruUser::getStruId, (Collection)organIds));
        Map<Long, List<SysStruUser>> userMap = struUserList.stream().collect(Collectors.groupingBy(SysStruUser::getUserId));
        if (!HussarUtils.equals((Object)userIds.size(), (Object)userMap.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_POST_ORGAN_USER.getMessage()));
        }
    }
}

