/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.AddOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideUserManager;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncUserService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.expansion.core.annotations.ExpansionModelId;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseSyncUserServiceImpl")
@ExpansionModelId(modelId="userStaffExtendColumnInfo")
public class HussarBaseSyncUserServiceImpl
implements IHussarBaseSyncUserService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncUserServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsideUserManager addOutsideUserManager;
    @Autowired
    private AddBatchOutsideUserManager addBatchOutsideUserManager;
    @Autowired
    private EditOutsideUserManager editOutsideUserManager;
    @Autowired
    private EditBatchOutsideUserManager editBatchOutsideUserManager;
    @Autowired
    private DeleteOutsideUserManager deleteOutsideUserManager;
    @Autowired
    private DeleteBatchOutsideUserManager deleteBatchOutsideUserManager;

    @HussarTransactional
    public synchronized R<AddOutsideUserDto> addUser(AddOutsideUserDto user) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideUserManager.addUser(user, false);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_ADD_USER.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    public R<AddOutsideUserDto> addUserWithSecure(AddOutsideUserDto user) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideUserManager.addUser(user, true);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_ADD_USER.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsideUserDto> addBatchUsers(List<AddOutsideUserDto> users) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsideUserManager.addBatchUsers(users, false);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    public R<AddOutsideUserDto> addBatchUsersWithSecure(List<AddOutsideUserDto> users) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsideUserManager.addBatchUsers(users, true);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideUserDto> editUser(EditOutsideUserDto user) {
        R<EditOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideUserManager.editUser(user);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_MODIFY_USER.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideUserDto> editBatchUsers(List<EditOutsideUserDto> users) {
        R<EditOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editBatchOutsideUserManager.editBatchUsers(users);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_USER_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteUser(String userAccount) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideUserManager.deleteUser(userAccount);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public R<String> deleteBatchUsers(List<String> accounts) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideUserManager.deleteBatchUsers(accounts);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOnlyOutsideUserDto> addOnlyUserWithSecure(AddOnlyOutsideUserDto user) {
        R<AddOnlyOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideUserManager.addOnlyUser(user, true);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_ADD_USER.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOnlyOutsideUserDto> editOnlyUser(EditOnlyOutsideUserDto user) {
        R<EditOnlyOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideUserManager.editOnlyUser(user);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_MODIFY_USER.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOnlyUser(String userAccount) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideUserManager.deleteOnlyUser(userAccount);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteLogicalUser(String userAccount) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOGICAL_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOGICAL_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideUserManager.deleteLogicalUser(userAccount);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_USER_LOGICAL_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }
}

