/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.adapter.user.IHussarBaseUserBoAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleData;
import com.jxdinfo.hussar.authorization.permit.dto.SearchUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserOrganFeignDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersAdditionalInfo;
import com.jxdinfo.hussar.authorization.permit.service.ILocalQueryUserMangerService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersAddtionalInfoService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserMobileVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.post.vo.PostVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.vo.OrganPostRoleVo;
import com.jxdinfo.hussar.authorization.relational.vo.UserPostInfoVo;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryUserManagerImpl")
public class QueryUserManagerImpl
extends CommonQueryOrganizationManager
implements QueryUserManager {
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 716665713812840448L, 1450757642371981314L, 716671816189616128L, 1450757642371981314L, 1450757481235202050L, 1450757642371981324L};
    private static final String SOURCE_USER_ID = "sourceUserId";
    private static final String DEP_STRU_ID = "depStruId";
    private static final String ACCOUNT_STATUS = "accountStatus";
    private static final String USER_NAME = "userName";
    private static final String ACCOUNT_PROPERTY = "accountProperty";
    private static final String STRU_FID = "struFid";
    private static final String ESCAPE_SYMBOL = "escapeSymbol";
    private static final String CONTAIN_SYS = "containSys";
    private static final String ACCOUNT_STATE = "account_state";
    private static final String ACCOUNT__PROPERTY = "account_property";
    @Autowired
    @Lazy
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDicRefService dicRefService;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IHussarBaseUserBoAdapter hussarBaseUserBoAdapter;
    @Autowired
    private ILocalQueryUserMangerService localQueryUserMangerService;
    @Autowired
    private ISysUsersAddtionalInfoService sysUsersAddtionalInfoService;

    @Override
    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return this.hussarBaseUserBoAdapter.searchUsers(pageInfo, queryUserDto);
    }

    @Override
    public Page<SearchUserVo> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        String accountStatus;
        Object[] arr;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryCopyRoleUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryCopyRoleUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(this.hussarSystemIdProperties.getInnerOrganNodeId(), depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struFid = struTemp.getStruFid();
        }
        if (ArrayUtils.contains((Object[])(arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()}), (Object)(accountStatus = queryCopyRoleUserDto.getAccountStatus()))) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryCopyRoleUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (UserStatus.LOCKED.getCode().equals(accountStatus) && HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put(SOURCE_USER_ID, queryCopyRoleUserDto.getSourceUserId());
        queryParams.put(DEP_STRU_ID, depStruId.get());
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserAccount()));
        queryParams.put(ACCOUNT_STATUS, StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountStatus()));
        queryParams.put(USER_NAME, StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserName()));
        queryParams.put(ACCOUNT_PROPERTY, StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountProperty()));
        queryParams.put(STRU_FID, StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchCopyRoleUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<SysUsers> selectUsersByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getEmployeeId, struIds));
    }

    @Override
    public List<SysUsers> selectUsersByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, ids));
    }

    @Override
    public Page<SearchUserVo> unRelateStaffUserList(PageInfo pageInfo, QueryUserDto queryUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryUserDto.getUserAccount()));
        queryParams.put(USER_NAME, StringUtils.trimToEmpty((String)queryUserDto.getUserName()));
        if (HussarUtils.equals((Object)CONTAIN_SYS, (Object)queryUserDto.getContainSys())) {
            queryParams.put(CONTAIN_SYS, CONTAIN_SYS);
        } else {
            queryParams.put(CONTAIN_SYS, "0");
        }
        ArrayList<Long> staffIdList = new ArrayList<Long>();
        staffIdList.add(-1L);
        Long staffId = queryUserDto.getStaffId();
        if (HussarUtils.isNotEmpty((Object)staffId)) {
            staffIdList.add(staffId);
        }
        queryParams.put("staffIdList", staffIdList);
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUnRelateStaffUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<UserVo> getUserByPostId(Long postId) {
        if (HussarUtils.isNotEmpty((Object)postId)) {
            List sysUserPosts = this.sysUserPostMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            List<Long> userIds = sysUserPosts.stream().map(SysUserPost::getUserId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(userIds)) {
                return this.sysUsersMapper.getUserByIds(userIds);
            }
            return new ArrayList<UserVo>();
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_ID_NOT_FIND.getMessage()));
    }

    @Override
    public Page<SearchUserVo> postUserList(PageInfo pageInfo, String organTypeCode, List<Long> organIds, String userName, String userAccount) {
        Page searchUserVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.isNotEmpty((Object)organTypeCode)) {
            List sysStruUsers;
            List userIds;
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
            queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)userAccount));
            queryParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)userName));
            if ("common".equals(organTypeCode)) {
                List<SearchUserVo> userVos = this.sysUsersMapper.selectUserList((Page<SearchUserVo>)searchUserVoPage, queryParams);
                searchUserVoPage.setRecords(userVos);
            } else if (HussarUtils.isNotEmpty(organIds) && HussarUtils.isNotEmpty(userIds = (sysStruUsers = this.sysStruUserMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')))).stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList()))) {
                queryParams.put("userIds", userIds);
                List<SearchUserVo> userVos = this.sysUsersMapper.selectUserList((Page<SearchUserVo>)searchUserVoPage, queryParams);
                searchUserVoPage.setRecords(userVos);
            }
        }
        return searchUserVoPage;
    }

    @Override
    public Page<SearchUserTreeVo> searchUser(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        return this.hussarBaseUserBoAdapter.searchUser(pageInfo, searchOrganUserDto);
    }

    @Override
    public Page<SearchUserTreeVo> searchUserWithUserDept(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        return this.hussarBaseUserBoAdapter.searchUserWithUserDept(pageInfo, searchOrganUserDto);
    }

    @Override
    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        return this.hussarBaseUserBoAdapter.getUsersByOrganUser(organIds, userIds);
    }

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        return this.hussarBaseUserBoAdapter.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
    }

    @Override
    public Page<ResetSecureUserVo> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        Long depStruId = null;
        if (currentUser.isGradeadmin()) {
            depStruId = currentUser.getDeptId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId);
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struFid = struTemp.getStruFid();
        } else {
            queryParams.put(CONTAIN_SYS, "1");
        }
        String userAccount = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserName());
        String mail = StringUtils.trimToEmpty((String)resetSecureUserDto.getMail());
        String mobile = StringUtils.trimToEmpty((String)resetSecureUserDto.getMobile());
        queryParams.put(ESCAPE_SYMBOL, SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)userAccount));
        queryParams.put(USER_NAME, SqlQueryUtil.transferSpecialChar((String)userName));
        queryParams.put("mail", SqlQueryUtil.transferSpecialChar((String)mail));
        queryParams.put("mobile", SqlQueryUtil.transferSpecialChar((String)mobile));
        queryParams.put(STRU_FID, StringUtils.trimToNull((String)struFid));
        if (!ArrayUtils.contains((Object[])ADMINS, (Object)currentUser.getId())) {
            ArrayList<Long> adminList = new ArrayList<Long>(Arrays.asList(ADMINS));
            queryParams.put("adminList", adminList);
        } else {
            queryParams.put("adminList", null);
        }
        List userInfoList = this.sysUsersService.searchResetSecureUserVo(page, currentUser.getConnName(), queryParams);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<UserTreeVo> lazyLoadingUserTree(Long parentId, String organProperty) {
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.getUserTree(parentId, organProperty);
        this.fillUserPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<UserTreeVo> getOrderUserTree(Long parentId) {
        HashMap<String, Long> queryParams = new HashMap<String, Long>();
        queryParams.put("parentId", parentId);
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.sysUsersMapper.getUserByDepartment(parentId);
        UserTreeVo root = new UserTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setIcon(organizationTreeVo.getIcon());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<UserTreeVo> backUserTree(Long id) {
        List<OrganizationTreeVo> organizations = this.queryOrganizationManager.backOrganizationTree(id);
        return this.convert(organizations);
    }

    private List<UserTreeVo> convert(List<OrganizationTreeVo> children) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        if (HussarUtils.isNotEmpty(children)) {
            List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
            for (OrganizationTreeVo vo : children) {
                UserTreeVo temp = new UserTreeVo();
                temp.setDisabled(vo.getDisabled());
                temp.setStruType(vo.getStruType());
                if (HussarUtils.isNotEmpty((Object)vo.getChildren())) {
                    temp.setChildren(this.convert(vo.getChildren()));
                }
                temp.setId(vo.getId());
                temp.setHasChildren(vo.getHasChildren());
                temp.setIcon(vo.getIcon());
                temp.setLabel(vo.getLabel());
                temp.setParentId(vo.getParentId());
                this.fillSingleUserPermissions(temp, staffRuleList);
                list.add(temp);
            }
        }
        return list;
    }

    @Override
    public UserPartialVo viewUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        UserPartialVo vo = new UserPartialVo();
        vo.setId(user.getId());
        vo.setTotpKey(user.getTotpKey());
        vo.setUserAccount(user.getUserAccount());
        vo.setUserName(user.getUserName());
        vo.setSecurityLevel(user.getSecurityLevel());
        Long staffId = user.getEmployeeId();
        vo.setEmployeeId(staffId);
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)staffId);
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            vo.setStaffName(sysStaff.getName());
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)id));
        List<Long> struIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            struIds = struUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        } else {
            struIds.add(-1L);
        }
        queryParams.put("struIds", struIds);
        List userPosts = this.sysUserPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)id));
        List<Long> postIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)userPosts)) {
            postIds = userPosts.stream().map(SysUserPost::getPostId).collect(Collectors.toList());
        } else {
            postIds.add(-1L);
        }
        queryParams.put("postIds", postIds);
        List<OrganPostRoleVo> organPostRoleVos = this.sysStruRoleMapper.queryOrganPostRoleList(queryParams);
        vo.setSourceRoles(organPostRoleVos);
        this.getOrganPostInfo(id, vo);
        vo.setMaxSessions(user.getMaxSessions());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        if (user.getAccountStatus().equals(UserStatus.CANCEL.getCode())) {
            vo.setAccountStatusName(UserStatus.CANCEL.getMessage());
        } else {
            String accountStatusName = this.dicRefService.getDictLabel(ACCOUNT_STATE, user.getAccountStatus());
            List dicSingleList = this.dicRefService.getDictByType(ACCOUNT_STATE);
            for (DicSingle dicSingle : dicSingleList) {
                if (!dicSingle.getValue().equals(user.getAccountStatus())) continue;
                TranslateUtil.translate((Object)dicSingle, DicSingle::getLabelLangKey, DicSingle::setLabel);
                accountStatusName = dicSingle.getLabel();
                break;
            }
            vo.setAccountStatusName(accountStatusName);
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            String cacheKey = null;
            Iterator iterator = keyList.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                cacheKey = s;
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
                vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
            }
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isNotEmpty((Object)casKeyList)) {
                for (String s : casKeyList) {
                    cacheKey = s;
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                    if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(model.getUserId())) continue;
                    vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
                }
            }
        }
        String accountPropertyName = this.dicRefService.getDictLabel(ACCOUNT__PROPERTY, user.getTypeProperty());
        List dicSingles = this.dicRefService.getDictByType(ACCOUNT__PROPERTY);
        for (DicSingle dicSingle : dicSingles) {
            if (!dicSingle.getValue().equals(user.getTypeProperty())) continue;
            TranslateUtil.translate((Object)dicSingle, DicSingle::getLabelLangKey, DicSingle::setLabel);
            accountPropertyName = dicSingle.getLabel();
            break;
        }
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        if ("1".equals(user.getTypeProperty())) {
            vo.setStartTime(null);
            vo.setEndTime(null);
        } else {
            vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
            vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        }
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        SysUsersAdditionalInfo sysUsersAdditionalInfo = (SysUsersAdditionalInfo)this.sysUsersAddtionalInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsersAdditionalInfo::getUserId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)sysUsersAdditionalInfo)) {
            vo.setGitToken(sysUsersAdditionalInfo.getGitToken());
        }
        vo.setExpansionMap(user.getExpansionMap());
        return vo;
    }

    private List<RoleData> getCommonUserRoleData(Long id, boolean gradeAdmin) {
        return this.sysUserRoleMapper.getCommonUserRoleData(id, gradeAdmin);
    }

    @Override
    public UserInfolVo loadUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        UserInfolVo vo = new UserInfolVo();
        vo.setId(user.getId());
        vo.setUserSecurityLevel(user.getSecurityLevel());
        vo.setUserAccount(user.getUserAccount());
        vo.setUserName(user.getUserName());
        Long staffId = user.getEmployeeId();
        vo.setEmployeeId(staffId);
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)staffId);
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            vo.setStaffName(sysStaff.getName());
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)id));
        List<Long> struIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            struIds = struUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        } else {
            struIds.add(-1L);
        }
        queryParams.put("struIds", struIds);
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List<Long> postIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)userPosts)) {
            postIds = userPosts.stream().map(SysUserPost::getPostId).collect(Collectors.toList());
        } else {
            postIds.add(-1L);
        }
        queryParams.put("postIds", postIds);
        List<OrganPostRoleVo> organPostRoleVos = this.sysStruRoleMapper.queryOrganPostRoleList(queryParams);
        vo.setSourceRoles(organPostRoleVos);
        this.getOrganPostInfo(id, vo);
        vo.setMaxSessions(user.getMaxSessions());
        vo.setTotpKey(user.getTotpKey());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        vo.setAccountProperty(user.getTypeProperty());
        vo.setAccountStatus(user.getAccountStatus());
        String accountStatusName = this.dicRefService.getDictLabel(ACCOUNT_STATE, user.getAccountStatus());
        List dicSingles = this.dicRefService.getDictByType(ACCOUNT_STATE);
        for (DicSingle dicSingle : dicSingles) {
            if (!dicSingle.getValue().equals(user.getAccountStatus())) continue;
            TranslateUtil.translate((Object)dicSingle, DicSingle::getLabelLangKey, DicSingle::setLabel);
            accountStatusName = dicSingle.getLabel();
            break;
        }
        vo.setAccountStatusName(accountStatusName);
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        Object cacheKey = null;
        for (Object s : keyList) {
            cacheKey = s;
            UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
            if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
            vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
        }
        List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
        if (HussarUtils.isNotEmpty((Object)casKeyList)) {
            for (String s : casKeyList) {
                cacheKey = s;
                UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(model.getUserId())) continue;
                vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
            }
        }
        String accountPropertyName = this.dicRefService.getDictLabel(ACCOUNT__PROPERTY, user.getTypeProperty());
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        if ("1".equals(user.getTypeProperty())) {
            vo.setStartTime(null);
            vo.setEndTime(null);
        } else {
            vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
            vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        }
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        SysUsersAdditionalInfo sysUsersAdditionalInfo = (SysUsersAdditionalInfo)this.sysUsersAddtionalInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsersAdditionalInfo::getUserId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)sysUsersAdditionalInfo)) {
            vo.setGitToken(sysUsersAdditionalInfo.getGitToken());
        }
        vo.setExpansionMap(user.getExpansionMap());
        return vo;
    }

    public List<UserTreeVo> convertUser(List<OrganizationTreeVo> organizations) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        UserTreeVo temp = null;
        List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
        for (OrganizationTreeVo vo : organizations) {
            temp = new UserTreeVo();
            temp.setDisabled(vo.getDisabled());
            temp.setStruType(vo.getStruType());
            List children = vo.getChildren();
            temp.setChildren(this.convertUser(children));
            temp.setId(vo.getId());
            temp.setHasChildren(vo.getHasChildren());
            temp.setIcon(vo.getIcon());
            temp.setLabel(vo.getLabel());
            temp.setParentId(vo.getParentId());
            this.fillSingleUserPermissions(temp, staffRuleList);
            list.add(temp);
        }
        return list;
    }

    private List<UserTreeVo> getUserTree(Long parentId, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        queryParams.put("organProperty", organProperty);
        return this.sysUsersMapper.searchUserTree(queryParams);
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType(ACCOUNT_STATE);
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType(ACCOUNT__PROPERTY);
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean flag = HussarUtils.isNotEmpty((Object)keyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (!flag) continue;
                Optional<String> optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
        }
    }

    @Override
    public List<OrganTreeInitVo> getUsersByOrganIds(List<Long> organIds) {
        List<OrganTreeInitVo> users = this.sysUsersMapper.queryUsersByOrganIds(organIds);
        return users;
    }

    @Override
    public List<OrganTreeInitVo> getChildrenUsersByParentId(Long parentId) {
        return this.sysUsersMapper.queryChildrenUsersByParentId(parentId);
    }

    @Override
    public List<OrganTreeInitVo> queryUpUsersByFidAndLevel(String fid, int defaultLevelNum) {
        return this.sysUsersMapper.queryUpUsersByFidAndLevel(fid, defaultLevelNum);
    }

    @Override
    public List<OrganTreeInitVo> getUsersLikeName(String searchValue) {
        return this.sysUsersMapper.queryUsersLikeName(searchValue);
    }

    @Override
    public Integer getStaffLevelByUserId(Long userId) {
        return this.sysUsersMapper.getStaffLevelByUserId(userId);
    }

    @Override
    public List<OrganTreeInitVo> getUserInfoByUserId(Long userId) {
        return this.sysUsersMapper.queryUserInfoByUserId(userId);
    }

    @Override
    public List<OrganTreeInitVo> getAllChildrenUsers(String fid) {
        return this.sysUsersMapper.queryAllChildrenUsers(fid);
    }

    @Override
    public List<SearchUserMobileVo> getUsersByStruId(Long struId) {
        return this.sysUsersMapper.getUsersByStruId(struId);
    }

    @Override
    public List<SearchUserMobileVo> getUsersByUserIds(List<Long> userIds) {
        List<SearchUserMobileVo> userList = this.sysUsersMapper.getUsersByUserIds(userIds);
        List<SearchUserMobileVo> resultList = userList.stream().collect(Collectors.groupingBy(SearchUserMobileVo::getId)).entrySet().stream().map(entry -> {
            SearchUserMobileVo searchUserMobileVo = new SearchUserMobileVo();
            searchUserMobileVo.setId((Long)entry.getKey());
            searchUserMobileVo.setLabel(((SearchUserMobileVo)((List)entry.getValue()).get(0)).getLabel());
            searchUserMobileVo.setParentId(((List)entry.getValue()).stream().map(SearchUserMobileVo::getParentId).collect(Collectors.joining(",")));
            searchUserMobileVo.setParentName(((List)entry.getValue()).stream().map(SearchUserMobileVo::getParentName).collect(Collectors.joining(",")));
            return searchUserMobileVo;
        }).collect(Collectors.toList());
        return resultList;
    }

    private void getOrganPostInfo(Long id, UserInfolVo vo) {
        List<UserOrganPostVo> organVos = this.sysStruUserMapper.getOrganByUserId(id);
        ArrayList<OrganizationVo> organizationVos = new ArrayList<OrganizationVo>();
        for (UserOrganPostVo organVo : organVos) {
            OrganizationVo organizationVo = new OrganizationVo();
            organizationVo.setId(organVo.getStruId().toString());
            organizationVo.setOrganName(organVo.getOrganName());
            organizationVos.add(organizationVo);
        }
        vo.setOrganization(organizationVos);
        List<UserPostInfoVo> userPostInfoVos = this.sysUserPostMapper.getUserPostByUserId(id);
        if (HussarUtils.isNotEmpty(userPostInfoVos)) {
            ArrayList<PostVo> partPostVo = new ArrayList<PostVo>();
            for (UserPostInfoVo userPost : userPostInfoVos) {
                PostVo postVo = new PostVo();
                postVo.setPostCode(userPost.getPostCode());
                postVo.setPostName(userPost.getPostName());
                postVo.setPostId(userPost.getPostId());
                if (HussarUtils.equals((Object)"0", (Object)userPost.getRelateType())) {
                    vo.setPost(postVo);
                    continue;
                }
                partPostVo.add(postVo);
            }
            vo.setPartPost(partPostVo);
        }
    }

    private void getOrganPostInfo(Long id, UserPartialVo vo) {
        List<UserOrganPostVo> organVos = this.sysStruUserMapper.getOrganByUserId(id);
        ArrayList<OrganizationVo> organizationVos = new ArrayList<OrganizationVo>();
        for (UserOrganPostVo organVo : organVos) {
            OrganizationVo organizationVo = new OrganizationVo();
            organizationVo.setId(organVo.getStruId().toString());
            organizationVo.setOrganName(organVo.getOrganName());
            organizationVos.add(organizationVo);
        }
        vo.setOrganization(organizationVos);
        List<UserPostInfoVo> userPostInfoVos = this.sysUserPostMapper.getUserPostByUserId(id);
        if (HussarUtils.isNotEmpty(userPostInfoVos)) {
            ArrayList<PostVo> partPostVo = new ArrayList<PostVo>();
            for (UserPostInfoVo userPost : userPostInfoVos) {
                PostVo postVo = new PostVo();
                postVo.setPostCode(userPost.getPostCode());
                postVo.setPostName(userPost.getPostName());
                postVo.setPostId(userPost.getPostId());
                if (HussarUtils.equals((Object)"0", (Object)userPost.getRelateType())) {
                    vo.setPost(postVo);
                    continue;
                }
                partPostVo.add(postVo);
            }
            vo.setPartPost(partPostVo);
        }
    }

    @Override
    public Page<SearchUserVo> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        return this.hussarBaseUserBoAdapter.getUserList(pageInfo, userName, userAccount);
    }

    @Override
    public UserStaffVo getUserAndStaffInfo(Long userId) {
        return this.hussarBaseUserBoAdapter.getUserAndStaffInfo(userId);
    }

    @Override
    public List<UserVo> getRoleUser(String roleId) {
        ArrayList<UserVo> result = new ArrayList<UserVo>();
        String[] idStr = roleId == null ? "".split(",") : roleId.split(",");
        Long[] idStrl = new Long[idStr.length];
        for (int i = 0; i < idStr.length; ++i) {
            idStrl[i] = Long.parseLong(idStr[i]);
        }
        List sysUserRoleList = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, Arrays.asList(idStrl))).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List userIds = sysUserRoleList.stream().map(SysUserRole::getUserId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(userIds)) {
            List usersList = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, userIds));
            for (SysUsers user : usersList) {
                UserVo userVo = new UserVo();
                userVo.setId(user.getId());
                userVo.setUserName(user.getUserName());
                userVo.setAccountStatus(user.getAccountStatus());
                result.add(userVo);
            }
        }
        return result;
    }

    @Override
    public List<UserVo> getUsersByStruIds(List<Long> struIds) {
        return this.sysUsersMapper.getUsersByStruIds(struIds);
    }

    @Override
    public List<UserVo> getUsersByOrganUserRole(SearchUserDto searchUserDto) {
        List<UserVo> userListForOrganTwo;
        String type = HussarUtils.isNotBlank((CharSequence)searchUserDto.getType()) ? searchUserDto.getType() : "or";
        List organIds = searchUserDto.getOrganIds();
        List<Long> userIds = searchUserDto.getUserIds();
        List roleIds = searchUserDto.getRoleIds();
        List otherOrganIds = searchUserDto.getOtherOrganIds();
        List<Object> result = new ArrayList<UserVo>();
        if (HussarUtils.isEmpty((Object)organIds) && HussarUtils.isEmpty((Object)userIds) && HussarUtils.isEmpty((Object)roleIds) && HussarUtils.isEmpty((Object)otherOrganIds)) {
            return result;
        }
        List<Object> userListForUser = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            userListForUser = this.sysUsersMapper.getUserByIds(userIds);
        }
        List<Object> userListForOrgan = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            userListForOrgan = this.getUserVoByOrganIds(organIds);
        }
        List<Object> userListForRole = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)roleIds)) {
            userListForRole = this.sysUsersMapper.getUserInfoByRoleId(roleIds);
        }
        if ("or".equals(type)) {
            result.addAll(userListForUser);
            result.addAll(userListForOrgan);
            result.addAll(userListForRole);
            if (HussarUtils.isNotEmpty(result)) {
                result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
            }
        }
        if ("and".equals(type)) {
            ArrayList noEmptyList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)organIds)) {
                noEmptyList.add(userListForOrgan);
            }
            if (HussarUtils.isNotEmpty(userIds)) {
                noEmptyList.add(userListForUser);
            }
            if (HussarUtils.isNotEmpty((Object)roleIds)) {
                noEmptyList.add(userListForRole);
            }
            int size = noEmptyList.size();
            switch (size) {
                case 1: {
                    result = (List)noEmptyList.get(0);
                    break;
                }
                case 2: {
                    List userVos1 = (List)noEmptyList.get(0);
                    List userVos2 = (List)noEmptyList.get(1);
                    if (HussarUtils.isEmpty((Object)userVos1) || HussarUtils.isEmpty((Object)userVos2)) {
                        return result;
                    }
                    Set userIdList = userVos1.stream().map(UserVo::getId).collect(Collectors.toSet());
                    result = userVos2.stream().filter(item -> userIdList.contains(item.getId())).collect(Collectors.toList());
                    break;
                }
                case 3: {
                    List userInfo1 = (List)noEmptyList.get(0);
                    List userInfo2 = (List)noEmptyList.get(1);
                    List userInfo3 = (List)noEmptyList.get(2);
                    if (HussarUtils.isEmpty((Object)userInfo1) || HussarUtils.isEmpty((Object)userInfo2) || HussarUtils.isEmpty((Object)userInfo3)) {
                        return result;
                    }
                    Set userIdSet = userInfo1.stream().map(UserVo::getId).collect(Collectors.toSet());
                    Set userIdsTemp = userInfo2.stream().map(UserVo::getId).filter(userIdSet::contains).collect(Collectors.toSet());
                    if (HussarUtils.isEmpty(userIdsTemp)) {
                        return result;
                    }
                    result = userInfo3.stream().filter(item -> userIdsTemp.contains(item.getId())).collect(Collectors.toList());
                    break;
                }
            }
        }
        if (HussarUtils.isEmpty((Object)organIds) && HussarUtils.isEmpty(userIds) && HussarUtils.isEmpty((Object)roleIds) && HussarUtils.isNotEmpty((Object)otherOrganIds)) {
            userListForOrganTwo = this.getUserVoByOrganIds(otherOrganIds);
            if (HussarUtils.isEmpty(userListForOrganTwo)) {
                return result;
            }
            return userListForOrganTwo.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        }
        if (HussarUtils.isNotEmpty(result) && HussarUtils.isNotEmpty((Object)otherOrganIds)) {
            userListForOrganTwo = this.getUserVoByOrganIds(otherOrganIds);
            if (HussarUtils.isEmpty(userListForOrganTwo)) {
                return new ArrayList<UserVo>();
            }
            Set userIdList = result.stream().map(UserVo::getId).collect(Collectors.toSet());
            result = userListForOrganTwo.stream().filter(item -> userIdList.contains(item.getId())).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(result)) {
            return result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        }
        return result;
    }

    @Override
    public List<Long> getUserIdsForSort(List<Long> userIds, String sortSign) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIds);
        sortSign = HussarUtils.isBlank((CharSequence)sortSign) ? "asc" : sortSign;
        List users = this.sysUsersMapper.selectList((Wrapper)wrapper.orderBy(true, HussarUtils.equals((Object)sortSign, (Object)"asc"), SysUsers::getUserOrder));
        return users.stream().map(SysUsers::getId).collect(Collectors.toList());
    }

    private List<UserVo> getUserVoByOrganIds(List<Long> organIds) {
        List<UserVo> userListForOrgan = new ArrayList<UserVo>();
        List list = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds));
        if (HussarUtils.isNotEmpty((Object)list)) {
            List fidList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String fid : fidList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
            }
            List sysStrus = this.sysStruService.list((Wrapper)wrapper);
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            userListForOrgan = this.sysUsersMapper.getUserByOrganIds(struIdList);
        }
        return userListForOrgan;
    }

    @Override
    public Page<SearchUserVo> searchUsersAllowPinyin(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return this.localQueryUserMangerService.searchUsersAllowPinyin(pageInfo, queryUserDto);
    }

    @Override
    public List<UserStaffVo> getUserAndStaffList(List<Long> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<UserStaffVo>();
        }
        List<UserStaffVo> list = this.sysUsersMapper.getUserAndStaffList(userIds);
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        List<UserOrganPostVo> organs = this.sysStruUserMapper.getOrganByUserIdList(userIds);
        List<UserOrganPostVo> posts = this.sysUserPostMapper.getPostByUserIdList(userIds);
        Map<Long, List<UserOrganPostVo>> userIdOrganMap = organs.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        Map<Long, List<UserOrganPostVo>> userIdPostMap = posts.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (UserStaffVo userStaffVo : list) {
            Long userId = userStaffVo.getUserId();
            userStaffVo.setOrgans(userIdOrganMap.get(userId));
            userStaffVo.setPosts(userIdPostMap.get(userId));
        }
        return list;
    }

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTreeWithUserDept(UserOrganFeignDto userOrganFeignDto) {
        return this.hussarBaseUserBoAdapter.lazyOrganUserTreeWithUserDept(userOrganFeignDto);
    }
}

