/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.role.ISysRolesExternalAdapter;
import com.jxdinfo.hussar.authorization.adapter.user.IHussarBaseUserBoAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryGradeAdminRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryRoleDto;
import com.jxdinfo.hussar.authorization.permit.factory.UserRoleExpandFactory;
import com.jxdinfo.hussar.authorization.permit.manager.QueryRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateVo;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDataRightTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.GradeRoleListVo;
import com.jxdinfo.hussar.authorization.permit.vo.LoadRelatedRoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataRightFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataScopeFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.DefaultAllVisibleDataScope;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataRightService;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataScopeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryRoleManagerImpl")
public class QueryRoleManagerImpl
implements QueryRoleManager {
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private SysOrgManageService sysOrgManageService;
    @Autowired
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;
    @Autowired
    private SysRoleDataRightMapper sysRoleDataRightMapper;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysRolesExternalAdapter rolesExternalAdapter;
    @Resource
    private IHussarBaseUserBoAdapter hussarBaseUserBoAdapter;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    @Override
    public List<JSTreeModel> allRoleTree(Long appId) {
        Long nodeId = Constants.ROOT_NODE_PARENT;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            return TreeModelUtils.merge(this.getOrganRoleTree());
        }
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        String isSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            isSys = "0";
        }
        List<JSTreeModel> jsTreeModels = this.sysRoleGroupMapper.getRoleTreeWithApp(appId, isSys);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(nodeId);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        jsTreeModel.setId(Constants.ROLE_ROOT_ID);
        jsTreeModel.setType("isRoot");
        jsTreeModels.add(jsTreeModel);
        return TreeModelUtils.merge(jsTreeModels);
    }

    @Override
    public List<JSTreeModel> getOrganRoleTree() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ROLE_TREE.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        jsTreeModel.getState().put("isOrganRoleTree", true);
        jsTreeModel.getState().put("gradeDisabled", true);
        result.add(jsTreeModel);
        List<JSTreeModel> organRoleList = this.getGradeAdminOrganRoleTree();
        for (JSTreeModel treeModel : organRoleList) {
            treeModel.getState().put("isOrganRoleTree", true);
        }
        result.addAll(organRoleList);
        for (JSTreeModel model : result) {
            String type = model.getType();
            if ("ORGANROLE".equals(type)) {
                model.setState(false, false, false);
                continue;
            }
            model.setState(false, false, true);
        }
        return result;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getUserRoleTree(String id) {
        List sysUserRoles = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id));
        ArrayList<Long> roleIds = new ArrayList<Long>();
        HashSet<Long> roleGroupIds = new HashSet<Long>();
        for (SysUserRole userRole : sysUserRoles) {
            roleIds.add(userRole.getGrantedRole());
        }
        List sysRoles = this.sysRolesMapper.selectBatchIds(roleIds);
        List orderSysRoles = sysRoles.stream().sorted(Comparator.comparing(SysRoles::getRoleOrder)).collect(Collectors.toList());
        HashMap<Long, ArrayList<SysRoles>> map = new HashMap<Long, ArrayList<SysRoles>>();
        for (SysRoles role : orderSysRoles) {
            ArrayList<SysRoles> children = (ArrayList<SysRoles>)map.get(role.getGroupId());
            if (HussarUtils.isEmpty((Object)children)) {
                children = new ArrayList<SysRoles>();
                map.put(role.getGroupId(), children);
            }
            children.add(role);
            roleGroupIds.add(role.getGroupId());
        }
        List groups = this.sysRoleGroupMapper.selectBatchIds(roleGroupIds);
        List orderGroups = groups.stream().sorted(Comparator.comparing(SysRoleGroup::getGroupOrder)).collect(Collectors.toList());
        ArrayList<ReadOnlyRoleTreeVo> result = new ArrayList<ReadOnlyRoleTreeVo>();
        ReadOnlyRoleTreeVo root = new ReadOnlyRoleTreeVo();
        root.setId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        root.setParentId((Serializable)Long.valueOf(Long.parseLong("1")));
        root.setIcon("tree-com");
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        ArrayList<ReadOnlyRoleTreeVo> groupChildren = new ArrayList<ReadOnlyRoleTreeVo>();
        for (SysRoleGroup group : orderGroups) {
            ReadOnlyRoleTreeVo treeVo = new ReadOnlyRoleTreeVo();
            treeVo.setId((Serializable)group.getId());
            treeVo.setIcon("role-group-unify");
            treeVo.setHasChildren(Boolean.valueOf(true));
            treeVo.setLabel(group.getGroupName());
            treeVo.setParentId((Serializable)OrganConstants.ROOT_ORGAN_ID);
            List childrenRoles = (List)map.get(group.getId());
            ArrayList<ReadOnlyRoleTreeVo> children = new ArrayList<ReadOnlyRoleTreeVo>();
            ReadOnlyRoleTreeVo roleTreeVo = null;
            for (SysRoles role : childrenRoles) {
                roleTreeVo = new ReadOnlyRoleTreeVo();
                roleTreeVo.setId((Serializable)role.getId());
                roleTreeVo.setParentId((Serializable)group.getId());
                roleTreeVo.setLabel(role.getRoleName());
                roleTreeVo.setHasChildren(Boolean.valueOf(false));
                roleTreeVo.setIcon("role-unify");
                children.add(roleTreeVo);
            }
            treeVo.setChildren(children);
            groupChildren.add(treeVo);
        }
        root.setChildren(groupChildren);
        root.setHasChildren(Boolean.valueOf(true));
        result.add(root);
        return result;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getRoleTree(Long appId) {
        return this.rolesExternalAdapter.getRoleTree(appId);
    }

    @Override
    public Page<GradeRoleListVo> getGradeAdminRoleTree(PageInfo pageInfo, QueryGradeAdminRoleDto queryGradeAdminRoleDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        Long parentId = queryGradeAdminRoleDto.getParentId();
        if (HussarUtils.isEmpty((Object)parentId)) {
            SecurityUser currentUser = BaseSecurityUtil.getUser();
            parentId = currentUser.getDeptId();
        }
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(parentId);
        AssertUtil.isNotNull((Object)sysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_INFO.getMessage()));
        String struFid = sysStru.getStruFid();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("struFid", struFid);
        queryParams.put("name", queryGradeAdminRoleDto.getName());
        List<GradeRoleListVo> data = this.sysRolesMapper.getGradeAdminRoleTree(page, queryParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<LoadRelatedRoleVo> loadRelatedRole(List<FuncDumpDto> funcDumpDtoList) {
        ArrayList<LoadRelatedRoleVo> loadRelatedRoleVos = new ArrayList<LoadRelatedRoleVo>();
        if (HussarUtils.isEmpty(funcDumpDtoList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> funcIds = new ArrayList<Long>();
        ArrayList resIds = new ArrayList();
        for (FuncDumpDto funcDumpDto : funcDumpDtoList) {
            funcIds.add(funcDumpDto.getFuncId());
            List resIdList = funcDumpDto.getResIdList();
            if (!HussarUtils.isNotEmpty((Object)resIdList)) continue;
            resIds.addAll(resIdList);
        }
        List roleFunctions = new ArrayList();
        List roleResources = new ArrayList();
        List roleDataRights = new ArrayList();
        if (HussarUtils.isNotEmpty(funcIds)) {
            roleFunctions = this.sysRoleFunctionsService.selectRoleFunsByFunctionIds(funcIds);
            roleDataRights = this.sysRoleDataRightService.selectRoleDataRightsByFuncIds(funcIds);
        }
        if (HussarUtils.isNotEmpty(resIds)) {
            roleResources = this.sysRoleResourceService.selectRoleResByResIds(resIds);
        }
        HashSet roleIds = new HashSet();
        if (HussarUtils.isNotEmpty(roleFunctions)) {
            Set roleIdListByFunc = roleFunctions.stream().map(SysRoleFunctions::getRoleId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByFunc);
        }
        if (HussarUtils.isNotEmpty(roleResources)) {
            Set roleIdListByRes = roleResources.stream().map(SysRoleResource::getRoleId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByRes);
        }
        if (HussarUtils.isNotEmpty(roleDataRights)) {
            Set roleIdListByDataRight = roleDataRights.stream().map(SysRoleDataRight::getRoleId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByDataRight);
        }
        for (Long roleId : roleIds) {
            LoadRelatedRoleVo roleVo = new LoadRelatedRoleVo();
            roleVo.setRoleId(roleId.longValue());
            for (SysRoleFunctions sysRoleFunctions : roleFunctions) {
                if (!HussarUtils.equals((Object)sysRoleFunctions.getRoleId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getFuncIds())) {
                    roleVo.setFuncIds(new ArrayList());
                }
                roleVo.getFuncIds().add(sysRoleFunctions.getFunctionId());
            }
            for (SysRoleResource sysRoleResource : roleResources) {
                if (!HussarUtils.equals((Object)sysRoleResource.getRoleId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getResIds())) {
                    roleVo.setResIds(new ArrayList());
                }
                if (roleVo.getResIds().contains(sysRoleResource.getResourceId())) continue;
                roleVo.getResIds().add(sysRoleResource.getResourceId());
            }
            for (SysRoleDataRight sysRoleDataRight : roleDataRights) {
                if (!HussarUtils.equals((Object)sysRoleDataRight.getRoleId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getDataRightIds())) {
                    roleVo.setDataRightIds(new ArrayList());
                }
                roleVo.getDataRightIds().add(sysRoleDataRight.getDataRightsId());
            }
            loadRelatedRoleVos.add(roleVo);
        }
        return loadRelatedRoleVos;
    }

    @Override
    public List<SysRoles> getRoleByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : roleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoles::getId, (Object)id);
        }
        lambdaQueryWrapper.orderByAsc(SysRoles::getRoleOrder);
        return this.sysRolesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<SysRoles> getOrganRoleList(List<Long> organIds) {
        List sysOrganRoleList = this.sysStruRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, organIds));
        List roleIdList = sysOrganRoleList.stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList());
        return this.sysRolesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIdList));
    }

    @Override
    public List<SysRoleGroup> getRoleGroupByAppId(Long appId) {
        List roleGroups;
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        if (HussarUtils.isEmpty((Object)(roleGroups = this.sysRoleGroupMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId)).orderByAsc(SysRoleGroup::getGroupOrder))))) {
            return Collections.emptyList();
        }
        return roleGroups;
    }

    private List<JSTreeModel> getGradeAdminOrganRoleTree() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        Long organId = empolyeeId;
        JSTreeModel organ = new JSTreeModel();
        List childSysStruIdList = this.sysStruService.getChildOrgId(securityUser.getDeptId(), "01");
        List<JSTreeModel> roleLists = new ArrayList<JSTreeModel>();
        childSysStruIdList.add(securityUser.getDeptId());
        for (Long id : childSysStruIdList) {
            if (!id.equals(securityUser.getDeptId())) {
                organ = this.sysOrgManageService.getThisOneOrg(id);
                list.add(organ);
            }
            List<JSTreeModel> roleList = this.sysStruMapper.getRoleTree(id);
            if (ToolUtil.isEmpty(roleLists)) {
                roleLists = roleList;
                continue;
            }
            roleLists.addAll(roleList);
        }
        while (ToolUtil.isNotEmpty((Object)organ)) {
            organ = this.sysOrgManageService.getOneOrg(organId);
            if (!ToolUtil.isNotEmpty((Object)organ)) continue;
            organId = organ.getId();
            list.add(organ);
        }
        ArrayList<JSTreeModel> lists = list;
        list = roleLists;
        list.addAll(lists);
        return list;
    }

    @Override
    public List<FuncDataRightTreeVo> getFuncDataRightByRoleId(Long roleId) {
        List<Object> result = new ArrayList<FuncDataRightTreeVo>();
        List resourceTypeCodes = DataRightFactory.getResourceTypeCodes();
        resourceTypeCodes.add("res_rights");
        resourceTypeCodes.add("res_form_rights");
        List<FuncDataRightTreeVo> funcDataRightTreeVoList = this.sysRoleFunctionsMapper.getFuncDataRightByRoleId(roleId, resourceTypeCodes);
        if (ToolUtil.isNotEmpty(funcDataRightTreeVoList)) {
            TranslateUtil.translate(funcDataRightTreeVoList, AbstractNoIconHussarLazyTreeDefinition::getLabelLangKey, AbstractNoIconHussarLazyTreeDefinition::setLabel);
            this.putDataRightInFuncTree(roleId, funcDataRightTreeVoList);
            List allFunctionModuleList = this.sysFunctionModulesService.list();
            TranslateUtil.translate((List)allFunctionModuleList, SysFunctionModules::getNameLangKey, SysFunctionModules::setFunctionModuleName);
            List<Long> moduleIdList = funcDataRightTreeVoList.stream().map(item -> (Long)item.getParentId()).collect(Collectors.toList());
            result.addAll(this.getFuncDataRightModule(funcDataRightTreeVoList, moduleIdList, allFunctionModuleList));
            result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FuncDataRightTreeVo>(Comparator.comparing(AbstractNoIconHussarLazyTreeDefinition::getId))), ArrayList::new));
            return HussarTreeParser.getTreeList(result);
        }
        return result;
    }

    @Override
    public List<FuncDataRightTreeVo> getDataRightDetail(Long roleId) {
        List<Object> result = new ArrayList<FuncDataRightTreeVo>();
        List resourceTypeCodes = DataRightFactory.getResourceTypeCodes();
        resourceTypeCodes.add("res_rights");
        resourceTypeCodes.add("res_form_rights");
        List<FuncDataRightTreeVo> funcDataRightTreeVoList = this.sysRoleFunctionsMapper.getFuncDataRightByRoleId(roleId, resourceTypeCodes);
        if (ToolUtil.isNotEmpty(funcDataRightTreeVoList)) {
            TranslateUtil.translate(funcDataRightTreeVoList, AbstractNoIconHussarLazyTreeDefinition::getLabelLangKey, AbstractNoIconHussarLazyTreeDefinition::setLabel);
            this.putDataRightInFuncTree(roleId, funcDataRightTreeVoList);
            List allFunctionModuleList = this.sysFunctionModulesService.list();
            TranslateUtil.translate((List)allFunctionModuleList, SysFunctionModules::getNameLangKey, SysFunctionModules::setFunctionModuleName);
            funcDataRightTreeVoList.parallelStream().forEach(f -> f.setDataRights(f.getDataRights().stream().filter(item -> HussarUtils.isNotEmpty((Object)item.getDataRightsId())).collect(Collectors.toList())));
            if (HussarUtils.isNotEmpty(funcDataRightTreeVoList)) {
                List<Long> moduleIdList = funcDataRightTreeVoList.stream().map(item -> (Long)item.getParentId()).collect(Collectors.toList());
                result.addAll(this.getFuncDataRightModule(funcDataRightTreeVoList, moduleIdList, allFunctionModuleList));
                result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FuncDataRightTreeVo>(Comparator.comparing(AbstractNoIconHussarLazyTreeDefinition::getId))), ArrayList::new));
                return HussarTreeParser.getTreeList(result);
            }
        }
        return result;
    }

    private List<FuncDataRightTreeVo> getFuncDataRightModule(List<FuncDataRightTreeVo> result, List<Long> idList, List<SysFunctionModules> allFunctionModuleList) {
        if (idList.size() == 1 && idList.get(0) == 1L) {
            return result;
        }
        ArrayList<Long> parentIdList = new ArrayList();
        for (SysFunctionModules item : allFunctionModuleList) {
            if (!idList.contains(item.getId())) continue;
            FuncDataRightTreeVo funcDataRightTreeVo = new FuncDataRightTreeVo();
            funcDataRightTreeVo.setId((Serializable)item.getId());
            funcDataRightTreeVo.setSort(item.getSeq().intValue());
            funcDataRightTreeVo.setFuncFlag(false);
            funcDataRightTreeVo.setLabel(item.getFunctionModuleName());
            funcDataRightTreeVo.setParentId((Serializable)item.getParentModuleId());
            funcDataRightTreeVo.setHasChildren(Boolean.valueOf(true));
            funcDataRightTreeVo.setType("isModule");
            parentIdList.add(item.getParentModuleId());
            result.add(funcDataRightTreeVo);
        }
        parentIdList = parentIdList.stream().distinct().collect(Collectors.toList());
        return this.getFuncDataRightModule(result, parentIdList, allFunctionModuleList);
    }

    private void putDataRightInFuncTree(Long roleId, List<FuncDataRightTreeVo> treeVoList) {
        Map<Long, List<FuncDataRightTreeVo>> funcMap = treeVoList.stream().collect(Collectors.groupingBy(AbstractNoIconHussarLazyTreeDefinition::getId));
        treeVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FuncDataRightTreeVo>(Comparator.comparing(AbstractNoIconHussarLazyTreeDefinition::getId))), ArrayList::new));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleDataRight::getRoleId, (Object)roleId);
        List dataRightList = this.sysRoleDataRightMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<SysRoleDataRight>> dataRightMap = dataRightList.stream().collect(Collectors.groupingBy(SysRoleDataRight::getFunctionId));
        for (FuncDataRightTreeVo tree : treeVoList) {
            Set resTypeCodes = funcMap.get(tree.getId()).stream().map(FuncDataRightTreeVo::getResTypeCode).collect(Collectors.toSet());
            List<SysRoleDataRight> roleDataRights = dataRightMap.get(tree.getId());
            Map<Object, Object> resTypeMap = new HashMap();
            if (HussarUtils.isNotEmpty(roleDataRights)) {
                resTypeMap = roleDataRights.stream().collect(Collectors.toMap(SysRoleDataRight::getResTypeCode, r -> r));
            }
            ArrayList<DataRightVo> dataRightVos = new ArrayList<DataRightVo>();
            for (String code : resTypeCodes) {
                DataRightVo vo = new DataRightVo();
                SysRoleDataRight roleDataRight = (SysRoleDataRight)resTypeMap.get(code);
                vo.setDataRightsId(HussarUtils.isEmpty((Object)roleDataRight) ? null : roleDataRight.getDataRightsId());
                vo.setResTypeCode(code);
                if (HussarUtils.equals((Object)"res_rights", (Object)code) || HussarUtils.equals((Object)"res_form_rights", (Object)code)) {
                    vo.setScopeLabel(HussarUtils.isEmpty((Object)roleDataRight) ? "1" : String.valueOf(roleDataRight.getDataScope()));
                    vo.setScopeName(DataScopeEnum.of((Integer)Integer.parseInt(vo.getScopeLabel())).getDescription());
                    vo.setDataRightName(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DATA_PERMISSION_ON_PLATFORM.getMessage()));
                    if (HussarUtils.isNotEmpty((Object)roleDataRight) && HussarUtils.equals((Object)"6", (Object)String.valueOf(roleDataRight.getDataScope()))) {
                        Map customDataConditionMap = (Map)JSON.parseObject((String)roleDataRight.getCustomDataCondition(), (TypeReference)new TypeReference<Map<String, List<OptionVo>>>(){}, (Feature[])new Feature[0]);
                        vo.setDataRightDesc(((OptionVo)((List)customDataConditionMap.get("gradeOrganType")).get(0)).getValue());
                    }
                } else {
                    IDataRightService dataRightService = DataRightFactory.getDataRight((String)code);
                    vo.setDataRightName(dataRightService.name());
                    vo.setDataRightDesc(dataRightService.desc());
                    if (HussarUtils.isNotEmpty((Object)roleDataRight)) {
                        vo.setScopeLabel(roleDataRight.getDataScopeLabel());
                        IDataScopeService dataScopeService = DataScopeFactory.getDataScope((String)vo.getScopeLabel());
                        DefaultAllVisibleDataScope defaultAllVisibleDataScope = new DefaultAllVisibleDataScope();
                        if (HussarUtils.isNotEmpty((Object)dataScopeService)) {
                            vo.setScopeName(dataScopeService.name());
                        } else if (HussarUtils.equals((Object)defaultAllVisibleDataScope.label(), (Object)vo.getScopeLabel())) {
                            vo.setScopeName(defaultAllVisibleDataScope.name());
                        }
                    }
                }
                dataRightVos.add(vo);
            }
            tree.setDataRights(dataRightVos);
        }
    }

    @Override
    public List<Long> getUserRoles(Long userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_FIND.getMessage()));
        }
        List sysUserRoles = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        List<Long> roleIds = sysUserRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
        if (HussarUtils.isEmpty(roleIds)) {
            roleIds = new ArrayList();
        }
        roleIds.addAll(UserRoleExpandFactory.getRolesByExpand((Long)userId));
        roleIds = roleIds.stream().distinct().collect(Collectors.toList());
        return roleIds;
    }

    @Override
    public List<Long> getRoleIdsByFunctionId(Long funId) {
        return this.sysRolesMapper.getRoleIdsByFunctionId(funId);
    }

    @Override
    public List<RoleVo> getAppRole(Long appId, String roleType, String roleName) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)roleName));
        if (HussarUtils.equals((Object)roleType, (Object)"0")) {
            queryParams.put("appId", 1L);
            return this.sysRolesMapper.getAppRole(queryParams);
        }
        if (HussarUtils.isEmpty((Object)appId)) {
            return Collections.emptyList();
        }
        queryParams.put("appId", appId);
        return this.sysRolesMapper.getAppRole(queryParams);
    }

    @Override
    public Page<AppRoleRelateVo> searchAppRoleRelate(PageInfo pageInfo, Long roleId, String name, String relateType) {
        if (HussarUtils.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("roleId", roleId);
        queryParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryParams.put("relateType", relateType);
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<AppRoleRelateVo> result = this.sysRolesMapper.searchAppRoleRelate((Page<AppRoleRelateVo>)page, queryParams);
        if (HussarUtils.isEmpty(result)) {
            page.setRecords(Collections.emptyList());
            return page;
        }
        List userIds = result.stream().filter(relateVo -> HussarUtils.isNotEmpty((Object)relateVo.getOperatorId())).map(AppRoleRelateVo::getOperatorId).collect(Collectors.toList());
        Map userInfo = this.hussarBaseUserBoAdapter.getUserInfo(userIds);
        if (HussarUtils.isNotEmpty((Object)userInfo)) {
            for (AppRoleRelateVo relateVo2 : result) {
                SysUsers sysUsers = (SysUsers)userInfo.get(relateVo2.getOperatorId());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                relateVo2.setOperator(sysUsers.getUserName());
            }
        }
        page.setRecords(result);
        return page;
    }

    @Override
    public Boolean sameRoleName(String roleName, Long roleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        if (HussarUtils.isEmpty((Object)roleId)) {
            List sysRoles = this.sysRolesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)roleName)).eq(SysRoles::getFromAppId, (Object)appId));
            return HussarUtils.isEmpty((Object)sysRoles);
        }
        List sysRoles = this.sysRolesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)roleName)).ne(SysRoles::getId, (Object)roleId)).eq(SysRoles::getFromAppId, (Object)appId));
        return HussarUtils.isEmpty((Object)sysRoles);
    }

    @Override
    public AppRoleInfoVo appRoleView(Long roleId) {
        AppRoleInfoVo appRoleInfoVo = new AppRoleInfoVo();
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(roleId);
        BeanUtils.copyProperties((Object)role, (Object)appRoleInfoVo);
        appRoleInfoVo.setAppId(role.getFromAppId());
        return appRoleInfoVo;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getAppRoleTree(Long appId) {
        ArrayList<ReadOnlyRoleTreeVo> result = new ArrayList<ReadOnlyRoleTreeVo>();
        List<SysRoleGroup> groups = this.sysRoleGroupMapper.getRoleGroupForFromAppId(appId);
        List<SysRoles> sysRoles = this.sysRolesMapper.getRoleForFromAppId(appId);
        HashMap<Long, ArrayList<SysRoles>> map = new HashMap<Long, ArrayList<SysRoles>>();
        for (SysRoles role : sysRoles) {
            ArrayList<SysRoles> children = (ArrayList<SysRoles>)map.get(role.getGroupId());
            if (HussarUtils.isEmpty((Object)children)) {
                children = new ArrayList<SysRoles>();
                map.put(role.getGroupId(), children);
            }
            children.add(role);
        }
        ReadOnlyRoleTreeVo root = new ReadOnlyRoleTreeVo();
        root.setId((Serializable)Long.valueOf(Long.parseLong("1")));
        root.setParentId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        root.setIcon("tree-com");
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        root.setType("root");
        ArrayList<ReadOnlyRoleTreeVo> groupChildren = new ArrayList<ReadOnlyRoleTreeVo>();
        for (SysRoleGroup group : groups) {
            ReadOnlyRoleTreeVo treeVo = new ReadOnlyRoleTreeVo();
            treeVo.setId((Serializable)group.getId());
            treeVo.setIcon("role-group-unify");
            treeVo.setLabel(group.getGroupName());
            treeVo.setParentId((Serializable)Long.valueOf(Long.parseLong("1")));
            treeVo.setType("group");
            treeVo.setDescription(group.getGroupAlias());
            List childrenRoles = (List)map.get(group.getId());
            ArrayList<ReadOnlyRoleTreeVo> children = new ArrayList<ReadOnlyRoleTreeVo>();
            ReadOnlyRoleTreeVo roleTreeVo = null;
            if (HussarUtils.isNotEmpty((Object)childrenRoles)) {
                treeVo.setHasChildren(Boolean.valueOf(true));
                for (SysRoles role : childrenRoles) {
                    roleTreeVo = new ReadOnlyRoleTreeVo();
                    roleTreeVo.setId((Serializable)role.getId());
                    roleTreeVo.setParentId((Serializable)group.getId());
                    roleTreeVo.setLabel(role.getRoleName());
                    roleTreeVo.setHasChildren(Boolean.valueOf(false));
                    roleTreeVo.setIcon("role-unify");
                    roleTreeVo.setType("role");
                    roleTreeVo.setDescription(role.getRoleAlias());
                    children.add(roleTreeVo);
                }
            }
            treeVo.setChildren(children);
            groupChildren.add(treeVo);
        }
        root.setChildren(groupChildren);
        if (HussarUtils.isNotEmpty(groupChildren)) {
            root.setHasChildren(Boolean.valueOf(true));
        }
        result.add(root);
        return result;
    }

    @Override
    public Page<RoleVo> searchRole(PageInfo pageInfo, QueryRoleDto queryRoleDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)queryRoleDto.getRoleName()));
        queryParams.put("fromAppId", queryRoleDto.getAppId());
        List<RoleVo> data = this.sysRolesMapper.searchRole((Page<RoleVo>)page, queryParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<SysRoles> getRolesFilterAppDevRole(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        return this.sysRolesMapper.getRolesFilterAppDevRole(roleIds);
    }

    @Override
    public List<AppRoleRelateInfoVo> searchAppRoleRelateByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return new ArrayList<AppRoleRelateInfoVo>();
        }
        ArrayList<AppRoleRelateInfoVo> resultList = new ArrayList<AppRoleRelateInfoVo>();
        List<AppRoleRelateVo> result = this.sysRolesMapper.searchAppRoleRelateByRoleIds(roleIds);
        if (HussarUtils.isEmpty(result)) {
            for (Long roleId : roleIds) {
                AppRoleRelateInfoVo appRoleRelateInfoVo = new AppRoleRelateInfoVo();
                appRoleRelateInfoVo.setRoleId(roleId);
                appRoleRelateInfoVo.setMemberList(new ArrayList());
                resultList.add(appRoleRelateInfoVo);
            }
            return resultList;
        }
        List userIds = result.stream().filter(relateVo -> HussarUtils.isNotEmpty((Object)relateVo.getOperatorId())).map(AppRoleRelateVo::getOperatorId).collect(Collectors.toList());
        Map userInfo = this.hussarBaseUserBoAdapter.getUserInfo(userIds);
        if (HussarUtils.isNotEmpty((Object)userInfo)) {
            for (AppRoleRelateVo relateVo2 : result) {
                SysUsers sysUsers = (SysUsers)userInfo.get(relateVo2.getOperatorId());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                relateVo2.setOperator(sysUsers.getUserName());
            }
        }
        Map<Long, List<AppRoleRelateVo>> map = result.stream().collect(Collectors.groupingBy(AppRoleRelateVo::getRoleId));
        for (Long roleId : roleIds) {
            AppRoleRelateInfoVo appRoleRelateInfoVo = new AppRoleRelateInfoVo();
            appRoleRelateInfoVo.setRoleId(roleId);
            ArrayList voList = map.get(roleId);
            appRoleRelateInfoVo.setMemberList((List)(HussarUtils.isNotEmpty(voList) ? voList : new ArrayList()));
            resultList.add(appRoleRelateInfoVo);
        }
        return resultList;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getRoleTreeWithUserDept(Long appId) {
        return this.rolesExternalAdapter.getRoleTreeWithUserDept(appId);
    }
}

